/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.magalie.services.service;

import com.franciaflex.magalie.persistence.JpaMagaliePersistenceContext;
import com.franciaflex.magalie.persistence.dao.ArticleJpaDao;
import com.franciaflex.magalie.persistence.dao.LocationJpaDao;
import com.franciaflex.magalie.persistence.dao.PreparedArticleReceptionJpaDao;
import com.franciaflex.magalie.persistence.dao.StoredArticleJpaDao;
import com.franciaflex.magalie.persistence.entity.Article;
import com.franciaflex.magalie.persistence.entity.Building;
import com.franciaflex.magalie.persistence.entity.Company;
import com.franciaflex.magalie.persistence.entity.Location;
import com.franciaflex.magalie.persistence.entity.PreparedArticleReception;
import com.franciaflex.magalie.persistence.entity.StoredArticle;
import com.franciaflex.magalie.services.MagalieService;
import com.franciaflex.magalie.services.MagalieServiceContext;
import com.franciaflex.magalie.services.exception.InvalidMagalieBarcodeException;
import com.franciaflex.magalie.services.exception.PreparedArticleReceptionAlreadyStoredException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MagalieBarcodeService
implements MagalieService {
    private static final Log log = LogFactory.getLog(MagalieBarcodeService.class);
    protected MagalieServiceContext serviceContext;

    @Override
    public void setServiceContext(MagalieServiceContext serviceContext) {
        this.serviceContext = serviceContext;
    }

    public Article getArticle(String articleBarcode, Company company) throws InvalidMagalieBarcodeException {
        ArticleJpaDao articleDao = this.serviceContext.getPersistenceContext().getArticleDao();
        Article article = articleDao.findByCode(articleBarcode, company);
        if (article == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("no article with code " + articleBarcode + " for company " + company));
            }
            throw new InvalidMagalieBarcodeException("no article with code " + articleBarcode + " for company " + company);
        }
        return article;
    }

    public Location getLocation(String locationBarcode, Building building) throws InvalidMagalieBarcodeException {
        JpaMagaliePersistenceContext persistenceContext = this.serviceContext.getPersistenceContext();
        LocationJpaDao locationDao = persistenceContext.getLocationDao();
        Location location = locationDao.findByBarcode(locationBarcode, building);
        if (location == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("no location with code " + locationBarcode + " in building " + building));
            }
            throw new InvalidMagalieBarcodeException("no location with code " + locationBarcode + " in building " + building);
        }
        return location;
    }

    public PreparedArticleReception getPreparedArticleReception(Building building, String barcode) throws InvalidMagalieBarcodeException, PreparedArticleReceptionAlreadyStoredException {
        Article article;
        JpaMagaliePersistenceContext persistenceContext = this.serviceContext.getPersistenceContext();
        PreparedArticleReceptionJpaDao dao = persistenceContext.getPreparedArticleReceptionDao();
        PreparedArticleReception preparedArticleReception = dao.findByBarcode(barcode);
        if (preparedArticleReception == null) {
            throw new InvalidMagalieBarcodeException("'" + barcode + "' is not a existing prepared article reception");
        }
        StoredArticleJpaDao storedArticleDao = persistenceContext.getStoredArticleDao();
        StoredArticle storedArticle = storedArticleDao.findInReception(building, article = preparedArticleReception.getArticle());
        if (storedArticle == null) {
            throw new PreparedArticleReceptionAlreadyStoredException(preparedArticleReception);
        }
        return preparedArticleReception;
    }
}

