/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.magalie.services.service;

import com.franciaflex.magalie.persistence.JpaMagaliePersistenceContext;
import com.franciaflex.magalie.persistence.dao.LocationErrorJpaDao;
import com.franciaflex.magalie.persistence.dao.StoredArticleJpaDao;
import com.franciaflex.magalie.persistence.entity.Article;
import com.franciaflex.magalie.persistence.entity.Location;
import com.franciaflex.magalie.persistence.entity.LocationError;
import com.franciaflex.magalie.persistence.entity.MagalieUser;
import com.franciaflex.magalie.persistence.entity.StoredArticle;
import com.franciaflex.magalie.services.MagalieService;
import com.franciaflex.magalie.services.MagalieServiceContext;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jpa.api.JpaEntity;

public class LocationErrorsService
implements MagalieService {
    private static final Log log = LogFactory.getLog(LocationErrorsService.class);
    protected MagalieServiceContext serviceContext;

    @Override
    public void setServiceContext(MagalieServiceContext serviceContext) {
        this.serviceContext = serviceContext;
    }

    public void reportError(Location location, Article article, MagalieUser magalieUser) {
        Date reportDate = this.serviceContext.getNow();
        this.reportError(location, article, magalieUser, reportDate);
    }

    public void reportError(String storedArticleId, MagalieUser magalieUser) {
        Preconditions.checkArgument((storedArticleId != null ? 1 : 0) != 0);
        JpaMagaliePersistenceContext persistenceContext = this.serviceContext.getPersistenceContext();
        StoredArticleJpaDao storedArticleDao = persistenceContext.getStoredArticleDao();
        StoredArticle storedArticle = (StoredArticle)storedArticleDao.findById(storedArticleId);
        this.reportError(storedArticle.getLocation(), storedArticle.getArticle(), magalieUser);
    }

    public void reportError(Location location, Article article, MagalieUser magalieUser, Date reportDate) {
        LocationErrorJpaDao locationErrorDao = this.serviceContext.getPersistenceContext().getLocationErrorDao();
        LocationError existingLocationError = locationErrorDao.findByLocation(location);
        if (existingLocationError == null) {
            LocationError newLocationError = new LocationError();
            newLocationError.setMagalieUser(magalieUser);
            newLocationError.setLocation(location);
            newLocationError.setArticle(article);
            newLocationError.setReportDate(reportDate);
            locationErrorDao.persist((JpaEntity)newLocationError);
            this.serviceContext.getPersistenceContext().commit();
            if (log.isInfoEnabled()) {
                log.info((Object)("reported error on location: " + newLocationError));
            }
        } else if (log.isInfoEnabled()) {
            log.info((Object)("error on location " + location + " already reported, nothing saved"));
        }
    }

    public List<LocationError> getAllLocationErrors() {
        LocationErrorJpaDao locationErrorDao = this.serviceContext.getPersistenceContext().getLocationErrorDao();
        List allLocationErrors = locationErrorDao.findAll();
        return allLocationErrors;
    }

    protected Predicate<Location> getLocationNotReportedInErrorPredicate(Article article) {
        LocationErrorJpaDao locationErrorDao = this.serviceContext.getPersistenceContext().getLocationErrorDao();
        List allLocationsInErrorForArticle = locationErrorDao.findAllLocationsInError(article);
        return Predicates.not((Predicate)Predicates.in((Collection)allLocationsInErrorForArticle));
    }

    protected Iterable<StoredArticle> filterLocationInError(Iterable<StoredArticle> storedArticles) {
        LinkedList result = Lists.newLinkedList();
        LocationErrorJpaDao locationErrorDao = this.serviceContext.getPersistenceContext().getLocationErrorDao();
        for (StoredArticle storedArticle : storedArticles) {
            ImmutableMap properties = ImmutableMap.of((Object)"article", (Object)storedArticle.getArticle(), (Object)"location", (Object)storedArticle.getLocation());
            LocationError locationError = (LocationError)locationErrorDao.findByProperties((Map)properties);
            if (locationError == null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("no location error reported for " + storedArticle));
                }
                result.add(storedArticle);
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("removing stored article " + storedArticle + " due to location error " + locationError));
        }
        return result;
    }
}

