/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.magalie.services.service;

import com.franciaflex.magalie.persistence.JpaMagaliePersistenceContext;
import com.franciaflex.magalie.persistence.dao.ArticleJpaDao;
import com.franciaflex.magalie.persistence.dao.BuildingJpaDao;
import com.franciaflex.magalie.persistence.dao.CompanyJpaDao;
import com.franciaflex.magalie.persistence.dao.KanbanJpaDao;
import com.franciaflex.magalie.persistence.dao.LocationJpaDao;
import com.franciaflex.magalie.persistence.dao.MagalieUserJpaDao;
import com.franciaflex.magalie.persistence.dao.PreparedArticleReceptionJpaDao;
import com.franciaflex.magalie.persistence.dao.RequestedArticleJpaDao;
import com.franciaflex.magalie.persistence.dao.RequestedListJpaDao;
import com.franciaflex.magalie.persistence.dao.StoredArticleJpaDao;
import com.franciaflex.magalie.persistence.dao.SupplierJpaDao;
import com.franciaflex.magalie.persistence.dao.WarehouseJpaDao;
import com.franciaflex.magalie.persistence.entity.Article;
import com.franciaflex.magalie.persistence.entity.Building;
import com.franciaflex.magalie.persistence.entity.Company;
import com.franciaflex.magalie.persistence.entity.Kanban;
import com.franciaflex.magalie.persistence.entity.Location;
import com.franciaflex.magalie.persistence.entity.MagalieUser;
import com.franciaflex.magalie.persistence.entity.PreparedArticleReception;
import com.franciaflex.magalie.persistence.entity.RequestedArticle;
import com.franciaflex.magalie.persistence.entity.RequestedList;
import com.franciaflex.magalie.persistence.entity.StoredArticle;
import com.franciaflex.magalie.persistence.entity.Supplier;
import com.franciaflex.magalie.persistence.entity.Warehouse;
import com.franciaflex.magalie.services.MagalieFixtures;
import com.franciaflex.magalie.services.MagalieService;
import com.franciaflex.magalie.services.MagalieServiceContext;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jpa.api.JpaEntity;

public class FixturesService
implements MagalieService {
    private static final Log log = LogFactory.getLog(FixturesService.class);
    protected MagalieServiceContext serviceContext;
    protected Map<String, MagalieFixtures> fixtureSets = Maps.newHashMap();

    @Override
    public void setServiceContext(MagalieServiceContext serviceContext) {
        this.serviceContext = serviceContext;
    }

    public MagalieFixtures cleanDatabaseAndLoadFixtures(String fixturesSetName) {
        return this.loadFixtures(fixturesSetName, true);
    }

    public MagalieFixtures loadFixtures(String fixturesSetName) {
        return this.loadFixtures(fixturesSetName, false);
    }

    protected MagalieFixtures loadFixtures(String fixturesSetName, boolean cleanDatabase) {
        boolean devMode = this.serviceContext.getMagalieApplicationConfig().isDevMode();
        Preconditions.checkState((boolean)devMode);
        MagalieFixtures fixtures = this.fixtureSets.get(fixturesSetName);
        if (fixtures == null) {
            fixtures = new MagalieFixtures(fixturesSetName);
            this.fixtureSets.put(fixturesSetName, fixtures);
            if (log.isInfoEnabled()) {
                log.info((Object)"will restore database with fixture set");
            }
            JpaMagaliePersistenceContext persistenceContext = this.serviceContext.getPersistenceContext();
            if (cleanDatabase) {
                persistenceContext.clearDatabase();
            }
            CompanyJpaDao companyDao = persistenceContext.getCompanyDao();
            Collection companies = (Collection)fixtures.fixture("companies");
            for (Company company : companies) {
                companyDao.persist((JpaEntity)company);
            }
            MagalieUserJpaDao magalieUserDao = persistenceContext.getMagalieUserDao();
            Collection users = (Collection)fixtures.fixture("users");
            for (MagalieUser user : users) {
                magalieUserDao.persist((JpaEntity)user);
            }
            BuildingJpaDao buildingDao = persistenceContext.getBuildingDao();
            Collection buildings = (Collection)fixtures.fixture("buildings");
            for (Building building : buildings) {
                buildingDao.persist((JpaEntity)building);
            }
            WarehouseJpaDao warehouseDao = persistenceContext.getWarehouseDao();
            Collection warehouses = (Collection)fixtures.fixture("warehouses");
            for (Warehouse warehouse : warehouses) {
                warehouseDao.persist((JpaEntity)warehouse);
            }
            LocationJpaDao locationDao = persistenceContext.getLocationDao();
            Collection locations = (Collection)fixtures.fixture("locations");
            for (Location location : locations) {
                locationDao.persist((JpaEntity)location);
            }
            SupplierJpaDao supplierDao = persistenceContext.getSupplierDao();
            Collection suppliers = (Collection)fixtures.fixture("suppliers");
            for (Supplier supplier : suppliers) {
                supplierDao.persist((JpaEntity)supplier);
            }
            ArticleJpaDao articleDao = persistenceContext.getArticleDao();
            Collection articles = (Collection)fixtures.fixture("articles");
            for (Article article : articles) {
                articleDao.persist((JpaEntity)article);
            }
            KanbanJpaDao kanbanDao = persistenceContext.getKanbanDao();
            Collection kanbans = (Collection)fixtures.fixture("kanbans");
            for (Kanban kanban : kanbans) {
                kanbanDao.persist((JpaEntity)kanban);
            }
            StoredArticleJpaDao storedArticleDao = persistenceContext.getStoredArticleDao();
            Collection storedArticles = (Collection)fixtures.fixture("storedArticles");
            for (StoredArticle storedArticle : storedArticles) {
                storedArticleDao.persist((JpaEntity)storedArticle);
            }
            RequestedListJpaDao requestedListDao = persistenceContext.getRequestedListDao();
            Collection requestedLists = (Collection)fixtures.fixture("requestedLists");
            for (RequestedList requestedList : requestedLists) {
                requestedListDao.persist((JpaEntity)requestedList);
            }
            RequestedArticleJpaDao requestedArticleDao = persistenceContext.getRequestedArticleDao();
            Collection requestedArticles = (Collection)fixtures.fixture("requestedArticles");
            for (RequestedArticle requestedArticle : requestedArticles) {
                requestedArticleDao.persist((JpaEntity)requestedArticle);
            }
            PreparedArticleReceptionJpaDao preparedArticleReceptionDao = persistenceContext.getPreparedArticleReceptionDao();
            Collection preparedArticleReceptions = (Collection)fixtures.fixture("preparedArticleReceptions");
            for (PreparedArticleReception preparedArticleReception : preparedArticleReceptions) {
                preparedArticleReceptionDao.persist((JpaEntity)preparedArticleReception);
            }
            persistenceContext.commit();
        }
        return fixtures;
    }
}

