/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.magalie.services;

import com.esotericsoftware.yamlbeans.YamlException;
import com.esotericsoftware.yamlbeans.YamlReader;
import com.franciaflex.magalie.MagalieTechnicalException;
import com.franciaflex.magalie.persistence.entity.Article;
import com.franciaflex.magalie.persistence.entity.Building;
import com.franciaflex.magalie.persistence.entity.Company;
import com.franciaflex.magalie.persistence.entity.Kanban;
import com.franciaflex.magalie.persistence.entity.Location;
import com.franciaflex.magalie.persistence.entity.MagalieUser;
import com.franciaflex.magalie.persistence.entity.PreparedArticleReception;
import com.franciaflex.magalie.persistence.entity.RequestedArticle;
import com.franciaflex.magalie.persistence.entity.RequestedList;
import com.franciaflex.magalie.persistence.entity.StoredArticle;
import com.franciaflex.magalie.persistence.entity.Supplier;
import com.franciaflex.magalie.persistence.entity.Warehouse;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;

public class MagalieFixtures {
    protected Map<String, Object> fixtures;

    public MagalieFixtures(String fixturesName) {
        String yaml;
        String yamlPath = "/" + fixturesName + ".yaml";
        InputStream inputStream = MagalieFixtures.class.getResourceAsStream(yamlPath);
        try {
            yaml = IOUtils.toString((InputStream)inputStream, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(fixturesName + " is not a valid fixtures set name", e);
        }
        YamlReader reader = new YamlReader(yaml);
        reader.getConfig().setClassTag("company", Company.class);
        reader.getConfig().setClassTag("building", Building.class);
        reader.getConfig().setClassTag("warehouse", Warehouse.class);
        reader.getConfig().setClassTag("supplier", Supplier.class);
        reader.getConfig().setClassTag("article", Article.class);
        reader.getConfig().setClassTag("kanban", Kanban.class);
        reader.getConfig().setClassTag("stored-article", StoredArticle.class);
        reader.getConfig().setClassTag("user", MagalieUser.class);
        reader.getConfig().setClassTag("requested-article", RequestedArticle.class);
        reader.getConfig().setClassTag("requested-list", RequestedList.class);
        reader.getConfig().setClassTag("location", Location.class);
        reader.getConfig().setClassTag("prepared-article-reception", PreparedArticleReception.class);
        try {
            this.fixtures = (Map)reader.read();
        }
        catch (YamlException e) {
            throw new MagalieTechnicalException("unable to read yaml file", (Throwable)e);
        }
    }

    public <E> E fixture(String id) {
        return (E)this.fixtures.get(id);
    }
}

