/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.content.reply.actions;

import com.franciaflex.faxtomail.persistence.entities.AttachmentFile;
import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.services.FaxToMailServiceContext;
import com.franciaflex.faxtomail.services.service.EmailService;
import com.franciaflex.faxtomail.ui.swing.actions.AbstractFaxToMailAction;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.content.reply.ReplyAttachmentModel;
import com.franciaflex.faxtomail.ui.swing.content.reply.ReplyFormUI;
import com.franciaflex.faxtomail.ui.swing.content.reply.ReplyFormUIHandler;
import com.franciaflex.faxtomail.ui.swing.content.reply.ReplyFormUIModel;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ReplyAction
extends AbstractFaxToMailAction<ReplyFormUIModel, ReplyFormUI, ReplyFormUIHandler> {
    private static final Log log = LogFactory.getLog(ReplyAction.class);

    public ReplyAction(ReplyFormUIHandler handler) {
        super(handler, false);
        this.setActionDescription(I18n.t((String)"faxtomail.action.reply.tip", (Object[])new Object[0]));
    }

    @Override
    public void doAction() throws Exception {
        ReplyFormUIModel model = (ReplyFormUIModel)this.getModel();
        FaxToMailServiceContext serviceContext = this.getContext().newServiceContext();
        EmailService emailService = serviceContext.getEmailService();
        DemandeUIModel originalDemand = ((ReplyFormUIModel)this.getModel()).getOriginalDemand();
        Collection attachmentFiles = Collections2.transform(model.getAttachments(), (Function)new Function<ReplyAttachmentModel, AttachmentFile>(){

            public AttachmentFile apply(ReplyAttachmentModel replyAttachmentModel) {
                return replyAttachmentModel.getAttachmentFile();
            }
        });
        Email email = emailService.reply(model.getFrom(), model.getTo(), model.getCc(), model.getCci(), model.getSubject(), model.getMessage(), model.getStamp(), attachmentFiles, originalDemand.getTopiaId(), this.getContext().getCurrentUser());
        originalDemand.fromEntityIncluding(email, Sets.newHashSet((Object[])new String[]{"replies", "history"}));
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        ((ReplyFormUIHandler)this.handler).closeFrame();
    }
}

