/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.content.search;

import com.franciaflex.faxtomail.persistence.entities.Client;
import com.franciaflex.faxtomail.persistence.entities.DemandStatus;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.HasLabel;
import com.franciaflex.faxtomail.persistence.entities.MailField;
import com.franciaflex.faxtomail.ui.swing.FaxToMailUIContext;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI;
import com.franciaflex.faxtomail.ui.swing.content.search.SearchUIModel;
import com.franciaflex.faxtomail.ui.swing.content.search.actions.GroupAction;
import com.franciaflex.faxtomail.ui.swing.content.search.actions.SearchToGroupAction;
import com.franciaflex.faxtomail.ui.swing.util.AbstractFaxToMailDemandListHandler;
import com.franciaflex.faxtomail.ui.swing.util.DemandeTableModel;
import com.franciaflex.faxtomail.ui.swing.util.PaginationComboModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.ApplicationUI;
import org.nuiton.jaxx.application.swing.action.AbstractApplicationAction;
import org.nuiton.jaxx.application.swing.util.Cancelable;
import org.nuiton.util.pagination.PaginationParameter;

public class SearchToGroupUIHandler
extends AbstractFaxToMailDemandListHandler<SearchUIModel, SearchToGroupUI>
implements Cancelable {
    private static final Log log = LogFactory.getLog(SearchToGroupUIHandler.class);
    protected List<MailField> tableColumns;

    public void beforeInit(SearchToGroupUI ui) {
        super.beforeInit((ApplicationUI)ui);
        SearchUIModel searchUIModel = new SearchUIModel();
        Date now = new Date();
        Calendar cal = Calendar.getInstance();
        cal.add(2, -2);
        Date twoMonthsAgo = cal.getTime();
        searchUIModel.setMaxReceptionDate(now);
        searchUIModel.setMinReceptionDate(twoMonthsAgo);
        List allowedClients = ui.getContextValue(List.class, "allowedClients");
        searchUIModel.setAllowedClients(allowedClients);
        ((SearchToGroupUI)this.getUI()).setContextValue(searchUIModel);
    }

    protected JComponent getComponentToFocus() {
        return null;
    }

    public void afterInit(SearchToGroupUI ui) {
        this.initUI(ui);
        List<FaxToMailUser> users = this.getContext().getFaxtomailUserCache();
        SearchUIModel model = (SearchUIModel)((Object)this.getModel());
        this.initBeanFilterableComboBox(ui.getTakenByComboBox(), users, model.getTakenBy());
        this.initBeanFilterableComboBox(ui.getModifiedByComboBox(), users, model.getModifiedBy());
        this.initBeanFilterableComboBox(ui.getArchivedByComboBox(), users, model.getArchivedBy());
        this.initBeanFilterableComboBox(ui.getTransferByComboBox(), users, model.getTransferBy());
        this.initBeanFilterableComboBox(ui.getPrintedByComboBox(), users, model.getPrintingBy());
        this.initBeanFilterableComboBox(ui.getRepliedByComboBox(), users, model.getReplyBy());
        BeanFilterableComboBox<Client> clientComboBox = ui.getClientComboBox();
        clientComboBox.getComboBoxModel().setWildcardCharacter(null);
        this.initBeanFilterableComboBox(clientComboBox, model.getAllowedClients(), model.getClient());
        this.initCheckBoxComboBox(ui.getDocTypeComboBox(), this.getContext().getDemandTypeCache(), model.getDemandType(), "demandType", true);
        this.initCheckBoxComboBox(ui.getPriorityComboBox(), this.getContext().getPriorityCache(), model.getPriority(), "priority", true);
        this.initCheckBoxComboBox(ui.getWaitingStateComboBox(), this.getContext().getWaitingStateCache(), model.getWaitingStates(), "WaitingStates", true);
        this.initCheckBoxComboBox(ui.getStatusComboBox(), Arrays.asList(DemandStatus.values()), model.getDemandStatus(), "demandStatus", false);
        this.initCheckBoxComboBox(ui.getGammeComboBox(), this.getContext().getRangeCache(), model.getGamme(), "gamme", false);
        final JXTable dataTable = ((SearchToGroupUI)this.getUI()).getDataTable();
        dataTable.setSelectionMode(0);
        this.initDemandeTable(dataTable, true);
        model.addPropertyChangeListener("results", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                int row;
                List emails = (List)evt.getNewValue();
                DemandeTableModel dataTableModel = (DemandeTableModel)dataTable.getModel();
                dataTableModel.setRows(emails);
                DemandeUIModel currentEmail = SearchToGroupUIHandler.this.getContext().getCurrentEmail();
                if (currentEmail != null && (row = dataTableModel.getRowIndex(currentEmail)) > 0) {
                    dataTable.setRowSelectionInterval(row, row);
                }
            }
        });
        dataTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ListSelectionModel selectionModel = (ListSelectionModel)e.getSource();
                    SearchUIModel model = (SearchUIModel)((Object)SearchToGroupUIHandler.this.getModel());
                    int selectedIndex = selectionModel.getLeadSelectionIndex();
                    selectedIndex = dataTable.convertRowIndexToModel(selectedIndex);
                    DemandeTableModel dataTableModel = (DemandeTableModel)dataTable.getModel();
                    DemandeUIModel selectedModel = selectedIndex < 0 ? null : dataTableModel.getEntry(selectedIndex);
                    model.setGroupEnabled(!selectionModel.isSelectionEmpty() && SearchToGroupUIHandler.this.isDemandSelectable(selectedModel));
                }
            }
        });
        HighlightPredicate rowAlreadyInGroupPredicate = new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                int viewRow = adapter.row;
                int modelRow = adapter.convertRowIndexToModel(viewRow);
                DemandeTableModel dataTableModel = (DemandeTableModel)dataTable.getModel();
                DemandeUIModel row = dataTableModel.getEntry(modelRow);
                return !SearchToGroupUIHandler.this.isDemandSelectable(row);
            }
        };
        dataTable.addHighlighter((Highlighter)new ColorHighlighter(rowAlreadyInGroupPredicate, null, Color.GRAY, Color.GRAY, Color.WHITE));
        ui.getResultPerPageCombo().setModel(new PaginationComboModel());
        int resultPerPage = this.getConfig().getResultPerPage();
        ui.getModel().setResultPerPage(resultPerPage);
        ui.getResultPerPageCombo().setSelectedItem(resultPerPage);
        ui.getResultPerPageCombo().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SearchToGroupUIHandler.this.updateResultPerPage(e);
            }
        });
        this.getContext().getSwingSession().add((Component)ui, true);
    }

    protected void initTextField(JTextField jTextField) {
        super.initTextField(jTextField);
        jTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchToGroupUIHandler.this.searchDemandes();
            }
        });
    }

    @Override
    protected <HL extends HasLabel> void initCheckBoxComboBox(JComboBox<HL> comboBox, List<HL> values, List<HL> selection, String property, boolean addNull) {
        super.initCheckBoxComboBox(comboBox, values, selection, property, addNull);
        comboBox.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SearchToGroupUIHandler.this.searchDemandes();
                }
            }
        });
    }

    protected void initDatePicker(JXDatePicker picker) {
        super.initDatePicker(picker);
        picker.getEditor().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SearchToGroupUIHandler.this.searchDemandes();
                }
            }
        });
    }

    public void searchDemandes() {
        ((SearchUIModel)((Object)this.getModel())).resetPaginationParameter();
        this.runSearchAction();
    }

    public void goToNextPage() {
        ((SearchUIModel)((Object)this.getModel())).setPaginationParameter(((SearchUIModel)((Object)this.getModel())).getPaginationResult().getNextPage());
        this.runSearchAction();
    }

    public void goToPreviousPage() {
        ((SearchUIModel)((Object)this.getModel())).setPaginationParameter(((SearchUIModel)((Object)this.getModel())).getPaginationResult().getPreviousPage());
        this.runSearchAction();
    }

    public void updateResultPerPage(ItemEvent event) {
        if (event.getStateChange() == 1) {
            int resultPerPage = (Integer)event.getItem();
            this.getConfig().setResultPerPage(resultPerPage);
            this.getConfig().save();
            ((SearchUIModel)((Object)this.getModel())).setResultPerPage(resultPerPage);
            ((SearchUIModel)((Object)this.getModel())).resetPaginationParameter();
            if (CollectionUtils.isNotEmpty(((SearchUIModel)((Object)this.getModel())).getResults())) {
                this.runSearchAction();
            }
        }
    }

    protected void runSearchAction() {
        FaxToMailUIContext context = this.getContext();
        PaginationParameter currentPaginationParameter = context.getCurrentPaginationParameter();
        if (currentPaginationParameter != null) {
            ((SearchUIModel)((Object)this.getModel())).setPaginationParameter(currentPaginationParameter);
            context.setCurrentPaginationParameter(null);
        }
        try {
            SearchToGroupAction searchAction = new SearchToGroupAction(this);
            if (context.isActionInProgress(null)) {
                context.getActionEngine().runFullInternalAction((AbstractApplicationAction)searchAction);
            } else {
                context.getActionEngine().runAction((AbstractApplicationAction)searchAction);
            }
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"error while searching", (Throwable)e);
            }
            context.getErrorHelper().showErrorDialog(I18n.t((String)"faxtomail.search.action.error", (Object[])new Object[0]));
        }
    }

    @Override
    public List<MailField> getColumns() {
        if (this.tableColumns == null) {
            this.tableColumns = this.getContext().newServiceContext().getConfigurationService().getSearchDisplayColumns();
        }
        return this.tableColumns;
    }

    protected boolean isDemandSelectable(DemandeUIModel demand) {
        DemandeUIModel currentDemand = this.getContext().getCurrentEmail();
        return !currentDemand.equals(demand) && !currentDemand.getGroupedDemandes().contains(demand);
    }

    @Override
    protected MouseListener getDataTableMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    SearchToGroupUIHandler.this.group();
                }
            }
        };
    }

    @Override
    protected MailField[] getEditableTableProperties() {
        return new MailField[0];
    }

    public void onCloseUI() {
    }

    public SwingValidator<SearchUIModel> getValidator() {
        return null;
    }

    public void cancel() {
        this.getContext().getSwingSession().updateState();
        this.closeFrame();
    }

    @Override
    public Component getTopestUI() {
        return (Component)this.getUI();
    }

    public void group(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.group();
        }
    }

    public void group() {
        if (((SearchUIModel)((Object)this.getModel())).isGroupEnabled()) {
            this.getContext().getActionEngine().runAction((AbstractApplicationAction)new GroupAction(this));
        }
    }

    @Override
    public void reloadList() {
        this.searchDemandes();
    }
}

