/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net.jms;

import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LogEventListener;

public abstract class AbstractJmsReceiver
extends LogEventListener
implements MessageListener {
    protected Logger logger = LogManager.getLogger((String)this.getClass().getName());

    public void onMessage(Message message) {
        try {
            if (message instanceof ObjectMessage) {
                ObjectMessage objectMessage = (ObjectMessage)message;
                Serializable object = objectMessage.getObject();
                if (object instanceof LogEvent) {
                    this.log((LogEvent)object);
                } else {
                    this.logger.warn("Received message is of type " + object.getClass().getName() + ", was expecting LogEvent.");
                }
            } else {
                this.logger.warn("Received message is of type " + message.getJMSType() + ", was expecting ObjectMessage.");
            }
        }
        catch (JMSException jmse) {
            this.logger.error("Exception thrown while processing incoming message.", (Throwable)jmse);
        }
    }

    protected Object lookup(Context ctx, String name) throws NamingException {
        try {
            return ctx.lookup(name);
        }
        catch (NameNotFoundException e) {
            this.logger.error("Could not find name [" + name + "].");
            throw e;
        }
    }
}

