/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.lookup;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.lookup.StrLookup;

@Plugin(name="bundle", category="Lookup")
public class ResourceBundleLookup
implements StrLookup {
    @Override
    public String lookup(String key) {
        if (key == null) {
            return null;
        }
        String[] keys = key.split(":");
        int keyLen = keys.length;
        if (keyLen != 2) {
            return null;
        }
        String bundleName = keys[0];
        String bundleKey = keys[1];
        try {
            return ResourceBundle.getBundle(bundleName).getString(bundleKey);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    @Override
    public String lookup(LogEvent event, String key) {
        return this.lookup(key);
    }
}

