/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.services.service;

import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUserGroup;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUserGroupTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUserImpl;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUserTopiaDao;
import com.franciaflex.faxtomail.services.FaxToMailServiceSupport;
import com.franciaflex.faxtomail.services.service.ldap.AuthenticationException;
import com.franciaflex.faxtomail.services.service.ldap.LdapUser;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class LdapService
extends FaxToMailServiceSupport {
    private static final Log log = LogFactory.getLog(LdapService.class);

    protected LDAPConnection getLDAPConnection() throws LDAPException {
        return new LDAPConnection(this.getApplicationConfig().getLdapHost(), this.getApplicationConfig().getLdapPort(), this.getApplicationConfig().getLdapUser(), this.getApplicationConfig().getLdapPassword());
    }

    public Collection<LdapUser> getAllLdapUsers() {
        ArrayList<LdapUser> results = new ArrayList<LdapUser>();
        String[] baseDNs = new String[]{"OU=Utilisateurs,OU=Faber,OU=Utilisateurs,OU=Mac-Groupe,DC=mac-groupe,DC=net", "OU=OU Informatique,OU=France-Fermetures,OU=Utilisateurs,OU=Mac-Groupe,DC=mac-groupe,DC=net", "OU=Utilisateurs,OU=Carros,OU=Franciaflex,OU=Utilisateurs,OU=Mac-Groupe,DC=mac-groupe,DC=net", "OU=Utilisateurs,OU=Checy,OU=Franciaflex,OU=Utilisateurs,OU=Mac-Groupe,DC=mac-groupe,DC=net", "OU=Utilisateurs,OU=Guipry,OU=Franciaflex,OU=Utilisateurs,OU=Mac-Groupe,DC=mac-groupe,DC=net", "OU=Utilisateurs,OU=LeRheu,OU=Franciaflex,OU=Utilisateurs,OU=Mac-Groupe,DC=mac-groupe,DC=net", "OU=Utilisateurs,OU=Luzech,OU=Franciaflex,OU=Utilisateurs,OU=Mac-Groupe,DC=mac-groupe,DC=net", "OU=Utilisateurs,OU=MaisonAlfort,OU=Franciaflex,OU=Utilisateurs,OU=Mac-Groupe,DC=mac-groupe,DC=net", "OU=Utilisateurs,OU=Mauguio,OU=Franciaflex,OU=Utilisateurs,OU=Mac-Groupe,DC=mac-groupe,DC=net", "OU=Utilisateurs,OU=Migennes,OU=Franciaflex,OU=Utilisateurs,OU=Mac-Groupe,DC=mac-groupe,DC=net", "OU=Utilisateurs,OU=Nomades,OU=Franciaflex,OU=Utilisateurs,OU=Mac-Groupe,DC=mac-groupe,DC=net", "OU=Utilisateurs,OU=RocheToirin,OU=Franciaflex,OU=Utilisateurs,OU=Mac-Groupe,DC=mac-groupe,DC=net"};
        String filter = "(objectClass=user)";
        try (LDAPConnection connection = null;){
            connection = this.getLDAPConnection();
            if (connection.isConnected()) {
                for (String baseDN : baseDNs) {
                    SearchResult searchResult = connection.search(baseDN, SearchScope.ONE, filter, new String[0]);
                    List searchEntries = searchResult.getSearchEntries();
                    for (SearchResultEntry searchEntry : searchEntries) {
                        LdapUser user = new LdapUser();
                        user.setLogin(searchEntry.getAttributeValue("userPrincipalName"));
                        String fullName = searchEntry.getAttributeValue("name");
                        if (fullName.indexOf(32) != -1) {
                            String lastName = fullName.substring(0, fullName.indexOf(32));
                            String firstName = fullName.substring(fullName.indexOf(32) + 1);
                            user.setFirstName(firstName);
                            user.setLastName(lastName);
                        } else {
                            user.setFirstName("");
                            user.setLastName(fullName);
                        }
                        Object[] groups = searchEntry.getAttributeValues("memberOf");
                        if (ArrayUtils.isNotEmpty((Object[])groups)) {
                            for (Object group : groups) {
                                user.addGroup((String)group);
                            }
                        }
                        results.add(user);
                    }
                }
            }
        }
        return results;
    }

    public void updateLdapData() {
        if (StringUtils.isBlank((CharSequence)this.getApplicationConfig().getLdapHost())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Ldap service not configured !");
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Updating user data from ldap");
        }
        Collection<LdapUser> ldapUsers = this.getAllLdapUsers();
        FaxToMailUserTopiaDao faxtomailUserDao = this.getPersistenceContext().getFaxToMailUserDao();
        FaxToMailUserGroupTopiaDao faxToMailUserGroupDao = this.getPersistenceContext().getFaxToMailUserGroupDao();
        Binder userBinder = BinderFactory.newBinder(FaxToMailUser.class);
        for (LdapUser ldapUser : ldapUsers) {
            FaxToMailUser user = (FaxToMailUser)faxtomailUserDao.forLoginEquals(ldapUser.getLogin()).findUniqueOrNull();
            if (user == null) {
                user = new FaxToMailUserImpl();
            }
            userBinder.copyExcluding((Object)ldapUser, (Object)user, new String[]{"topiaId", "topiaCreateDate", "topiaVersion", "userGroups"});
            Collection<String> groups = ldapUser.getGroups();
            user.clearUserGroups();
            for (String group : groups) {
                String groupPath = this.getGroupFullPath(group);
                String groupName = StringUtils.substringAfterLast((String)groupPath, (String)"/");
                FaxToMailUserGroup userGroup = (FaxToMailUserGroup)faxToMailUserGroupDao.forNameEquals(groupName).findUniqueOrNull();
                if (userGroup == null) {
                    userGroup = (FaxToMailUserGroup)faxToMailUserGroupDao.create("name", (Object)groupName, new Object[]{"fullPath", groupPath});
                }
                user.addUserGroups(userGroup);
            }
            if (user.isPersisted()) {
                faxtomailUserDao.update((TopiaEntity)user);
                continue;
            }
            faxtomailUserDao.create((TopiaEntity)user);
        }
        this.getPersistenceContext().commit();
    }

    protected String getGroupFullPath(String groupCN) {
        Object[] part = groupCN.split(",");
        ArrayUtils.reverse((Object[])part);
        String result = StringUtils.join((Object[])part, (char)'/');
        return result;
    }

    public FaxToMailUser getUserBean(String userTopiaId) {
        FaxToMailUserImpl result = null;
        FaxToMailUserTopiaDao faxtomailUserDao = this.getPersistenceContext().getFaxToMailUserDao();
        FaxToMailUser user = (FaxToMailUser)faxtomailUserDao.forTopiaIdEquals(userTopiaId).findUniqueOrNull();
        if (user != null) {
            Binder faxToMailUserBinder = BinderFactory.newBinder(FaxToMailUser.class);
            result = new FaxToMailUserImpl();
            faxToMailUserBinder.copyExcluding((Object)user, (Object)result, new String[0]);
        }
        return result;
    }

    public FaxToMailUser authenticateUser(String login, String password) throws AuthenticationException {
        FaxToMailUserTopiaDao faxtomailUserDao = this.getPersistenceContext().getFaxToMailUserDao();
        FaxToMailUser user = (FaxToMailUser)faxtomailUserDao.forAll().findAnyOrNull();
        FaxToMailUserImpl result = null;
        if (user != null) {
            Binder faxToMailUserBinder = BinderFactory.newBinder(FaxToMailUser.class);
            result = new FaxToMailUserImpl();
            faxToMailUserBinder.copyExcluding((Object)user, (Object)result, new String[0]);
        }
        return result;
    }
}

