/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import org.fife.rsta.ac.AbstractLanguageSupport;
import org.fife.rsta.ac.java.ClassCompletion;
import org.fife.rsta.ac.java.JarManager;
import org.fife.rsta.ac.java.JavaCellRenderer;
import org.fife.rsta.ac.java.JavaCompletionProvider;
import org.fife.rsta.ac.java.JavaParamListCellRenderer;
import org.fife.rsta.ac.java.JavaParser;
import org.fife.rsta.ac.java.rjc.ast.CompilationUnit;
import org.fife.rsta.ac.java.rjc.ast.ImportDeclaration;
import org.fife.rsta.ac.java.rjc.ast.Package;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.parser.Parser;
import org.fife.ui.rtextarea.ToolTipSupplier;

public class JavaLanguageSupport
extends AbstractLanguageSupport {
    private Map parserToInfoMap = new HashMap();
    private JarManager jarManager = new JarManager();
    private static final String PROPERTY_LISTENER = "org.fife.rsta.ac.java.JavaLanguageSupport.Listener";

    public JavaLanguageSupport() {
        this.setAutoActivationEnabled(true);
        this.setParameterAssistanceEnabled(true);
        this.setShowDescWindow(true);
    }

    public JavaCompletionProvider getCompletionProvider(RSyntaxTextArea textArea) {
        AutoCompletion ac = this.getAutoCompletionFor(textArea);
        return (JavaCompletionProvider)ac.getCompletionProvider();
    }

    public JarManager getJarManager() {
        return this.jarManager;
    }

    public JavaParser getParser(RSyntaxTextArea textArea) {
        Object parser = textArea.getClientProperty((Object)"org.fife.rsta.ac.LanguageSupport.LanguageParser");
        if (parser instanceof JavaParser) {
            return (JavaParser)((Object)parser);
        }
        return null;
    }

    public void install(RSyntaxTextArea textArea) {
        JavaCompletionProvider p = new JavaCompletionProvider(this.jarManager);
        JavaAutoCompletion ac = new JavaAutoCompletion(p, textArea);
        ac.setListCellRenderer(new JavaCellRenderer());
        ac.setAutoCompleteEnabled(this.isAutoCompleteEnabled());
        ac.setAutoActivationEnabled(this.isAutoActivationEnabled());
        ac.setAutoActivationDelay(this.getAutoActivationDelay());
        ac.setParameterAssistanceEnabled(this.isParameterAssistanceEnabled());
        ac.setParamChoicesRenderer(new JavaParamListCellRenderer());
        ac.setShowDescWindow(this.getShowDescWindow());
        ac.install((JTextComponent)textArea);
        this.installImpl(textArea, ac);
        textArea.setToolTipSupplier((ToolTipSupplier)p);
        Listener listener = new Listener(textArea);
        textArea.putClientProperty((Object)PROPERTY_LISTENER, (Object)listener);
        JavaParser parser = new JavaParser(textArea);
        textArea.putClientProperty((Object)"org.fife.rsta.ac.LanguageSupport.LanguageParser", (Object)parser);
        textArea.addParser((Parser)parser);
        Info info = new Info(textArea, p, parser);
        this.parserToInfoMap.put(parser, info);
    }

    public void uninstall(RSyntaxTextArea textArea) {
        this.uninstallImpl(textArea);
        JavaParser parser = this.getParser(textArea);
        Info info = (Info)this.parserToInfoMap.remove((Object)parser);
        if (info != null) {
            parser.removePropertyChangeListener("CompilationUnit", info);
        }
        textArea.removeParser((Parser)parser);
        textArea.putClientProperty((Object)"org.fife.rsta.ac.LanguageSupport.LanguageParser", null);
        Object listener = textArea.getClientProperty((Object)PROPERTY_LISTENER);
        if (listener instanceof Listener) {
            ((Listener)listener).uninstall();
            textArea.putClientProperty((Object)PROPERTY_LISTENER, null);
        }
    }

    private class Listener
    implements CaretListener,
    ActionListener {
        private RSyntaxTextArea textArea;
        private Timer t;

        public Listener(RSyntaxTextArea textArea) {
            this.textArea = textArea;
            textArea.addCaretListener((CaretListener)this);
            this.t = new Timer(650, this);
            this.t.setRepeats(false);
        }

        public void actionPerformed(ActionEvent e) {
            JavaParser parser = JavaLanguageSupport.this.getParser(this.textArea);
            if (parser == null) {
                return;
            }
            CompilationUnit cu = parser.getCompilationUnit();
            if (cu != null) {
                int dot = this.textArea.getCaretPosition();
                Point p = cu.getEnclosingMethodRange(dot);
                if (p != null) {
                    try {
                        int startLine = this.textArea.getLineOfOffset(p.x);
                        int endLine = this.textArea.getLineOfOffset(p.y);
                        this.textArea.setActiveLineRange(startLine, endLine);
                    }
                    catch (BadLocationException ble) {
                        ble.printStackTrace();
                    }
                } else {
                    this.textArea.setActiveLineRange(-1, -1);
                }
            }
        }

        public void caretUpdate(CaretEvent e) {
            this.t.restart();
        }

        public void uninstall() {
            this.textArea.removeCaretListener((CaretListener)this);
        }
    }

    private class JavaAutoCompletion
    extends AutoCompletion {
        private RSyntaxTextArea textArea;
        private String replacementTextPrefix;

        public JavaAutoCompletion(JavaCompletionProvider provider, RSyntaxTextArea textArea) {
            super((CompletionProvider)provider);
            this.textArea = textArea;
        }

        private String getCurrentLineText() {
            int caretPosition = this.textArea.getCaretPosition();
            Element root = this.textArea.getDocument().getDefaultRootElement();
            int line = root.getElementIndex(caretPosition);
            Element elem = root.getElement(line);
            int endOffset = elem.getEndOffset();
            int lineStart = elem.getStartOffset();
            String text = "";
            try {
                text = this.textArea.getText(lineStart, endOffset - lineStart).trim();
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            return text;
        }

        protected String getReplacementText(Completion c, Document doc, int start, int len) {
            String text = super.getReplacementText(c, doc, start, len);
            if (this.replacementTextPrefix != null) {
                text = this.replacementTextPrefix + text;
                this.replacementTextPrefix = null;
            }
            return text;
        }

        private ImportToAddInfo getShouldAddImport(ClassCompletion cc) {
            String text = this.getCurrentLineText();
            if (!text.startsWith("import ")) {
                String pkgName;
                String ccPkg;
                JavaCompletionProvider provider = (JavaCompletionProvider)this.getCompletionProvider();
                CompilationUnit cu = provider.getCompilationUnit();
                int offset = 0;
                boolean alreadyImported = false;
                if (cu == null) {
                    return null;
                }
                if ("java.lang".equals(cc.getPackageName())) {
                    return null;
                }
                String className = cc.getClassName(false);
                String fqClassName = cc.getClassName(true);
                int lastClassNameDot = fqClassName.lastIndexOf(46);
                boolean ccInPackage = lastClassNameDot > -1;
                Package pkg = cu.getPackage();
                if (ccInPackage && pkg != null ? (ccPkg = fqClassName.substring(0, lastClassNameDot)).equals(pkgName = pkg.getName()) : !ccInPackage && pkg == null) {
                    return null;
                }
                Iterator i = cu.getImportIterator();
                while (i.hasNext()) {
                    int dot;
                    ImportDeclaration id = (ImportDeclaration)i.next();
                    offset = id.getNameEndOffset() + 1;
                    if (id.isStatic()) continue;
                    if (id.isWildcard()) {
                        String classPkg;
                        String imported;
                        String importedPkg;
                        if (lastClassNameDot <= -1 || !(importedPkg = (imported = id.getName()).substring(0, dot = imported.lastIndexOf(46))).equals(classPkg = fqClassName.substring(0, lastClassNameDot))) continue;
                        alreadyImported = true;
                        break;
                    }
                    String fullyImportedClassName = id.getName();
                    String importedClassName = fullyImportedClassName.substring((dot = fullyImportedClassName.lastIndexOf(46)) + 1);
                    if (!className.equals(importedClassName)) continue;
                    offset = -1;
                    if (!fqClassName.equals(fullyImportedClassName)) break;
                    alreadyImported = true;
                    break;
                }
                if (!alreadyImported) {
                    StringBuffer importToAdd = new StringBuffer();
                    if (offset == 0 && pkg != null) {
                        offset = pkg.getNameEndOffset() + 1;
                        importToAdd.append('\n');
                    }
                    if (offset > -1) {
                        if (offset > 0) {
                            importToAdd.append("\nimport ").append(fqClassName).append(';');
                        } else {
                            importToAdd.append("import ").append(fqClassName).append(";\n");
                        }
                        return new ImportToAddInfo(offset, importToAdd.toString());
                    }
                    int dot = fqClassName.lastIndexOf(46);
                    if (dot > -1) {
                        String pkgName2;
                        this.replacementTextPrefix = pkgName2 = fqClassName.substring(0, dot + 1);
                    }
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void insertCompletion(Completion c) {
            ImportToAddInfo importInfo = null;
            if (c instanceof ClassCompletion && (importInfo = this.getShouldAddImport((ClassCompletion)c)) != null) {
                this.textArea.beginAtomicEdit();
            }
            try {
                super.insertCompletion(c);
                if (importInfo != null) {
                    this.textArea.insert(importInfo.text, importInfo.offs);
                }
            }
            finally {
                this.textArea.endAtomicEdit();
            }
        }

        protected int refreshPopupWindow() {
            JavaParser parser = JavaLanguageSupport.this.getParser(this.textArea);
            RSyntaxDocument doc = (RSyntaxDocument)this.textArea.getDocument();
            String style = this.textArea.getSyntaxEditingStyle();
            parser.parse(doc, style);
            return super.refreshPopupWindow();
        }
    }

    private static class Info
    implements PropertyChangeListener {
        public RSyntaxTextArea textArea;
        public JavaCompletionProvider provider;
        public JavaParser parser;

        public Info(RSyntaxTextArea textArea, JavaCompletionProvider provider, JavaParser parser) {
            this.textArea = textArea;
            this.provider = provider;
            this.parser = parser;
            parser.addPropertyChangeListener("CompilationUnit", this);
        }

        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if ("CompilationUnit".equals(name)) {
                CompilationUnit cu = (CompilationUnit)e.getNewValue();
                this.provider.setCompilationUnit(cu);
            }
        }
    }

    private static class ImportToAddInfo {
        public int offs;
        public String text;

        public ImportToAddInfo(int offset, String text) {
            this.offs = offset;
            this.text = text;
        }
    }
}

