/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java;

import java.io.File;

public class JarInfo
implements Comparable,
Cloneable {
    private File jarFile;
    private File sourceLocation;

    public JarInfo(File jarFile) {
        this.setJarFile(jarFile);
    }

    public Object clone() {
        JarInfo clone = null;
        try {
            clone = (JarInfo)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            cnse.printStackTrace();
        }
        return clone;
    }

    public int compareTo(Object o) {
        if (o == this) {
            return 0;
        }
        int result = -1;
        if (o instanceof JarInfo) {
            result = ((JarInfo)o).jarFile.compareTo(this.jarFile);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof JarInfo && ((JarInfo)obj).jarFile.equals(this.jarFile);
    }

    public File getJarFile() {
        return this.jarFile;
    }

    public static JarInfo getJREJarInfo(File jreHome) {
        JarInfo info = null;
        File mainJar = new File(jreHome, "lib/rt.jar");
        File sourceZip = null;
        if (mainJar.isFile()) {
            sourceZip = new File(jreHome, "src.zip");
            if (!sourceZip.isFile()) {
                sourceZip = new File(jreHome, "../src.zip");
            }
        } else {
            mainJar = new File(jreHome, "../Classes/classes.jar");
            sourceZip = new File(jreHome, "src.jar");
        }
        if (mainJar.isFile()) {
            info = new JarInfo(mainJar);
            if (sourceZip.isFile()) {
                info.setSourceLocation(sourceZip);
            }
        } else {
            System.err.println("[ERROR]: Cannot locate JRE jar in " + jreHome.getAbsolutePath());
            mainJar = null;
        }
        return info;
    }

    public static JarInfo getMainJREJarInfo() {
        String javaHome = System.getProperty("java.home");
        return JarInfo.getJREJarInfo(new File(javaHome));
    }

    public File getSourceLocation() {
        return this.sourceLocation;
    }

    public int hashCode() {
        return this.jarFile.hashCode();
    }

    public void setJarFile(File jarFile) {
        if (jarFile == null || !jarFile.exists()) {
            String name = jarFile == null ? "null" : jarFile.getAbsolutePath();
            throw new IllegalArgumentException("Jar does not exist: " + name);
        }
        this.jarFile = jarFile;
    }

    public void setSourceLocation(File loc) {
        this.sourceLocation = loc;
    }

    public String toString() {
        String sourceLoc = null;
        if (this.sourceLocation != null) {
            sourceLoc = this.sourceLocation.getAbsolutePath();
        }
        return "[JarInfo: jar=" + this.getJarFile().getAbsolutePath() + "; source=" + sourceLoc + "]";
    }
}

