/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.demo;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.fife.rsta.ac.LanguageSupport;
import org.fife.rsta.ac.LanguageSupportFactory;
import org.fife.rsta.ac.demo.Actions;
import org.fife.rsta.ac.java.JarInfo;
import org.fife.rsta.ac.java.JavaLanguageSupport;
import org.fife.rsta.ac.java.rjc.ast.ASTNode;
import org.fife.rsta.ac.java.tree.JavaOutlineTree;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.SyntaxConstants;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

class DemoRootPane
extends JRootPane
implements HyperlinkListener,
SyntaxConstants,
Actions {
    private JavaOutlineTree tree;
    private RTextScrollPane scrollPane;
    private RSyntaxTextArea textArea;
    private Listener listener = new Listener();

    public DemoRootPane() {
        LanguageSupportFactory lsf = LanguageSupportFactory.get();
        LanguageSupport support = lsf.getSupportFor("text/java");
        JavaLanguageSupport jls = (JavaLanguageSupport)support;
        try {
            jls.getJarManager().addJar(null);
            JarInfo ji = new JarInfo(new File("./bin"));
            ji.setSourceLocation(new File("./src"));
            jls.getJarManager().addJar(ji);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.textArea = this.createTextArea();
        this.setText("CExample.txt", "text/c");
        this.scrollPane = new RTextScrollPane((RTextArea)this.textArea, true);
        this.scrollPane.setIconRowHeaderEnabled(true);
        this.scrollPane.getGutter().setBookmarkingEnabled(true);
        this.tree = new JavaOutlineTree();
        this.tree.addTreeSelectionListener(this.listener);
        this.tree.listenTo(this.textArea);
        JScrollPane treeSP = new JScrollPane(this.tree);
        JSplitPane sp = new JSplitPane(1, treeSP, (Component)this.scrollPane);
        this.setContentPane(sp);
        this.setJMenuBar(this.createMenuBar());
    }

    private void addItem(Action a, ButtonGroup bg, JMenu menu) {
        JRadioButtonMenuItem item = new JRadioButtonMenuItem(a);
        bg.add(item);
        menu.add(item);
    }

    private JMenuBar createMenuBar() {
        JMenuBar mb = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.add(new JMenuItem(new Actions.OpenAction(this)));
        menu.addSeparator();
        menu.add(new JMenuItem(new Actions.ExitAction()));
        mb.add(menu);
        menu = new JMenu("Language");
        ButtonGroup bg = new ButtonGroup();
        this.addItem(new Actions.StyleAction(this, "C", "CExample.txt", "text/c"), bg, menu);
        this.addItem(new Actions.StyleAction(this, "Groovy", "GroovyExample.txt", "text/groovy"), bg, menu);
        this.addItem(new Actions.StyleAction(this, "Java", "JavaExample.txt", "text/java"), bg, menu);
        this.addItem(new Actions.StyleAction(this, "Perl", "PerlExample.txt", "text/perl"), bg, menu);
        this.addItem(new Actions.StyleAction(this, "HTML", "HtmlExample.txt", "text/html"), bg, menu);
        this.addItem(new Actions.StyleAction(this, "PHP", "PhpExample.txt", "text/php"), bg, menu);
        this.addItem(new Actions.StyleAction(this, "sh", "ShellExample.txt", "text/unix"), bg, menu);
        menu.getItem(0).setSelected(true);
        mb.add(menu);
        menu = new JMenu("LookAndFeel");
        bg = new ButtonGroup();
        UIManager.LookAndFeelInfo[] infos = UIManager.getInstalledLookAndFeels();
        for (int i = 0; i < infos.length; ++i) {
            this.addItem(new Actions.LookAndFeelAction(this, infos[i]), bg, menu);
        }
        mb.add(menu);
        menu = new JMenu("Help");
        menu.add(new JMenuItem(new Actions.AboutAction(this)));
        mb.add(menu);
        return mb;
    }

    private RSyntaxTextArea createTextArea() {
        RSyntaxTextArea textArea = new RSyntaxTextArea(25, 70);
        LanguageSupportFactory.get().register(textArea);
        textArea.setCaretPosition(0);
        textArea.addHyperlinkListener((HyperlinkListener)this);
        textArea.requestFocusInWindow();
        textArea.setMarkOccurrences(true);
        textArea.setTextAntiAliasHint("VALUE_TEXT_ANTIALIAS_ON");
        ToolTipManager.sharedInstance().registerComponent((JComponent)textArea);
        return textArea;
    }

    void focusTextArea() {
        this.textArea.requestFocusInWindow();
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            URL url = e.getURL();
            if (url == null) {
                UIManager.getLookAndFeel().provideErrorFeedback(null);
            } else {
                JOptionPane.showMessageDialog(this, "URL clicked:\n" + url.toString());
            }
        }
    }

    public void openFile(File file) {
        try {
            BufferedReader r = new BufferedReader(new FileReader(file));
            this.textArea.read((Reader)r, null);
            this.textArea.setCaretPosition(0);
            r.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            UIManager.getLookAndFeel().provideErrorFeedback(this);
            return;
        }
    }

    void setText(String resource, String style) {
        this.textArea.setSyntaxEditingStyle(style);
        ClassLoader cl = this.getClass().getClassLoader();
        BufferedReader r = null;
        try {
            r = new BufferedReader(new InputStreamReader(cl.getResourceAsStream("examples/" + resource), "UTF-8"));
            this.textArea.read((Reader)r, null);
            r.close();
            this.textArea.setCaretPosition(0);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            this.textArea.setText("Type here to see syntax highlighting");
        }
    }

    private class Listener
    implements TreeSelectionListener {
        private Listener() {
        }

        public void valueChanged(TreeSelectionEvent e) {
            DefaultMutableTreeNode node;
            Object obj;
            TreePath path = e.getNewLeadSelectionPath();
            if (path != null && (obj = (node = (DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject()) instanceof ASTNode) {
                ASTNode astNode = (ASTNode)obj;
                int start = astNode.getNameStartOffset();
                int end = astNode.getNameEndOffset();
                DemoRootPane.this.textArea.select(start, end);
            }
        }
    }
}

