/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.common;

import java.util.ArrayList;
import java.util.List;
import org.fife.rsta.ac.common.VariableDeclaration;

public class CodeBlock {
    private int start;
    private int end;
    private CodeBlock parent;
    private List children;
    private List varDecs;

    public CodeBlock(int start) {
        this.start = start;
        this.end = Integer.MAX_VALUE;
    }

    public CodeBlock addChildCodeBlock(int start) {
        CodeBlock child = new CodeBlock(start);
        child.parent = this;
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(child);
        return child;
    }

    public void addVariable(VariableDeclaration varDec) {
        if (this.varDecs == null) {
            this.varDecs = new ArrayList();
        }
        this.varDecs.add(varDec);
    }

    public boolean contains(int offset) {
        return offset >= this.start && offset < this.end;
    }

    public CodeBlock getChildCodeBlock(int index) {
        return (CodeBlock)this.children.get(index);
    }

    public int getChildCodeBlockCount() {
        return this.children == null ? 0 : this.children.size();
    }

    public int getEndOffset() {
        return this.end;
    }

    public CodeBlock getParent() {
        return this.parent;
    }

    public int getStartOffset() {
        return this.start;
    }

    public VariableDeclaration getVariableDeclaration(int index) {
        return (VariableDeclaration)this.varDecs.get(index);
    }

    public int getVariableDeclarationCount() {
        return this.varDecs == null ? 0 : this.varDecs.size();
    }

    public void setEndOffset(int end) {
        this.end = end;
    }
}

