/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.api;

import com.docusign.esign.client.ApiClient;
import com.docusign.esign.client.ApiException;
import com.docusign.esign.client.ApiResponse;
import com.docusign.esign.client.Configuration;
import com.docusign.esign.client.Pair;
import com.docusign.esign.model.BulkProcessRequest;
import com.docusign.esign.model.BulkProcessResponse;
import com.docusign.esign.model.BulkProcessResult;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class BulkProcessDataSendApi {
    private ApiClient apiClient;

    public BulkProcessDataSendApi() {
        this(Configuration.getDefaultApiClient());
    }

    public BulkProcessDataSendApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public BulkProcessResponse createBulkProcessRequestToQueue(String accountId, String processAction, String bulkProcessListId, BulkProcessRequest bulkProcessRequest) throws ApiException {
        ApiResponse<BulkProcessResponse> localVarResponse = this.createBulkProcessRequestToQueueWithHttpInfo(accountId, processAction, bulkProcessListId, bulkProcessRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<BulkProcessResponse> createBulkProcessRequestToQueueWithHttpInfo(String accountId, String processAction, String bulkProcessListId, BulkProcessRequest bulkProcessRequest) throws ApiException {
        BulkProcessRequest localVarPostBody = bulkProcessRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createBulkProcessRequestToQueue");
        }
        if (processAction == null) {
            throw new ApiException(400, "Missing the required parameter 'processAction' when calling createBulkProcessRequestToQueue");
        }
        if (bulkProcessListId == null) {
            throw new ApiException(400, "Missing the required parameter 'bulkProcessListId' when calling createBulkProcessRequestToQueue");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/bulk_process_data/actions/{processAction}/{bulkProcessListId}/send".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{processAction\\}", this.apiClient.escapeString(processAction.toString())).replaceAll("\\{bulkProcessListId\\}", this.apiClient.escapeString(bulkProcessListId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<BulkProcessResponse> localVarReturnType = new GenericType<BulkProcessResponse>(){};
        BulkProcessResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<BulkProcessResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public BulkProcessResult deleteBulkProcessList(String accountId, String processAction, String bulkProcessListId) throws ApiException {
        ApiResponse<BulkProcessResult> localVarResponse = this.deleteBulkProcessListWithHttpInfo(accountId, processAction, bulkProcessListId);
        return localVarResponse.getData();
    }

    public ApiResponse<BulkProcessResult> deleteBulkProcessListWithHttpInfo(String accountId, String processAction, String bulkProcessListId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteBulkProcessList");
        }
        if (processAction == null) {
            throw new ApiException(400, "Missing the required parameter 'processAction' when calling deleteBulkProcessList");
        }
        if (bulkProcessListId == null) {
            throw new ApiException(400, "Missing the required parameter 'bulkProcessListId' when calling deleteBulkProcessList");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/bulk_process_data/actions/{processAction}/{bulkProcessListId}/send".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{processAction\\}", this.apiClient.escapeString(processAction.toString())).replaceAll("\\{bulkProcessListId\\}", this.apiClient.escapeString(bulkProcessListId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<BulkProcessResult> localVarReturnType = new GenericType<BulkProcessResult>(){};
        BulkProcessResult localVarResponse = this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<BulkProcessResult>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public void getBulkProcessList(String accountId, String processAction, String bulkProcessListId) throws ApiException {
        this.getBulkProcessListWithHttpInfo(accountId, processAction, bulkProcessListId);
    }

    public ApiResponse<Object> getBulkProcessListWithHttpInfo(String accountId, String processAction, String bulkProcessListId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getBulkProcessList");
        }
        if (processAction == null) {
            throw new ApiException(400, "Missing the required parameter 'processAction' when calling getBulkProcessList");
        }
        if (bulkProcessListId == null) {
            throw new ApiException(400, "Missing the required parameter 'bulkProcessListId' when calling getBulkProcessList");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/bulk_process_data/actions/{processAction}/{bulkProcessListId}/send".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{processAction\\}", this.apiClient.escapeString(processAction.toString())).replaceAll("\\{bulkProcessListId\\}", this.apiClient.escapeString(bulkProcessListId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
        return new ApiResponse<Object>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), null);
    }

    public void updateBulkProcessList(String accountId, String processAction, String bulkProcessListId) throws ApiException {
        this.updateBulkProcessListWithHttpInfo(accountId, processAction, bulkProcessListId);
    }

    public ApiResponse<Object> updateBulkProcessListWithHttpInfo(String accountId, String processAction, String bulkProcessListId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateBulkProcessList");
        }
        if (processAction == null) {
            throw new ApiException(400, "Missing the required parameter 'processAction' when calling updateBulkProcessList");
        }
        if (bulkProcessListId == null) {
            throw new ApiException(400, "Missing the required parameter 'bulkProcessListId' when calling updateBulkProcessList");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/bulk_process_data/actions/{processAction}/{bulkProcessListId}/send".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{processAction\\}", this.apiClient.escapeString(processAction.toString())).replaceAll("\\{bulkProcessListId\\}", this.apiClient.escapeString(bulkProcessListId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
        return new ApiResponse<Object>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), null);
    }
}

