/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.util;

import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeMap;

public class ResultMerger {
    public static <T> Iterator<T> mergeResults(final Iterator<T>[] results, final Comparator<T> comparator) {
        return new Iterator<T>(){
            TreeMap<T, Iterator<T>> map;
            {
                this.map = new TreeMap(comparator);
                for (Iterator result : results) {
                    if (!result.hasNext()) continue;
                    this.map.put(result.next(), result);
                }
            }

            @Override
            public boolean hasNext() {
                return this.map.size() > 0;
            }

            @Override
            public T next() {
                Object first = this.map.firstKey();
                Iterator iter = this.map.remove(first);
                while (iter.hasNext()) {
                    Object next = iter.next();
                    if (this.map.containsKey(next)) continue;
                    this.map.put(next, iter);
                    break;
                }
                return first;
            }

            @Override
            public void remove() {
                Object first = this.map.firstKey();
                Iterator iter = this.map.remove(first);
                while (iter.hasNext()) {
                    Object next = iter.next();
                    if (this.map.containsKey(next)) continue;
                    this.map.put(next, iter);
                    break;
                }
            }
        };
    }
}

