/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.data;

import com.browseengine.bobo.api.BoboIndexReader;
import com.browseengine.bobo.facets.data.FacetDataCache;
import com.browseengine.bobo.facets.data.TermListFactory;
import com.browseengine.bobo.facets.data.TermStringList;
import com.browseengine.bobo.facets.data.TermValueList;
import com.browseengine.bobo.facets.impl.MultiValueFacetHandler;
import com.browseengine.bobo.sort.DocComparator;
import com.browseengine.bobo.sort.DocComparatorSource;
import com.browseengine.bobo.util.BigIntBuffer;
import com.browseengine.bobo.util.BigNestedIntArray;
import com.browseengine.bobo.util.StringArrayComparator;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.util.OpenBitSet;

public class MultiValueFacetDataCache<T>
extends FacetDataCache<T> {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(MultiValueFacetDataCache.class);
    public final BigNestedIntArray _nestedArray = new BigNestedIntArray();
    private int _maxItems = 1024;
    private boolean _overflow = false;

    public MultiValueFacetDataCache<T> setMaxItems(int maxItems) {
        this._maxItems = Math.min(maxItems, 1024);
        this._nestedArray.setMaxItems(this._maxItems);
        return this;
    }

    @Override
    public int getNumItems(int docid) {
        return this._nestedArray.getNumItems(docid);
    }

    @Override
    public void load(String fieldName, IndexReader reader, TermListFactory<T> listFactory) throws IOException {
        this.load(fieldName, reader, listFactory, new BoboIndexReader.WorkArea());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String fieldName, IndexReader reader, TermListFactory<T> listFactory, BoboIndexReader.WorkArea workArea) throws IOException {
        int doc;
        OpenBitSet bitset;
        IntArrayList freqList;
        IntArrayList maxIDList;
        IntArrayList minIDList;
        TermValueList list;
        BigNestedIntArray.BufferedLoader loader;
        int maxdoc;
        block25: {
            long t0 = System.currentTimeMillis();
            maxdoc = reader.maxDoc();
            loader = this.getBufferedLoader(maxdoc, workArea);
            TermEnum tenum = null;
            TermDocs tdoc = null;
            list = listFactory == null ? new TermStringList() : listFactory.createTermList();
            minIDList = new IntArrayList();
            maxIDList = new IntArrayList();
            freqList = new IntArrayList();
            bitset = new OpenBitSet((long)(maxdoc + 1));
            int t = 0;
            list.add(null);
            minIDList.add(-1);
            maxIDList.add(-1);
            freqList.add(0);
            ++t;
            this._overflow = false;
            try {
                Term term;
                tdoc = reader.termDocs();
                tenum = reader.terms(new Term(fieldName, ""));
                if (tenum == null) break block25;
                while ((term = tenum.term()) != null) {
                    if (!fieldName.equals(term.field())) {
                    } else {
                        String val = term.text();
                        if (val != null) {
                            list.add(val);
                            tdoc.seek(tenum);
                            int df = 0;
                            int minID = -1;
                            int maxID = -1;
                            if (tdoc.next()) {
                                ++df;
                                int docid = tdoc.doc();
                                if (!loader.add(docid, t)) {
                                    this.logOverflow(fieldName);
                                }
                                minID = docid;
                                bitset.fastSet(docid);
                                while (tdoc.next()) {
                                    ++df;
                                    docid = tdoc.doc();
                                    if (!loader.add(docid, t)) {
                                        this.logOverflow(fieldName);
                                    }
                                    bitset.fastSet(docid);
                                }
                                maxID = docid;
                            }
                            freqList.add(df);
                            minIDList.add(minID);
                            maxIDList.add(maxID);
                        }
                        ++t;
                        if (tenum.next()) continue;
                    }
                    break;
                }
            }
            finally {
                try {
                    if (tdoc != null) {
                        tdoc.close();
                    }
                }
                finally {
                    if (tenum != null) {
                        tenum.close();
                    }
                }
            }
        }
        list.seal();
        try {
            this._nestedArray.load(maxdoc + 1, loader);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("failed to load due to " + e.toString(), e);
        }
        this.valArray = list;
        this.freqs = freqList.toIntArray();
        this.minIDs = minIDList.toIntArray();
        this.maxIDs = maxIDList.toIntArray();
        for (doc = 0; doc <= maxdoc && !this._nestedArray.contains(doc, 0, true); ++doc) {
        }
        if (doc <= maxdoc) {
            this.minIDs[0] = doc;
            for (doc = maxdoc; doc > 0 && !this._nestedArray.contains(doc, 0, true); --doc) {
            }
            if (doc > 0) {
                this.maxIDs[0] = doc;
            }
        }
        this.freqs[0] = maxdoc + 1 - (int)bitset.cardinality();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String fieldName, IndexReader reader, TermListFactory<T> listFactory, Term sizeTerm) throws IOException {
        int doc;
        OpenBitSet bitset;
        IntArrayList freqList;
        IntArrayList maxIDList;
        IntArrayList minIDList;
        TermValueList list;
        int maxdoc;
        block25: {
            maxdoc = reader.maxDoc();
            AllocOnlyLoader loader = new AllocOnlyLoader(this._maxItems, sizeTerm, reader);
            try {
                this._nestedArray.load(maxdoc + 1, loader);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException("failed to load due to " + e.toString(), e);
            }
            TermEnum tenum = null;
            TermDocs tdoc = null;
            list = listFactory == null ? new TermStringList() : listFactory.createTermList();
            minIDList = new IntArrayList();
            maxIDList = new IntArrayList();
            freqList = new IntArrayList();
            bitset = new OpenBitSet((long)(maxdoc + 1));
            int t = 0;
            list.add(null);
            minIDList.add(-1);
            maxIDList.add(-1);
            freqList.add(0);
            ++t;
            this._overflow = false;
            try {
                Term term;
                tdoc = reader.termDocs();
                tenum = reader.terms(new Term(fieldName, ""));
                if (tenum == null) break block25;
                while ((term = tenum.term()) != null) {
                    if (!fieldName.equals(term.field())) {
                    } else {
                        String val = term.text();
                        if (val != null) {
                            list.add(val);
                            tdoc.seek(tenum);
                            int df = 0;
                            int minID = -1;
                            int maxID = -1;
                            if (tdoc.next()) {
                                ++df;
                                int docid = tdoc.doc();
                                if (!this._nestedArray.addData(docid, t)) {
                                    this.logOverflow(fieldName);
                                }
                                minID = docid;
                                bitset.fastSet(docid);
                                while (tdoc.next()) {
                                    ++df;
                                    docid = tdoc.doc();
                                    if (!this._nestedArray.addData(docid, t)) {
                                        this.logOverflow(fieldName);
                                    }
                                    bitset.fastSet(docid);
                                }
                                maxID = docid;
                            }
                            freqList.add(df);
                            minIDList.add(minID);
                            maxIDList.add(maxID);
                        }
                        ++t;
                        if (tenum.next()) continue;
                    }
                    break;
                }
            }
            finally {
                try {
                    if (tdoc != null) {
                        tdoc.close();
                    }
                }
                finally {
                    if (tenum != null) {
                        tenum.close();
                    }
                }
            }
        }
        list.seal();
        this.valArray = list;
        this.freqs = freqList.toIntArray();
        this.minIDs = minIDList.toIntArray();
        this.maxIDs = maxIDList.toIntArray();
        for (doc = 0; doc <= maxdoc && !this._nestedArray.contains(doc, 0, true); ++doc) {
        }
        if (doc <= maxdoc) {
            this.minIDs[0] = doc;
            for (doc = maxdoc; doc > 0 && !this._nestedArray.contains(doc, 0, true); --doc) {
            }
            if (doc > 0) {
                this.maxIDs[0] = doc;
            }
        }
        this.freqs[0] = maxdoc + 1 - (int)bitset.cardinality();
    }

    private void logOverflow(String fieldName) {
        if (!this._overflow) {
            logger.error((Object)("Maximum value per document: " + this._maxItems + " exceeded, fieldName=" + fieldName));
            this._overflow = true;
        }
    }

    private BigNestedIntArray.BufferedLoader getBufferedLoader(int maxdoc, BoboIndexReader.WorkArea workArea) {
        if (workArea == null) {
            return new BigNestedIntArray.BufferedLoader(maxdoc, this._maxItems, new BigIntBuffer());
        }
        BigIntBuffer buffer = workArea.get(BigIntBuffer.class);
        if (buffer == null) {
            buffer = new BigIntBuffer();
            workArea.put(buffer);
        } else {
            buffer.reset();
        }
        BigNestedIntArray.BufferedLoader loader = workArea.get(BigNestedIntArray.BufferedLoader.class);
        if (loader == null || loader.capacity() < maxdoc) {
            loader = new BigNestedIntArray.BufferedLoader(maxdoc, this._maxItems, buffer);
            workArea.put(loader);
        } else {
            loader.reset(maxdoc, this._maxItems, buffer);
        }
        return loader;
    }

    public static final class MultiFacetDocComparatorSource
    extends DocComparatorSource {
        private MultiValueFacetHandler _facetHandler;

        public MultiFacetDocComparatorSource(MultiValueFacetHandler facetHandler) {
            this._facetHandler = facetHandler;
        }

        @Override
        public DocComparator getComparator(IndexReader reader, int docbase) throws IOException {
            if (!(reader instanceof BoboIndexReader)) {
                throw new IllegalStateException("reader must be instance of " + BoboIndexReader.class);
            }
            BoboIndexReader boboReader = (BoboIndexReader)reader;
            final MultiValueFacetDataCache dataCache = (MultiValueFacetDataCache)this._facetHandler.getFacetData(boboReader);
            return new DocComparator(){

                @Override
                public int compare(ScoreDoc doc1, ScoreDoc doc2) {
                    return dataCache._nestedArray.compare(doc1.doc, doc2.doc);
                }

                @Override
                public Comparable value(ScoreDoc doc) {
                    String[] vals = dataCache._nestedArray.getTranslatedData(doc.doc, dataCache.valArray);
                    return new StringArrayComparator(vals);
                }
            };
        }
    }

    public static final class AllocOnlyLoader
    extends BigNestedIntArray.Loader {
        private IndexReader _reader;
        private Term _sizeTerm;
        private int _maxItems;

        public AllocOnlyLoader(int maxItems, Term sizeTerm, IndexReader reader) throws IOException {
            this._maxItems = Math.min(maxItems, 1024);
            this._sizeTerm = sizeTerm;
            this._reader = reader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void load() throws Exception {
            TermPositions tp = null;
            byte[] payloadBuffer = new byte[4];
            try {
                tp = this._reader.termPositions(this._sizeTerm);
                if (tp == null) {
                    return;
                }
                while (tp.next()) {
                    if (tp.freq() <= 0) continue;
                    tp.nextPosition();
                    tp.getPayload(payloadBuffer, 0);
                    int len = AllocOnlyLoader.bytesToInt(payloadBuffer);
                    this.allocate(tp.doc(), Math.min(len, this._maxItems), true);
                }
            }
            finally {
                if (tp != null) {
                    tp.close();
                }
            }
        }

        private static int bytesToInt(byte[] bytes) {
            return (bytes[3] & 0xFF) << 24 | (bytes[2] & 0xFF) << 16 | (bytes[1] & 0xFF) << 8 | bytes[0] & 0xFF;
        }
    }
}

