/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.api;

import com.browseengine.bobo.api.BrowseSelection;
import com.browseengine.bobo.api.FacetSpec;
import com.browseengine.bobo.facets.FacetHandlerInitializerParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;

public class BrowseRequest
implements Serializable {
    private static final long serialVersionUID = 3172092238778154933L;
    private long tid = -1L;
    private HashMap<String, BrowseSelection> _selections = new HashMap();
    private ArrayList<SortField> _sortSpecs = new ArrayList();
    private Map<String, FacetSpec> _facetSpecMap = new HashMap<String, FacetSpec>();
    private Map<String, FacetHandlerInitializerParam> _facetHandlerDataMap = new HashMap<String, FacetHandlerInitializerParam>();
    private Query _query;
    private int _offset;
    private int _count;
    private boolean _fetchStoredFields = false;
    private Filter _filter = null;
    private boolean _showExplanation;
    private String _groupBy = null;
    private int _maxPerGroup = 0;
    private boolean _collectDocIdCache = false;
    private Set<String> _termVectorsToFetch;

    public final long getTid() {
        return this.tid;
    }

    public final void setTid(long tid) {
        this.tid = tid;
    }

    public Set<String> getTermVectorsToFetch() {
        return this._termVectorsToFetch;
    }

    public void setTermVectorsToFetch(Set<String> termVectorsToFetch) {
        this._termVectorsToFetch = termVectorsToFetch;
    }

    public boolean isShowExplanation() {
        return this._showExplanation;
    }

    public BrowseRequest setShowExplanation(boolean showExplanation) {
        this._showExplanation = showExplanation;
        return this;
    }

    public Set<String> getSelectionNames() {
        return this._selections.keySet();
    }

    public void removeSelection(String name) {
        this._selections.remove(name);
    }

    public BrowseRequest setFacetSpecs(Map<String, FacetSpec> facetSpecMap) {
        this._facetSpecMap = facetSpecMap;
        return this;
    }

    public Map<String, FacetSpec> getFacetSpecs() {
        return this._facetSpecMap;
    }

    public Map<String, FacetHandlerInitializerParam> getFacetHandlerDataMap() {
        return this._facetHandlerDataMap;
    }

    public BrowseRequest setFacetHandlerDataMap(Map<String, FacetHandlerInitializerParam> facetHandlerDataMap) {
        this._facetHandlerDataMap = facetHandlerDataMap;
        return this;
    }

    public int getSelectionCount() {
        return this._selections.size();
    }

    public BrowseRequest setFilter(Filter filter) {
        this._filter = filter;
        return this;
    }

    public Filter getFilter() {
        return this._filter;
    }

    public BrowseRequest clearSelections() {
        this._selections.clear();
        return this;
    }

    public int getFacetSpecCount() {
        return this._facetSpecMap.size();
    }

    public BrowseRequest clearSort() {
        this._sortSpecs.clear();
        return this;
    }

    public boolean isFetchStoredFields() {
        return this._fetchStoredFields;
    }

    public BrowseRequest setFetchStoredFields(boolean fetchStoredFields) {
        this._fetchStoredFields = fetchStoredFields;
        return this;
    }

    public String getGroupBy() {
        return this._groupBy;
    }

    public BrowseRequest setGroupBy(String groupBy) {
        this._groupBy = groupBy;
        return this;
    }

    public int getMaxPerGroup() {
        return this._maxPerGroup;
    }

    public BrowseRequest setMaxPerGroup(int maxPerGroup) {
        this._maxPerGroup = maxPerGroup;
        return this;
    }

    public boolean getCollectDocIdCache() {
        return this._collectDocIdCache;
    }

    public BrowseRequest setCollectDocIdCache(boolean collectDocIdCache) {
        this._collectDocIdCache = collectDocIdCache;
        return this;
    }

    public BrowseRequest setFacetSpec(String name, FacetSpec facetSpec) {
        this._facetSpecMap.put(name, facetSpec);
        return this;
    }

    public FacetSpec getFacetSpec(String name) {
        return this._facetSpecMap.get(name);
    }

    public BrowseRequest setFacetHandlerData(String name, FacetHandlerInitializerParam data) {
        this._facetHandlerDataMap.put(name, data);
        return this;
    }

    public FacetHandlerInitializerParam getFacethandlerData(String name) {
        return this._facetHandlerDataMap.get(name);
    }

    public int getCount() {
        return this._count;
    }

    public BrowseRequest setCount(int count) {
        this._count = count;
        return this;
    }

    public int getOffset() {
        return this._offset;
    }

    public BrowseRequest setOffset(int offset) {
        this._offset = offset;
        return this;
    }

    public BrowseRequest setQuery(Query query) {
        this._query = query;
        return this;
    }

    public Query getQuery() {
        return this._query;
    }

    public BrowseRequest addSelection(BrowseSelection sel) {
        String[] notVals;
        String[] vals = sel.getValues();
        if (!(vals != null && vals.length != 0 || (notVals = sel.getNotValues()) != null && notVals.length != 0)) {
            return null;
        }
        this._selections.put(sel.getFieldName(), sel);
        return this;
    }

    public BrowseSelection[] getSelections() {
        return this._selections.values().toArray(new BrowseSelection[this._selections.size()]);
    }

    public BrowseSelection getSelection(String fieldname) {
        return this._selections.get(fieldname);
    }

    public Map<String, BrowseSelection> getAllSelections() {
        return this._selections;
    }

    public BrowseRequest putAllSelections(Map<String, BrowseSelection> map) {
        this._selections.putAll(map);
        return this;
    }

    public BrowseRequest addSortField(SortField sortSpec) {
        this._sortSpecs.add(sortSpec);
        return this;
    }

    public SortField[] getSort() {
        return this._sortSpecs.toArray(new SortField[this._sortSpecs.size()]);
    }

    public BrowseRequest setSort(SortField[] sorts) {
        this._sortSpecs.clear();
        for (int i = 0; i < sorts.length; ++i) {
            this._sortSpecs.add(sorts[i]);
        }
        return this;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("query: ").append(this._query).append('\n');
        buf.append("page: [").append(this._offset).append(',').append(this._count).append("]\n");
        buf.append("sort spec: ").append(this._sortSpecs).append('\n');
        buf.append("selections: ").append(this._selections).append('\n');
        buf.append("facet spec: ").append(this._facetSpecMap).append('\n');
        buf.append("fetch stored fields: ").append(this._fetchStoredFields).append('\n');
        buf.append("group by: ").append(this._groupBy);
        return buf.toString();
    }
}

