/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.query.scoring;

import com.browseengine.bobo.query.scoring.FacetTermScoringFunction;
import java.util.Arrays;
import org.apache.lucene.search.Explanation;

public class DefaultFacetTermScoringFunction
implements FacetTermScoringFunction {
    private float _sum = 0.0f;

    @Override
    public final void clearScores() {
        this._sum = 0.0f;
    }

    @Override
    public final float score(int df, float boost) {
        return boost;
    }

    @Override
    public final void scoreAndCollect(int df, float boost) {
        this._sum += boost;
    }

    @Override
    public final float getCurrentScore() {
        return this._sum;
    }

    @Override
    public Explanation explain(int df, float boost) {
        Explanation expl = new Explanation();
        expl.setValue(this.score(df, boost));
        expl.setDescription("facet boost value of: " + boost);
        return expl;
    }

    @Override
    public Explanation explain(float ... scores) {
        Explanation expl = new Explanation();
        float sum = 0.0f;
        for (float score : scores) {
            sum += score;
        }
        expl.setValue(sum);
        expl.setDescription("sum of: " + Arrays.toString(scores));
        return expl;
    }
}

