/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.filter;

import com.browseengine.bobo.api.BoboIndexReader;
import com.browseengine.bobo.docidset.EmptyDocIdSet;
import com.browseengine.bobo.docidset.RandomAccessDocIdSet;
import com.browseengine.bobo.facets.FacetHandler;
import com.browseengine.bobo.facets.data.FacetDataCache;
import com.browseengine.bobo.facets.filter.FacetValueConverter;
import com.browseengine.bobo.facets.filter.RandomAccessFilter;
import com.browseengine.bobo.facets.impl.RangeFacetHandler;
import com.browseengine.bobo.util.BigSegmentedArray;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.IOException;
import org.apache.lucene.search.DocIdSetIterator;

public final class FacetRangeFilter
extends RandomAccessFilter {
    private static final long serialVersionUID = 1L;
    private final FacetHandler<FacetDataCache> _facetHandler;
    private final String _rangeString;

    public FacetRangeFilter(FacetHandler<FacetDataCache> facetHandler, String rangeString) {
        this._facetHandler = facetHandler;
        this._rangeString = rangeString;
    }

    @Override
    public double getFacetSelectivity(BoboIndexReader reader) {
        double selectivity = 0.0;
        FacetDataCache dataCache = this._facetHandler.getFacetData(reader);
        int[] range = FacetRangeFilter.parse(dataCache, this._rangeString);
        if (range != null) {
            int accumFreq = 0;
            for (int idx = range[0]; idx <= range[1]; ++idx) {
                accumFreq += dataCache.freqs[idx];
            }
            int total = reader.maxDoc();
            selectivity = (double)accumFreq / (double)total;
        }
        if (selectivity > 0.999) {
            selectivity = 1.0;
        }
        return selectivity;
    }

    public static int[] convertIndexes(FacetDataCache dataCache, String[] vals) {
        IntArrayList list = new IntArrayList();
        for (String val : vals) {
            int[] range = FacetRangeFilter.parse(dataCache, val);
            if (range == null) continue;
            for (int i = range[0]; i <= range[1]; ++i) {
                list.add(i);
            }
        }
        return list.toIntArray();
    }

    public static int[] parse(FacetDataCache dataCache, String rangeString) {
        int end;
        int start;
        String[] ranges = RangeFacetHandler.getRangeStrings(rangeString);
        String lower = ranges[0];
        String upper = ranges[1];
        if ("*".equals(lower)) {
            lower = null;
        }
        if ("*".equals(upper)) {
            upper = null;
        }
        if (lower == null) {
            start = 1;
        } else {
            start = dataCache.valArray.indexOf(lower);
            if (start < 0) {
                start = -(start + 1);
            }
        }
        if (upper == null) {
            end = dataCache.valArray.size() - 1;
        } else {
            end = dataCache.valArray.indexOf(upper);
            if (end < 0) {
                end = -(end + 1);
                end = Math.max(0, end - 1);
            }
        }
        return new int[]{start, end};
    }

    @Override
    public RandomAccessDocIdSet getRandomAccessDocIdSet(BoboIndexReader reader) throws IOException {
        final FacetDataCache dataCache = this._facetHandler.getFacetData(reader);
        final int[] range = FacetRangeFilter.parse(dataCache, this._rangeString);
        if (range == null) {
            return null;
        }
        if (range[0] > range[1]) {
            return EmptyDocIdSet.getInstance();
        }
        if (range[0] == range[1] && range[0] < 0) {
            return EmptyDocIdSet.getInstance();
        }
        return new RandomAccessDocIdSet(){
            int _start;
            int _end;
            {
                this._start = range[0];
                this._end = range[1];
            }

            @Override
            public final boolean get(int docId) {
                int index = dataCache.orderArray.get(docId);
                return index >= this._start && index <= this._end;
            }

            public DocIdSetIterator iterator() {
                return new FacetRangeDocIdSetIterator(this._start, this._end, dataCache);
            }
        };
    }

    public static class FacetRangeValueConverter
    implements FacetValueConverter {
        public static FacetRangeValueConverter instance = new FacetRangeValueConverter();

        private FacetRangeValueConverter() {
        }

        @Override
        public int[] convert(FacetDataCache dataCache, String[] vals) {
            return FacetRangeFilter.convertIndexes(dataCache, vals);
        }
    }

    private static final class FacetRangeDocIdSetIterator
    extends DocIdSetIterator {
        private int _doc = -1;
        private int _totalFreq = 0;
        private int _minID = Integer.MAX_VALUE;
        private int _maxID = -1;
        private final int _start;
        private final int _end;
        private final BigSegmentedArray _orderArray;

        FacetRangeDocIdSetIterator(int start, int end, FacetDataCache dataCache) {
            this._start = start;
            this._end = end;
            for (int i = start; i <= end; ++i) {
                this._totalFreq += dataCache.freqs[i];
                this._minID = Math.min(this._minID, dataCache.minIDs[i]);
                this._maxID = Math.max(this._maxID, dataCache.maxIDs[i]);
            }
            this._doc = Math.max(-1, this._minID - 1);
            this._orderArray = dataCache.orderArray;
        }

        public final int docID() {
            return this._doc;
        }

        public final int nextDoc() throws IOException {
            this._doc = this._doc < this._maxID ? this._orderArray.findValueRange(this._start, this._end, this._doc + 1, this._maxID) : Integer.MAX_VALUE;
            return this._doc;
        }

        public final int advance(int id) throws IOException {
            if (this._doc < id) {
                this._doc = id <= this._maxID ? this._orderArray.findValueRange(this._start, this._end, id, this._maxID) : Integer.MAX_VALUE;
                return this._doc;
            }
            return this.nextDoc();
        }
    }
}

