/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.search.section;

import com.browseengine.bobo.search.section.AndNode;
import com.browseengine.bobo.search.section.TermNode;
import java.io.IOException;
import org.apache.lucene.index.IndexReader;

public class PhraseNode
extends AndNode {
    private TermNode[] _termNodes;
    private int _curPos;

    public PhraseNode(TermNode[] termNodes, IndexReader reader) throws IOException {
        super(termNodes);
        this._termNodes = termNodes;
    }

    @Override
    public int fetchDoc(int targetDoc) throws IOException {
        this._curPos = -1;
        return super.fetchDoc(targetDoc);
    }

    @Override
    public int fetchSec(int targetSec) throws IOException {
        TermNode firstNode = this._termNodes[0];
        while (this.fetchPos() < Integer.MAX_VALUE) {
            int secId = firstNode.readSecId();
            if (secId < targetSec) continue;
            targetSec = secId;
            boolean matched = true;
            for (int i = 1; i < this._termNodes.length; ++i) {
                boolean bl = matched = targetSec == this._termNodes[i].readSecId();
                if (!matched) break;
            }
            if (!matched) continue;
            this._curSec = targetSec;
            return this._curSec;
        }
        this._curSec = Integer.MAX_VALUE;
        return this._curSec;
    }

    @Override
    protected int fetchPos() throws IOException {
        int targetPhrasePos = this._curPos + 1;
        int i = 0;
        while (i < this._termNodes.length) {
            TermNode node = this._termNodes[i];
            int targetTermPos = targetPhrasePos + node._positionInPhrase;
            while (node._curPos < targetTermPos) {
                if (node.fetchPos() != Integer.MAX_VALUE) continue;
                this._curPos = Integer.MAX_VALUE;
                return this._curPos;
            }
            if (node._curPos == targetTermPos) {
                ++i;
                continue;
            }
            targetPhrasePos = node._curPos - i;
            i = 0;
        }
        this._curPos = targetPhrasePos;
        return this._curPos;
    }
}

