/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.query.scoring;

import com.browseengine.bobo.api.BoboIndexReader;
import com.browseengine.bobo.api.BrowseSelection;
import com.browseengine.bobo.docidset.RandomAccessDocIdSet;
import com.browseengine.bobo.facets.FacetHandler;
import com.browseengine.bobo.facets.filter.RandomAccessFilter;
import com.browseengine.bobo.query.MatchAllDocIdSetIterator;
import com.browseengine.bobo.query.scoring.BoboDocScorer;
import com.browseengine.bobo.query.scoring.DefaultFacetTermScoringFunctionFactory;
import com.browseengine.bobo.query.scoring.FacetScoreable;
import com.browseengine.bobo.query.scoring.FacetTermScoringFunctionFactory;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;

public class FacetTermQuery
extends Query {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(FacetTermQuery.class);
    private final String _name;
    private final BrowseSelection _sel;
    private final FacetTermScoringFunctionFactory _scoringFactory;
    private final Map<String, Float> _boostMap;

    public FacetTermQuery(BrowseSelection sel, Map<String, Float> boostMap) {
        this(sel, boostMap, new DefaultFacetTermScoringFunctionFactory());
    }

    public FacetTermQuery(BrowseSelection sel, Map<String, Float> boostMap, FacetTermScoringFunctionFactory scoringFactory) {
        this._name = sel.getFieldName();
        this._sel = sel;
        this._scoringFactory = scoringFactory;
        this._boostMap = boostMap;
    }

    public String getName() {
        return this._name;
    }

    public Map<String, Float> getBoostMap() {
        return this._boostMap;
    }

    public String toString(String fieldname) {
        return String.valueOf(this._sel);
    }

    public Weight createWeight(Searcher searcher) throws IOException {
        return new FacetTermWeight(searcher.getSimilarity());
    }

    public void extractTerms(Set terms) {
        String[] vals;
        for (String val : vals = this._sel.getValues()) {
            terms.add(new Term(this._name, val));
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!(obj instanceof FacetTermQuery)) {
            return false;
        }
        FacetTermQuery other = (FacetTermQuery)((Object)obj);
        if (!this.toString().equals(other.toString())) {
            return false;
        }
        if (!this._name.equals(other.getName())) {
            return false;
        }
        Map<String, Float> _boostMap_1 = this._boostMap;
        Map<String, Float> _boostMap_2 = other.getBoostMap();
        if (_boostMap_1.size() != _boostMap_2.size()) {
            return false;
        }
        for (String key_1 : _boostMap_1.keySet()) {
            if (!_boostMap_2.containsKey(key_1)) {
                return false;
            }
            float boost_1 = _boostMap_1.get(key_1).floatValue();
            float boost_2 = _boostMap_2.get(key_1).floatValue();
            if (Float.floatToIntBits(boost_1) == Float.floatToIntBits(boost_2)) continue;
            return false;
        }
        return true;
    }

    private class FacetTermScorer
    extends Scorer {
        private final DocIdSetIterator _docSetIter;
        private final BoboDocScorer _scorer;

        protected FacetTermScorer(Similarity similarity, DocIdSetIterator docidsetIter, BoboDocScorer scorer) {
            super(similarity);
            this._docSetIter = docidsetIter;
            this._scorer = scorer;
        }

        public float score() throws IOException {
            return this._scorer == null ? 1.0f : this._scorer.score(this._docSetIter.docID()) * FacetTermQuery.this.getBoost();
        }

        public int docID() {
            return this._docSetIter.docID();
        }

        public int nextDoc() throws IOException {
            return this._docSetIter.nextDoc();
        }

        public int advance(int target) throws IOException {
            return this._docSetIter.advance(target);
        }
    }

    private class FacetTermWeight
    extends Weight {
        private static final long serialVersionUID = 1L;
        Similarity _similarity;
        private float value;

        public FacetTermWeight(Similarity sim) {
            this._similarity = sim;
        }

        public Explanation explain(IndexReader reader, int docid) throws IOException {
            BoboIndexReader boboReader = (BoboIndexReader)reader;
            FacetHandler<?> fhandler = boboReader.getFacetHandler(FacetTermQuery.this._name);
            if (fhandler != null) {
                BoboDocScorer scorer = null;
                if (fhandler instanceof FacetScoreable) {
                    scorer = ((FacetScoreable)((Object)fhandler)).getDocScorer(boboReader, FacetTermQuery.this._scoringFactory, FacetTermQuery.this._boostMap);
                    Explanation exp1 = scorer.explain(docid);
                    Explanation exp2 = new Explanation(FacetTermQuery.this.getBoost(), "boost");
                    Explanation expl = new Explanation();
                    expl.setDescription("product of:");
                    expl.setValue(exp1.getValue() * exp2.getValue());
                    expl.addDetail(exp1);
                    expl.addDetail(exp2);
                    return expl;
                }
                return null;
            }
            return null;
        }

        public Query getQuery() {
            return FacetTermQuery.this;
        }

        public float getValue() {
            return this.value;
        }

        public void normalize(float norm) {
            this.value = FacetTermQuery.this.getBoost();
        }

        private final DocIdSetIterator buildIterator(final RandomAccessDocIdSet docset, final TermDocs td) {
            return new DocIdSetIterator(){
                private int doc = Integer.MAX_VALUE;

                public int advance(int target) throws IOException {
                    if (td.skipTo(target)) {
                        this.doc = td.doc();
                        while (!docset.get(this.doc)) {
                            if (td.next()) {
                                this.doc = td.doc();
                                continue;
                            }
                            this.doc = Integer.MAX_VALUE;
                            break;
                        }
                        return this.doc;
                    }
                    this.doc = Integer.MAX_VALUE;
                    return this.doc;
                }

                public int docID() {
                    return this.doc;
                }

                public int nextDoc() throws IOException {
                    if (td.next()) {
                        this.doc = td.doc();
                        while (!docset.get(this.doc)) {
                            if (td.next()) {
                                this.doc = td.doc();
                                continue;
                            }
                            this.doc = Integer.MAX_VALUE;
                            break;
                        }
                        return this.doc;
                    }
                    this.doc = Integer.MAX_VALUE;
                    return this.doc;
                }
            };
        }

        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            if (reader instanceof BoboIndexReader) {
                BoboIndexReader boboReader = (BoboIndexReader)reader;
                TermDocs termDocs = boboReader.termDocs(null);
                FacetHandler<?> fhandler = boboReader.getFacetHandler(FacetTermQuery.this._name);
                if (fhandler != null) {
                    RandomAccessDocIdSet docset;
                    MatchAllDocIdSetIterator dociter = null;
                    RandomAccessFilter filter = fhandler.buildFilter(FacetTermQuery.this._sel);
                    if (filter != null && (docset = filter.getRandomAccessDocIdSet(boboReader)) != null) {
                        dociter = this.buildIterator(docset, termDocs);
                    }
                    if (dociter == null) {
                        dociter = new MatchAllDocIdSetIterator(reader);
                    }
                    BoboDocScorer scorer = null;
                    if (fhandler instanceof FacetScoreable) {
                        scorer = ((FacetScoreable)((Object)fhandler)).getDocScorer(boboReader, FacetTermQuery.this._scoringFactory, FacetTermQuery.this._boostMap);
                    }
                    return new FacetTermScorer(this._similarity, dociter, scorer);
                }
                logger.error((Object)("FacetHandler is not defined for the field: " + FacetTermQuery.this._name));
                return null;
            }
            throw new IOException("index reader not instance of " + BoboIndexReader.class);
        }

        public float sumOfSquaredWeights() throws IOException {
            return 0.0f;
        }
    }
}

