/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.filter;

import com.browseengine.bobo.api.BoboIndexReader;
import com.browseengine.bobo.docidset.RandomAccessDocIdSet;
import com.browseengine.bobo.facets.filter.RandomAccessFilter;
import com.kamikaze.docidset.impl.AndDocIdSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;

public class RandomAccessAndFilter
extends RandomAccessFilter {
    private static final long serialVersionUID = 1L;
    protected List<RandomAccessFilter> _filters;

    public RandomAccessAndFilter(List<RandomAccessFilter> filters) {
        this._filters = filters;
    }

    @Override
    public double getFacetSelectivity(BoboIndexReader reader) {
        double selectivity = Double.MAX_VALUE;
        for (RandomAccessFilter filter : this._filters) {
            double curSelectivity = filter.getFacetSelectivity(reader);
            if (!(selectivity > curSelectivity)) continue;
            selectivity = curSelectivity;
        }
        if (selectivity > 0.999) {
            selectivity = 1.0;
        }
        return selectivity;
    }

    @Override
    public RandomAccessDocIdSet getRandomAccessDocIdSet(BoboIndexReader reader) throws IOException {
        if (this._filters.size() == 1) {
            return this._filters.get(0).getRandomAccessDocIdSet(reader);
        }
        ArrayList<RandomAccessDocIdSet> list = new ArrayList<RandomAccessDocIdSet>(this._filters.size());
        ArrayList<RandomAccessDocIdSet> randomAccessList = new ArrayList<RandomAccessDocIdSet>(this._filters.size());
        for (RandomAccessFilter f : this._filters) {
            RandomAccessDocIdSet s = f.getRandomAccessDocIdSet(reader);
            list.add(s);
            randomAccessList.add(s);
        }
        final RandomAccessDocIdSet[] randomAccessDocIdSets = randomAccessList.toArray(new RandomAccessDocIdSet[randomAccessList.size()]);
        AndDocIdSet andDocIdSet = new AndDocIdSet(list);
        return new RandomAccessDocIdSet((DocIdSet)andDocIdSet){
            final /* synthetic */ DocIdSet val$andDocIdSet;
            {
                this.val$andDocIdSet = docIdSet;
            }

            @Override
            public boolean get(int docId) {
                for (RandomAccessDocIdSet s : randomAccessDocIdSets) {
                    if (s.get(docId)) continue;
                    return false;
                }
                return true;
            }

            public DocIdSetIterator iterator() throws IOException {
                return this.val$andDocIdSet.iterator();
            }
        };
    }
}

