/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.query;

import com.browseengine.bobo.api.BoboIndexReader;
import com.browseengine.bobo.facets.FacetHandler;
import com.browseengine.bobo.query.ScorerBuilder;
import com.browseengine.bobo.query.scoring.BoboDocScorer;
import com.browseengine.bobo.query.scoring.FacetScoreable;
import com.browseengine.bobo.query.scoring.FacetTermScoringFunctionFactory;
import com.browseengine.bobo.query.scoring.MultiplicativeFacetTermScoringFunctionFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Similarity;

public class FacetBasedBoostScorerBuilder
implements ScorerBuilder {
    protected final Map<String, Map<String, Float>> _boostMaps;
    protected final FacetTermScoringFunctionFactory _scoringFunctionFactory;

    public FacetBasedBoostScorerBuilder(Map<String, Map<String, Float>> boostMaps) {
        this(boostMaps, new MultiplicativeFacetTermScoringFunctionFactory());
    }

    protected FacetBasedBoostScorerBuilder(Map<String, Map<String, Float>> boostMaps, FacetTermScoringFunctionFactory scoringFunctionFactory) {
        this._boostMaps = boostMaps;
        this._scoringFunctionFactory = scoringFunctionFactory;
    }

    @Override
    public Scorer createScorer(Scorer innerScorer, IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
        if (!(reader instanceof BoboIndexReader)) {
            throw new IllegalArgumentException("IndexReader is not BoboIndexReader");
        }
        return new FacetBasedBoostingScorer((BoboIndexReader)reader, innerScorer.getSimilarity(), innerScorer);
    }

    @Override
    public Explanation explain(IndexReader indexReader, int docid, Explanation innerExplaination) throws IOException {
        if (!(indexReader instanceof BoboIndexReader)) {
            throw new IllegalArgumentException("IndexReader is not BoboIndexReader");
        }
        BoboIndexReader reader = (BoboIndexReader)indexReader;
        Explanation exp = new Explanation();
        exp.setDescription("FacetBasedBoost");
        float boost = 1.0f;
        for (Map.Entry<String, Map<String, Float>> boostEntry : this._boostMaps.entrySet()) {
            String facetName = boostEntry.getKey();
            FacetHandler<?> handler = reader.getFacetHandler(facetName);
            if (!(handler instanceof FacetScoreable)) {
                throw new IllegalArgumentException(facetName + " does not implement FacetScoreable");
            }
            FacetScoreable facetScoreable = (FacetScoreable)((Object)handler);
            BoboDocScorer scorer = facetScoreable.getDocScorer(reader, this._scoringFunctionFactory, boostEntry.getValue());
            float facetBoost = scorer.score(docid);
            Explanation facetExp = new Explanation();
            facetExp.setDescription(facetName);
            facetExp.setValue(facetBoost);
            facetExp.addDetail(scorer.explain(docid));
            boost *= facetBoost;
            exp.addDetail(facetExp);
        }
        exp.setValue(boost);
        exp.addDetail(innerExplaination);
        return exp;
    }

    private class FacetBasedBoostingScorer
    extends Scorer {
        private final Scorer _innerScorer;
        private final BoboDocScorer[] _facetScorers;
        private int _docid;

        public FacetBasedBoostingScorer(BoboIndexReader reader, Similarity similarity, Scorer innerScorer) {
            super(similarity);
            this._innerScorer = innerScorer;
            ArrayList<BoboDocScorer> list = new ArrayList<BoboDocScorer>();
            for (Map.Entry<String, Map<String, Float>> boostEntry : FacetBasedBoostScorerBuilder.this._boostMaps.entrySet()) {
                String facetName = boostEntry.getKey();
                FacetHandler<?> handler = reader.getFacetHandler(facetName);
                if (!(handler instanceof FacetScoreable)) {
                    throw new IllegalArgumentException(facetName + " does not implement FacetScoreable");
                }
                FacetScoreable facetScoreable = (FacetScoreable)((Object)handler);
                BoboDocScorer scorer = facetScoreable.getDocScorer(reader, FacetBasedBoostScorerBuilder.this._scoringFunctionFactory, boostEntry.getValue());
                if (scorer == null) continue;
                list.add(scorer);
            }
            this._facetScorers = list.toArray(new BoboDocScorer[list.size()]);
            this._docid = -1;
        }

        public float score() throws IOException {
            float score = this._innerScorer.score();
            for (BoboDocScorer facetScorer : this._facetScorers) {
                score *= facetScorer.score(this._docid);
            }
            return score;
        }

        public int docID() {
            return this._docid;
        }

        public int nextDoc() throws IOException {
            this._docid = this._innerScorer.nextDoc();
            return this._docid;
        }

        public int advance(int target) throws IOException {
            this._docid = this._innerScorer.advance(target);
            return this._docid;
        }

        public int doc() {
            return this._docid;
        }

        public boolean next() throws IOException {
            return this.nextDoc() != Integer.MAX_VALUE;
        }

        public boolean skipTo(int target) throws IOException {
            return this.advance(target) != Integer.MAX_VALUE;
        }
    }
}

