/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.impl;

import com.browseengine.bobo.api.BoboIndexReader;
import com.browseengine.bobo.api.BrowseSelection;
import com.browseengine.bobo.api.FacetSpec;
import com.browseengine.bobo.facets.FacetCountCollector;
import com.browseengine.bobo.facets.FacetCountCollectorSource;
import com.browseengine.bobo.facets.FacetHandler;
import com.browseengine.bobo.facets.data.FacetDataCache;
import com.browseengine.bobo.facets.data.TermListFactory;
import com.browseengine.bobo.facets.filter.EmptyFilter;
import com.browseengine.bobo.facets.filter.FacetFilter;
import com.browseengine.bobo.facets.filter.FacetOrFilter;
import com.browseengine.bobo.facets.filter.RandomAccessFilter;
import com.browseengine.bobo.facets.filter.RandomAccessNotFilter;
import com.browseengine.bobo.facets.impl.DefaultFacetCountCollector;
import com.browseengine.bobo.query.scoring.BoboDocScorer;
import com.browseengine.bobo.query.scoring.FacetScoreable;
import com.browseengine.bobo.query.scoring.FacetTermScoringFunctionFactory;
import com.browseengine.bobo.sort.DocComparatorSource;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Explanation;

public class SimpleFacetHandler
extends FacetHandler<FacetDataCache>
implements FacetScoreable {
    private static Logger logger = Logger.getLogger(SimpleFacetHandler.class);
    private final TermListFactory _termListFactory;
    private final String _indexFieldName;

    public SimpleFacetHandler(String name, String indexFieldName, TermListFactory termListFactory) {
        super(name);
        this._indexFieldName = indexFieldName;
        this._termListFactory = termListFactory;
    }

    public SimpleFacetHandler(String name, TermListFactory termListFactory) {
        this(name, name, termListFactory);
    }

    public SimpleFacetHandler(String name) {
        this(name, name, null);
    }

    public SimpleFacetHandler(String name, String indexFieldName) {
        this(name, indexFieldName, null);
    }

    @Override
    public DocComparatorSource getDocComparatorSource() {
        return new FacetDataCache.FacetDocComparatorSource(this);
    }

    @Override
    public String[] getFieldValues(BoboIndexReader reader, int id) {
        FacetDataCache dataCache = (FacetDataCache)this.getFacetData(reader);
        return new String[]{dataCache.valArray.get(dataCache.orderArray.get(id))};
    }

    @Override
    public Object[] getRawFieldValues(BoboIndexReader reader, int id) {
        FacetDataCache dataCache = (FacetDataCache)this.getFacetData(reader);
        return new Object[]{dataCache.valArray.getRawValue(dataCache.orderArray.get(id))};
    }

    @Override
    public RandomAccessFilter buildRandomAccessFilter(String value, Properties prop) throws IOException {
        return new FacetFilter(this, value);
    }

    @Override
    public RandomAccessFilter buildRandomAccessAndFilter(String[] vals, Properties prop) throws IOException {
        if (vals.length > 1) {
            return EmptyFilter.getInstance();
        }
        return this.buildRandomAccessFilter(vals[0], prop);
    }

    @Override
    public RandomAccessFilter buildRandomAccessOrFilter(String[] vals, Properties prop, boolean isNot) throws IOException {
        RandomAccessFilter filter = null;
        if (vals.length > 1) {
            return new FacetOrFilter(this, vals, isNot);
        }
        filter = vals.length == 1 ? new FacetFilter(this, vals[0]) : EmptyFilter.getInstance();
        if (isNot) {
            filter = new RandomAccessNotFilter(filter);
        }
        return filter;
    }

    @Override
    public FacetCountCollectorSource getFacetCountCollectorSource(final BrowseSelection sel, final FacetSpec ospec) {
        return new FacetCountCollectorSource(){

            @Override
            public FacetCountCollector getFacetCountCollector(BoboIndexReader reader, int docBase) {
                FacetDataCache dataCache = (FacetDataCache)SimpleFacetHandler.this.getFacetData(reader);
                return new SimpleFacetCountCollector(SimpleFacetHandler.this._name, dataCache, docBase, sel, ospec);
            }
        };
    }

    @Override
    public FacetDataCache load(BoboIndexReader reader) throws IOException {
        FacetDataCache dataCache = new FacetDataCache();
        dataCache.load(this._indexFieldName, (IndexReader)reader, this._termListFactory);
        return dataCache;
    }

    @Override
    public BoboDocScorer getDocScorer(BoboIndexReader reader, FacetTermScoringFunctionFactory scoringFunctionFactory, Map<String, Float> boostMap) {
        FacetDataCache dataCache = (FacetDataCache)this.getFacetData(reader);
        float[] boostList = BoboDocScorer.buildBoostList(dataCache.valArray, boostMap);
        return new SimpleBoboDocScorer(dataCache, scoringFunctionFactory, boostList);
    }

    public static final class SimpleBoboDocScorer
    extends BoboDocScorer {
        private final FacetDataCache _dataCache;

        public SimpleBoboDocScorer(FacetDataCache dataCache, FacetTermScoringFunctionFactory scoreFunctionFactory, float[] boostList) {
            super(scoreFunctionFactory.getFacetTermScoringFunction(dataCache.valArray.size(), dataCache.orderArray.size()), boostList);
            this._dataCache = dataCache;
        }

        @Override
        public Explanation explain(int doc) {
            int idx = this._dataCache.orderArray.get(doc);
            return this._function.explain(this._dataCache.freqs[idx], this._boostList[idx]);
        }

        @Override
        public final float score(int docid) {
            int idx = this._dataCache.orderArray.get(docid);
            return this._function.score(this._dataCache.freqs[idx], this._boostList[idx]);
        }
    }

    public static final class SimpleFacetCountCollector
    extends DefaultFacetCountCollector {
        public SimpleFacetCountCollector(String name, FacetDataCache dataCache, int docBase, BrowseSelection sel, FacetSpec ospec) {
            super(name, dataCache, docBase, sel, ospec);
        }

        @Override
        public final void collect(int docid) {
            int n = this._array.get(docid);
            this._count[n] = this._count[n] + 1;
        }

        @Override
        public final void collectAll() {
            this._count = this._dataCache.freqs;
        }
    }
}

