/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.managers.trashedfiles;

import com.box.sdkgen.internal.utils.Entry;
import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.managers.trashedfiles.DeleteTrashedFileByIdHeaders;
import com.box.sdkgen.managers.trashedfiles.GetTrashedFileByIdHeaders;
import com.box.sdkgen.managers.trashedfiles.GetTrashedFileByIdQueryParams;
import com.box.sdkgen.managers.trashedfiles.RestoreFileFromTrashHeaders;
import com.box.sdkgen.managers.trashedfiles.RestoreFileFromTrashQueryParams;
import com.box.sdkgen.managers.trashedfiles.RestoreFileFromTrashRequestBody;
import com.box.sdkgen.networking.auth.Authentication;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.networking.network.NetworkSession;
import com.box.sdkgen.schemas.trashfile.TrashFile;
import com.box.sdkgen.schemas.trashfilerestored.TrashFileRestored;
import com.box.sdkgen.serialization.json.JsonManager;
import java.util.Map;

public class TrashedFilesManager {
    public Authentication auth;
    public NetworkSession networkSession;

    public TrashedFilesManager() {
        this.networkSession = new NetworkSession();
    }

    protected TrashedFilesManager(Builder builder) {
        this.auth = builder.auth;
        this.networkSession = builder.networkSession;
    }

    public TrashFileRestored restoreFileFromTrash(String fileId) {
        return this.restoreFileFromTrash(fileId, new RestoreFileFromTrashRequestBody(), new RestoreFileFromTrashQueryParams(), new RestoreFileFromTrashHeaders());
    }

    public TrashFileRestored restoreFileFromTrash(String fileId, RestoreFileFromTrashRequestBody requestBody) {
        return this.restoreFileFromTrash(fileId, requestBody, new RestoreFileFromTrashQueryParams(), new RestoreFileFromTrashHeaders());
    }

    public TrashFileRestored restoreFileFromTrash(String fileId, RestoreFileFromTrashQueryParams queryParams) {
        return this.restoreFileFromTrash(fileId, new RestoreFileFromTrashRequestBody(), queryParams, new RestoreFileFromTrashHeaders());
    }

    public TrashFileRestored restoreFileFromTrash(String fileId, RestoreFileFromTrashRequestBody requestBody, RestoreFileFromTrashQueryParams queryParams) {
        return this.restoreFileFromTrash(fileId, requestBody, queryParams, new RestoreFileFromTrashHeaders());
    }

    public TrashFileRestored restoreFileFromTrash(String fileId, RestoreFileFromTrashHeaders headers) {
        return this.restoreFileFromTrash(fileId, new RestoreFileFromTrashRequestBody(), new RestoreFileFromTrashQueryParams(), headers);
    }

    public TrashFileRestored restoreFileFromTrash(String fileId, RestoreFileFromTrashRequestBody requestBody, RestoreFileFromTrashHeaders headers) {
        return this.restoreFileFromTrash(fileId, requestBody, new RestoreFileFromTrashQueryParams(), headers);
    }

    public TrashFileRestored restoreFileFromTrash(String fileId, RestoreFileFromTrashQueryParams queryParams, RestoreFileFromTrashHeaders headers) {
        return this.restoreFileFromTrash(fileId, new RestoreFileFromTrashRequestBody(), queryParams, headers);
    }

    public TrashFileRestored restoreFileFromTrash(String fileId, RestoreFileFromTrashRequestBody requestBody, RestoreFileFromTrashQueryParams queryParams, RestoreFileFromTrashHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/files/", UtilsManager.convertToString(fileId)), "POST").params(queryParamsMap).headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), TrashFileRestored.class);
    }

    public TrashFile getTrashedFileById(String fileId) {
        return this.getTrashedFileById(fileId, new GetTrashedFileByIdQueryParams(), new GetTrashedFileByIdHeaders());
    }

    public TrashFile getTrashedFileById(String fileId, GetTrashedFileByIdQueryParams queryParams) {
        return this.getTrashedFileById(fileId, queryParams, new GetTrashedFileByIdHeaders());
    }

    public TrashFile getTrashedFileById(String fileId, GetTrashedFileByIdHeaders headers) {
        return this.getTrashedFileById(fileId, new GetTrashedFileByIdQueryParams(), headers);
    }

    public TrashFile getTrashedFileById(String fileId, GetTrashedFileByIdQueryParams queryParams, GetTrashedFileByIdHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/files/", UtilsManager.convertToString(fileId), "/trash"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), TrashFile.class);
    }

    public void deleteTrashedFileById(String fileId) {
        this.deleteTrashedFileById(fileId, new DeleteTrashedFileByIdHeaders());
    }

    public void deleteTrashedFileById(String fileId, DeleteTrashedFileByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/files/", UtilsManager.convertToString(fileId), "/trash"), "DELETE").headers(headersMap).responseFormat(ResponseFormat.NO_CONTENT).auth(this.auth).networkSession(this.networkSession).build());
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public NetworkSession getNetworkSession() {
        return this.networkSession;
    }

    public static class Builder {
        protected Authentication auth;
        protected NetworkSession networkSession = new NetworkSession();

        public Builder auth(Authentication auth) {
            this.auth = auth;
            return this;
        }

        public Builder networkSession(NetworkSession networkSession) {
            this.networkSession = networkSession;
            return this;
        }

        public TrashedFilesManager build() {
            return new TrashedFilesManager(this);
        }
    }
}

