/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.shape;

import com.bbn.openmap.layer.shape.ESRIPoint;
import com.bbn.openmap.util.HashCodeUtil;

public class ESRIBoundingBox {
    public ESRIPoint min;
    public ESRIPoint max;

    public ESRIBoundingBox() {
    }

    public ESRIBoundingBox(ESRIPoint point) {
        this(point.x, point.y);
    }

    public ESRIBoundingBox(double x, double y) {
        this.addPoint(x, y);
    }

    public ESRIBoundingBox(ESRIPoint _min, ESRIPoint _max) {
        this.addPoint(_min);
        this.addPoint(_max);
    }

    public void addBounds(ESRIBoundingBox bb) {
        this.addPoint(bb.min);
        this.addPoint(bb.max);
    }

    public void addPoints(ESRIPoint[] points) {
        for (int j = 0; j < points.length; ++j) {
            this.addPoint(points[j]);
        }
    }

    public void addPoint(ESRIPoint point) {
        this.addPoint(point.x, point.y);
    }

    public void addPoint(double x, double y) {
        if (this.min == null) {
            this.min = new ESRIPoint(x, y);
            this.max = new ESRIPoint(x, y);
        } else {
            if (this.min.x > x) {
                this.min.x = x;
            }
            if (this.min.y > y) {
                this.min.y = y;
            }
            if (this.max.x < x) {
                this.max.x = x;
            }
            if (this.max.y < y) {
                this.max.y = y;
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ESRIBoundingBox bb = (ESRIBoundingBox)obj;
        return this.min.equals(bb.min) && this.max.equals(bb.max);
    }

    public int hashCode() {
        int result = 17;
        result = HashCodeUtil.hash(result, this.min.x);
        result = HashCodeUtil.hash(result, this.min.y);
        result = HashCodeUtil.hash(result, this.max.x);
        result = HashCodeUtil.hash(result, this.max.y);
        return result;
    }
}

