/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.etopo;

import com.bbn.openmap.io.BinaryBufferedFile;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.layer.policy.ListResetPCPolicy;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMRaster;
import com.bbn.openmap.proj.CADRG;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PaletteHelper;
import com.bbn.openmap.util.PropUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ETOPOLayer
extends OMGraphicHandlerLayer
implements ActionListener {
    public static final int SLOPESHADING = 0;
    public static final int COLOREDSHADING = 1;
    public static final int DEFAULT_SLOPE_ADJUST = 3;
    public static final int DEFAULT_MINUTE_SPACING = 10;
    public static final int DEFAULT_OPAQUENESS = 255;
    protected String path;
    protected short[] dataBuffer = null;
    protected int bufferWidth;
    protected int bufferHeight;
    protected int minuteSpacing;
    protected static final String[] etopoFileNames = new String[]{"/ETOPO2", "/ETOPO5", "/ETOPO10", "/ETOPO15"};
    protected static final int[] etopoWidths = new int[]{10800, 4320, 2160, 1440};
    protected static final int[] etopoHeights = new int[]{5400, 2160, 1080, 720};
    protected static final double[] etopoSpacings = new double[]{1800.0, 3500.0, 7000.0, 10500.0};
    protected int viewType;
    protected int bandHeight;
    protected int slopeAdjust;
    protected int opaqueness;
    protected int spacer = 0;
    public static final String ETOPOPathProperty = "path";
    public static final String OpaquenessProperty = "opaque";
    public static final String ETOPOViewTypeProperty = "view.type";
    public static final String ETOPOSlopeAdjustProperty = "contrast";
    public static final String ETOPOMinuteSpacingProperty = "minute.spacing";
    public static final String ETOPOPixelSpacerProperty = "spacer";
    protected byte[] slopeMap = null;
    protected static final int[] elevLimit = new int[]{-11000, -9000, -7000, -5000, -3000, -1500, 0, 250, 500, 750, 1000, 2000, 3500, 5000};
    protected static final int elevLimitCnt = 14;
    protected static final int[] redElev = new int[]{0, 0, 4, 20, 124, 130, 135, 117, 252, 253, 229, 244, 252, 132};
    protected static final int[] greenElev = new int[]{2, 12, 51, 159, 235, 255, 235, 255, 236, 162, 115, 50, 20, 132};
    protected static final int[] blueElev = new int[]{76, 145, 242, 249, 252, 255, 110, 58, 29, 35, 5, 14, 46, 132};
    protected static Color[][] slopeColors = null;
    protected boolean slopeReset = true;
    protected boolean spacingReset = true;
    protected Box palette = null;

    public ETOPOLayer() {
        this(null);
    }

    public ETOPOLayer(String pathToETOPODir) {
        this.setName("ETOPO");
        this.setDefaultValues();
        this.path = pathToETOPODir;
        this.setProjectionChangePolicy(new ListResetPCPolicy(this));
    }

    public void setPath(String pathToETOPODir) {
        this.path = pathToETOPODir;
    }

    protected void setDefaultValues() {
        this.path = null;
        this.dataBuffer = null;
        this.opaqueness = 255;
        this.slopeAdjust = 3;
        this.viewType = 1;
        this.minuteSpacing = 10;
    }

    protected int getElevIndex(short el) {
        for (int i = 0; i < 13; ++i) {
            if (el >= elevLimit[i + 1]) continue;
            return i;
        }
        return 13;
    }

    protected Color getColor(short elevation, byte slopeVal) {
        if (slopeColors == null) {
            slopeColors = new Color[14][8];
            for (int i = 0; i < 14; ++i) {
                Color base = new Color(redElev[i], greenElev[i], blueElev[i]);
                for (int j = 4; j < 8; ++j) {
                    ETOPOLayer.slopeColors[i][j] = j == 4 ? base : slopeColors[i][j - 1].brighter();
                }
                for (int k = 3; k >= 0; --k) {
                    ETOPOLayer.slopeColors[i][k] = slopeColors[i][k + 1].darker();
                }
            }
        }
        int elIdx = this.getElevIndex(elevation);
        int slopeIdx = (slopeVal + 127) / 32;
        Color norm = slopeColors[elIdx][slopeIdx];
        return new Color(norm.getRed(), norm.getGreen(), norm.getBlue(), this.opaqueness);
    }

    public void setProperties(String prefix, Properties properties) {
        super.setProperties(prefix, properties);
        prefix = PropUtils.getScopedPropertyPrefix(this);
        this.path = properties.getProperty(prefix + ETOPOPathProperty);
        this.opaqueness = PropUtils.intFromProperties(properties, prefix + OpaquenessProperty, 255);
        this.viewType = PropUtils.intFromProperties(properties, prefix + ETOPOViewTypeProperty, 1);
        this.slopeAdjust = PropUtils.intFromProperties(properties, prefix + ETOPOSlopeAdjustProperty, 3);
        this.minuteSpacing = PropUtils.intFromProperties(properties, prefix + ETOPOMinuteSpacingProperty, 10);
        this.spacer = PropUtils.intFromProperties(properties, prefix + ETOPOPixelSpacerProperty, this.spacer);
    }

    protected void buildSlopeMap() {
        if (this.dataBuffer == null) {
            return;
        }
        int resIdx = this.minuteSpacing / 5;
        if (resIdx < 0) {
            resIdx = 0;
        } else if (resIdx > 3) {
            resIdx = 3;
        }
        double deltaX = etopoSpacings[resIdx];
        this.slopeMap = new byte[this.bufferWidth * this.bufferHeight];
        for (int y = 0; y < this.bufferHeight; ++y) {
            double lat = 90.0 - 180.0 * (double)y / (double)this.bufferHeight;
            double coslat = Math.cos(Math.toRadians(lat));
            double slopeScaler = (double)this.slopeAdjust * coslat / deltaX;
            int idx0 = y * this.bufferWidth;
            for (int x = 0; x < this.bufferWidth; ++x) {
                double d1;
                double d2;
                double slope;
                int idx1 = idx0 + x;
                int idx2 = idx1 + this.bufferWidth;
                if (y == this.bufferHeight - 1) {
                    idx2 = idx1;
                }
                if ((slope = slopeScaler * ((d2 = (double)this.dataBuffer[idx2]) - (d1 = (double)this.dataBuffer[idx1]))) > 0.99) {
                    slope = 0.99;
                } else if (slope < -0.99) {
                    slope = -0.99;
                }
                int islope = (int)(slope * 127.0);
                this.slopeMap[idx1] = (byte)islope;
            }
        }
    }

    protected void loadBuffer() {
        int resIdx = this.minuteSpacing / 5;
        if (resIdx < 0) {
            resIdx = 0;
        } else if (resIdx > 3) {
            resIdx = 3;
        }
        String fileName = this.path + etopoFileNames[resIdx];
        this.dataBuffer = null;
        try {
            BinaryBufferedFile binFile = new BinaryBufferedFile(fileName);
            binFile.byteOrder(true);
            this.bufferWidth = etopoWidths[resIdx];
            this.bufferHeight = etopoHeights[resIdx];
            int spacer = 1;
            switch (this.minuteSpacing) {
                case 2: {
                    spacer = 1 + this.spacer;
                    break;
                }
                case 5: {
                    spacer = 0 + this.spacer;
                    break;
                }
                default: {
                    spacer = 1 + this.spacer;
                }
            }
            this.dataBuffer = new short[(this.bufferWidth + spacer) * this.bufferHeight];
            for (int i = 0; i < this.bufferWidth * this.bufferHeight; ++i) {
                this.dataBuffer[i] = binFile.readShort();
            }
            binFile.close();
            this.bufferWidth += spacer;
        }
        catch (FileNotFoundException e) {
            Debug.error("ETOPOLayer loadBuffer(): file " + fileName + " not found");
        }
        catch (IOException e) {
            Debug.error("ETOPOLayer loadBuffer(): File IO Error!\n" + e.toString());
        }
        catch (FormatException e) {
            Debug.error("ETOPOLayer loadBuffer(): Format exception!\n" + e.toString());
        }
    }

    protected OMRaster buildRaster() {
        OMRaster ret = null;
        Projection projection = this.getProjection();
        if (this.slopeMap != null) {
            int width = projection.getWidth();
            int height = projection.getHeight();
            int[] colors = new int[width * height];
            float scy = (float)this.bufferHeight / 180.0f;
            float scx = (float)this.bufferWidth / 360.0f;
            int sx = 0;
            int sy = 0;
            int ex = width;
            int ey = height;
            if (projection instanceof CADRG) {
                Object ul = projection.getUpperLeft();
                Object lr = projection.getLowerRight();
                Point2D ulp = projection.forward((Point2D)ul);
                Point2D lrp = projection.forward((Point2D)lr);
                sx = (int)ulp.getX();
                ex = (int)lrp.getX();
                sy = (int)ulp.getY();
                ey = (int)lrp.getY();
            }
            Object center = projection.getCenter();
            LatLonPoint.Double llp = new LatLonPoint.Double();
            for (int y = sy; y < ey; ++y) {
                for (int x = sx; x < ex; ++x) {
                    projection.inverse(x, y, llp);
                    float lat = ((LatLonPoint)llp).getLatitude();
                    float lon = ((LatLonPoint)llp).getLongitude();
                    if (this.minuteSpacing == 2) {
                        lon = (float)((double)lon + 180.0);
                    } else if ((double)lon < 0.0) {
                        lon = (float)((double)lon + 360.0);
                    }
                    int lat_idx = (int)((90.0 - (double)lat) * (double)scy);
                    int lon_idx = (int)(lon * scx);
                    int ofs = lon_idx + lat_idx * this.bufferWidth;
                    int idx = 0;
                    int gray = 0;
                    try {
                        short el = this.dataBuffer[ofs];
                        byte sl = this.slopeMap[ofs];
                        idx = y * width + x;
                        Color pix = null;
                        if (this.viewType == 0) {
                            gray = (double)((LatLonPoint)llp).getLatitude() == ((Point2D)center).getY() && (double)((LatLonPoint)llp).getLongitude() == ((Point2D)center).getX() ? 0 : 127 + sl;
                            pix = new Color(gray, gray, gray, this.opaqueness);
                        } else if (this.viewType == 1) {
                            pix = (double)((LatLonPoint)llp).getLatitude() == ((Point2D)center).getY() && (double)((LatLonPoint)llp).getLongitude() == ((Point2D)center).getX() ? new Color(0, 0, 0, this.opaqueness) : this.getColor(el, sl);
                        }
                        if (pix == null) continue;
                        colors[idx] = pix.getRGB();
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        Debug.error(e.toString() + ":" + gray);
                        continue;
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        Debug.error(e.toString() + ":" + idx);
                    }
                }
            }
            ret = new OMRaster(0, 0, width, height, colors);
        }
        return ret;
    }

    public synchronized OMGraphicList prepare() {
        if (this.isCancelled()) {
            Debug.message("etopo", this.getName() + "|ETOPOLayer.prepare(): aborted.");
            return null;
        }
        Projection projection = this.getProjection();
        if (projection == null) {
            Debug.error("ETOPO Layer needs to be added to the MapBean before it can draw images!");
            return new OMGraphicList();
        }
        if (this.dataBuffer == null || this.spacingReset) {
            this.loadBuffer();
            this.spacingReset = false;
            this.slopeReset = true;
        }
        if (this.slopeReset) {
            this.buildSlopeMap();
            this.slopeReset = false;
        }
        Debug.message("basic", this.getName() + "|ETOPOLayer.prepare(): doing it");
        if (Debug.debugging("etopo")) {
            Debug.output(this.getName() + "|ETOPOLayer.prepare(): " + "calling getRectangle " + " with projection: " + projection + " ul = " + projection.getUpperLeft() + " lr = " + projection.getLowerRight());
        }
        OMGraphicList omGraphicList = new OMGraphicList();
        omGraphicList.add(this.buildRaster());
        int size = 0;
        if (omGraphicList != null) {
            size = omGraphicList.size();
            Debug.message("basic", this.getName() + "|ETOPOLayer.prepare(): finished with " + size + " graphics");
        } else {
            Debug.message("basic", this.getName() + "|ETOPOLayer.prepare(): finished with null graphics list");
            omGraphicList = new OMGraphicList();
        }
        omGraphicList.project(projection, true);
        return omGraphicList;
    }

    public Component getGUI() {
        if (this.palette == null) {
            if (Debug.debugging("etopo")) {
                Debug.output("ETOPOLayer: creating ETOPO Palette.");
            }
            this.palette = Box.createVerticalBox();
            Box subbox0 = Box.createHorizontalBox();
            Box subbox1 = Box.createHorizontalBox();
            Box subbox2 = Box.createVerticalBox();
            Box subbox3 = Box.createHorizontalBox();
            JPanel resPanel = PaletteHelper.createPaletteJPanel("Lat/Lon Spacing");
            String[] resStrings = new String[]{"2 Minute", "5 Minute", "10 Minute", "15 Minute"};
            JComboBox<String> resList = new JComboBox<String>(resStrings);
            resList.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int curRes = ETOPOLayer.this.minuteSpacing / 5;
                    JComboBox jcb = (JComboBox)e.getSource();
                    int newRes = jcb.getSelectedIndex();
                    if (curRes != newRes) {
                        ETOPOLayer.this.spacingReset = true;
                    }
                    switch (newRes) {
                        case 0: {
                            ETOPOLayer.this.minuteSpacing = 2;
                            break;
                        }
                        case 1: {
                            ETOPOLayer.this.minuteSpacing = 5;
                            break;
                        }
                        case 2: {
                            ETOPOLayer.this.minuteSpacing = 10;
                            break;
                        }
                        case 3: {
                            ETOPOLayer.this.minuteSpacing = 15;
                        }
                    }
                }
            });
            resList.setSelectedIndex(this.minuteSpacing / 5);
            resPanel.add(resList);
            JPanel viewPanel = PaletteHelper.createPaletteJPanel("View Type");
            String[] viewStrings = new String[]{"Grayscale Shading", "Color Shading"};
            JComboBox<String> viewList = new JComboBox<String>(viewStrings);
            viewList.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JComboBox jcb = (JComboBox)e.getSource();
                    int newView = jcb.getSelectedIndex();
                    if (newView != ETOPOLayer.this.viewType) {
                        ETOPOLayer.this.slopeReset = true;
                    }
                    switch (newView) {
                        case 0: {
                            ETOPOLayer.this.viewType = 0;
                            break;
                        }
                        case 1: {
                            ETOPOLayer.this.viewType = 1;
                        }
                    }
                }
            });
            viewList.setSelectedIndex(this.viewType);
            viewPanel.add(viewList);
            JPanel contrastPanel = PaletteHelper.createPaletteJPanel("Contrast Adjustment");
            JSlider contrastSlide = new JSlider(0, 1, 5, 3);
            Hashtable<Integer, JLabel> dict = new Hashtable<Integer, JLabel>();
            dict.put(new Integer(1), new JLabel("min"));
            dict.put(new Integer(5), new JLabel("max"));
            contrastSlide.setLabelTable(dict);
            contrastSlide.setPaintLabels(true);
            contrastSlide.setMajorTickSpacing(1);
            contrastSlide.setPaintTicks(true);
            contrastSlide.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent ce) {
                    JSlider slider = (JSlider)ce.getSource();
                    if (slider.getValueIsAdjusting()) {
                        Debug.output("ETOPOLayer - Contrast Slider value = " + slider.getValue());
                        ETOPOLayer.this.slopeAdjust = slider.getValue();
                    }
                }
            });
            contrastPanel.add(contrastSlide);
            JPanel opaquenessPanel = PaletteHelper.createPaletteJPanel("Opaqueness");
            JSlider opaquenessSlide = new JSlider(0, 0, 255, this.opaqueness);
            opaquenessSlide.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent ce) {
                    JSlider slider = (JSlider)ce.getSource();
                    if (slider.getValueIsAdjusting()) {
                        ETOPOLayer.this.fireRequestInfoLine("ETOPOLayer - Opaqueness Slider value = " + slider.getValue());
                        ETOPOLayer.this.opaqueness = slider.getValue();
                    }
                }
            });
            opaquenessPanel.add(opaquenessSlide);
            JButton redraw = new JButton("Redraw ETOPO Layer");
            redraw.addActionListener(this);
            redraw.setActionCommand("redrawCmd");
            subbox0.add(resPanel);
            this.palette.add(subbox0);
            subbox1.add(viewPanel);
            this.palette.add(subbox1);
            subbox2.add(contrastPanel);
            subbox2.add(opaquenessPanel);
            this.palette.add(subbox2);
            subbox3.add(redraw);
            this.palette.add(subbox3);
        }
        return this.palette;
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getActionCommand() == "redrawCmd") {
            this.doPrepare();
        }
    }
}

