/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer;

import com.bbn.openmap.BufferedMapBean;
import com.bbn.openmap.Layer;
import com.bbn.openmap.LayerHandler;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.omGraphics.OMColor;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.PropUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.beancontext.BeanContext;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class BufferedLayer
extends OMGraphicHandlerLayer
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    public static final String LayersProperty = "layers";
    public static final String VisibleLayersProperty = "visibleLayers";
    protected boolean hasTransparentBackground = true;
    MapBean mapBean;
    JPanel panel = null;

    public BufferedLayer() {
        this.setLayout(new BorderLayout());
        BLMapBean mb = new BLMapBean();
        this.setMapBean(mb);
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        PropUtils.putDataPrefixToLayerList(this, props, prefix + LayersProperty);
        Vector<String> layersValue = PropUtils.parseSpacedMarkers(props.getProperty(prefix + LayersProperty));
        Vector<String> startuplayers = PropUtils.parseSpacedMarkers(props.getProperty(prefix + VisibleLayersProperty));
        Layer[] layers = LayerHandler.getLayers(layersValue, startuplayers, props);
        for (int i = 0; i < layers.length; ++i) {
            this.mapBean.add(layers[i]);
        }
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        StringBuffer layersListProperty = new StringBuffer();
        StringBuffer startupLayersListProperty = new StringBuffer();
        Component[] comps = this.mapBean.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            Layer layer = (Layer)comps[i];
            String lPrefix = layer.getPropertyPrefix();
            boolean unsetPrefix = false;
            if (lPrefix == null) {
                lPrefix = "layer" + i;
                layer.setPropertyPrefix(lPrefix);
                unsetPrefix = true;
            }
            layersListProperty.append(" ").append(lPrefix);
            if (layer.isVisible()) {
                startupLayersListProperty.append(" ").append(lPrefix);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("BufferedLayer: getting properties for " + layer.getName() + " " + layer.getProperties(new Properties()));
            }
            layer.getProperties(props);
            if (!unsetPrefix) continue;
            layer.setPropertyPrefix(null);
        }
        props.put(prefix + LayersProperty, layersListProperty.toString());
        props.put(prefix + VisibleLayersProperty, startupLayersListProperty.toString());
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        props = super.getPropertyInfo(props);
        return props;
    }

    public void setHasTransparentBackground(boolean value) {
        this.hasTransparentBackground = value;
    }

    public boolean getHasTransparentBackground() {
        return this.hasTransparentBackground;
    }

    public void clearLayers() {
        Component[] layers = this.getLayers();
        if (layers != null && layers.length > 0) {
            for (int i = 0; i < layers.length; ++i) {
                this.removeLayer((Layer)layers[i]);
            }
        }
        this.resetPalette();
    }

    public void setBeanContext(BeanContext in_bc) throws PropertyVetoException {
        super.setBeanContext(in_bc);
        Component[] layers = this.getLayers();
        if (layers != null && layers.length > 0) {
            for (int i = 0; i < layers.length; ++i) {
                ((Layer)layers[i]).setBeanContext(in_bc);
            }
        }
    }

    public void addLayer(Layer layer) {
        this.mapBean.add(layer);
        try {
            layer.setBeanContext(this.getBeanContext());
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.resetPalette();
    }

    public void removeLayer(Layer layer) {
        this.mapBean.remove(layer);
        this.resetPalette();
    }

    public boolean hasLayers() {
        return this.mapBean.getComponentCount() > 0;
    }

    public Component[] getLayers() {
        return this.mapBean.getComponents();
    }

    public void setMapBean(MapBean mb) {
        if (this.mapBean != null) {
            this.remove(this.mapBean);
        }
        this.mapBean = mb;
        this.add((Component)this.mapBean, "Center");
    }

    public MapBean getMapBean() {
        return this.mapBean;
    }

    public void setBackground(Color color) {
        this.setBckgrnd(color);
    }

    public void setBckgrnd(Paint paint) {
        this.mapBean.setBckgrnd(paint);
        if (paint instanceof Color) {
            this.setHasTransparentBackground(((Color)paint).getAlpha() < 255);
        } else {
            this.setHasTransparentBackground(true);
        }
    }

    public Color getBackground() {
        return this.mapBean.getBackground();
    }

    public Paint getBckgrnd(Paint paint) {
        return this.mapBean.getBckgrnd();
    }

    public void projectionChanged(ProjectionEvent pevent) {
        Projection proj = this.setProjection(pevent);
        if (proj != null) {
            this.mapBean.setProjection(this.getProjection());
        }
    }

    public void removed(Container cont) {
        Component[] layers = this.getLayers();
        if (layers != null && layers.length > 0) {
            for (int i = 0; i < layers.length; ++i) {
                ((Layer)layers[i]).remove(cont);
            }
        }
    }

    public void resetPalette() {
        this.panel = null;
        super.resetPalette();
    }

    public Component getGUI() {
        if (this.panel == null) {
            Component[] layerComps = this.getLayers();
            this.panel = new JPanel();
            GridBagLayout pGridbag = new GridBagLayout();
            GridBagConstraints pC = new GridBagConstraints();
            pC.fill = 1;
            pC.weightx = 1.0;
            pC.weighty = 1.0;
            this.panel.setLayout(pGridbag);
            JTabbedPane tabs = new JTabbedPane();
            pGridbag.setConstraints(tabs, pC);
            this.panel.add(tabs);
            JPanel bfPanel = new JPanel();
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 1;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.anchor = 10;
            c.gridwidth = 0;
            bfPanel.setLayout(gridbag);
            tabs.addTab("Layer Visibility", bfPanel);
            for (int i = 0; i < layerComps.length; ++i) {
                Layer layer = (Layer)layerComps[i];
                Component layerGUI = layer.getGUI();
                if (layerGUI != null) {
                    tabs.addTab(layer.getName(), layerGUI);
                }
                VisHelper layerVisibility = new VisHelper(layer);
                gridbag.setConstraints(layerVisibility, c);
                bfPanel.add(layerVisibility);
            }
        }
        return this.panel;
    }

    public void paint(Graphics g) {
        if (this.hasLayers()) {
            this.mapBean.paint(g);
        }
    }

    public void renderDataForProjection(Projection proj, Graphics g) {
        Component[] layersComps = this.mapBean.getComponents();
        for (int i = layersComps.length - 1; i >= 0; --i) {
            Layer layer = (Layer)layersComps[i];
            if (!layer.isVisible()) continue;
            layer.renderDataForProjection(proj, g);
        }
    }

    public void propertyChange(PropertyChangeEvent pce) {
        if (pce.getPropertyName() == "MapBean.background") {
            this.mapBean.setBckgrnd((Paint)pce.getNewValue());
        }
    }

    public void dispose() {
        if (this.mapBean != null) {
            this.mapBean.dispose();
        }
        if (this.panel != null) {
            this.panel.removeAll();
            this.panel = null;
        }
    }

    public void setBufferDirty(boolean value) {
        this.mapBean.setBufferDirty(value);
    }

    public class BLMapBean
    extends BufferedMapBean {
        private static final long serialVersionUID = 1L;

        public BLMapBean() {
            super(false);
            this.background = OMColor.clear;
        }

        public Color getBackground() {
            return OMColor.clear;
        }

        public void repaint(Layer layer) {
            super.setBufferDirty(true);
            BufferedLayer.this.repaint();
        }

        public Image createImage(int width, int height) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("BLMapBean.createImage()");
            }
            if (width <= 0) {
                width = 1;
            }
            if (height <= 0) {
                height = 1;
            }
            return new BufferedImage(width, height, 2);
        }

        public void paintBorder(Graphics g) {
        }

        public void paintChildren(Graphics g, Rectangle clip) {
            if (this.bufferDirty) {
                this.bufferDirty = false;
                int w = this.getWidth();
                int h = this.getHeight();
                if (this.drawingBuffer != null) {
                    this.drawingBuffer.flush();
                    this.drawingBuffer = null;
                }
                this.drawingBuffer = new BufferedImage(w, h, 2);
                Graphics gr = this.getMapBeanRepaintPolicy().modifyGraphicsForPainting(this.drawingBuffer.getGraphics());
                if (clip == null) {
                    gr.setClip(0, 0, w, h);
                } else {
                    gr.setClip(clip);
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("BufferedMapBean rendering layers to buffer.");
                }
                this.paintChildrenWithBorder(gr, false);
                gr.dispose();
            } else if (logger.isLoggable(Level.FINE)) {
                logger.fine("BufferedMapBean rendering buffer.");
            }
            g = g.create();
            if (clip != null) {
                g.setClip(clip);
            }
            if (this.drawingBuffer != null) {
                g.drawImage(this.drawingBuffer, 0, 0, null);
            }
            g.dispose();
        }

        public void componentRemoved(ContainerEvent e) {
            super.componentRemoved(e);
            if (this.removedLayers != null) {
                this.removedLayers.clear();
            }
        }
    }

    protected class VisHelper
    extends JCheckBox
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        Layer layer;

        public VisHelper(Layer l) {
            super(l.getName(), l.isVisible());
            super.addActionListener(this);
            this.layer = l;
        }

        public void actionPerformed(ActionEvent ae) {
            this.layer.setVisible(((JCheckBox)ae.getSource()).isSelected());
            if (OMGraphicHandlerLayer.logger.isLoggable(Level.FINE)) {
                OMGraphicHandlerLayer.logger.fine("Turning " + this.layer.getName() + (((JCheckBox)ae.getSource()).isSelected() ? " on" : " off"));
            }
            this.layer.repaint();
        }
    }
}

