/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.config.implementation;

import com.azure.spring.cloud.config.health.AppConfigurationStoreHealth;
import com.azure.spring.cloud.config.implementation.AppConfigurationReplicaClient;
import com.azure.spring.cloud.config.implementation.AppConfigurationReplicaClientsBuilder;
import com.azure.spring.cloud.config.implementation.BackoffTimeCalculator;
import com.azure.spring.cloud.config.properties.AppConfigurationStoreMonitoring;
import com.azure.spring.cloud.config.properties.ConfigStore;
import com.azure.spring.cloud.config.properties.FeatureFlagStore;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionManager.class);
    private final String originEndpoint;
    private List<AppConfigurationReplicaClient> clients;
    private String currentReplica;
    private AppConfigurationStoreHealth health;
    private final AppConfigurationReplicaClientsBuilder clientBuilder;
    private final ConfigStore configStore;

    ConnectionManager(AppConfigurationReplicaClientsBuilder clientBuilder, ConfigStore configStore) {
        this.clientBuilder = clientBuilder;
        this.configStore = configStore;
        this.originEndpoint = configStore.getEndpoint();
        this.health = AppConfigurationStoreHealth.NOT_LOADED;
        this.currentReplica = configStore.getEndpoint();
    }

    AppConfigurationStoreHealth getHealth() {
        return this.health;
    }

    void setCurrentClient(String replicaEndpoint) {
        this.currentReplica = replicaEndpoint;
    }

    String getOriginEndpoint() {
        return this.originEndpoint;
    }

    List<AppConfigurationReplicaClient> getAvailableClients() {
        return this.getAvailableClients(false);
    }

    List<AppConfigurationReplicaClient> getAvailableClients(Boolean useCurrent) {
        boolean foundCurrent;
        if (this.clients == null) {
            this.clients = this.clientBuilder.buildClients(this.configStore);
            if (this.clients.size() == 0) {
                this.health = AppConfigurationStoreHealth.NOT_LOADED;
            }
        }
        ArrayList<AppConfigurationReplicaClient> availableClients = new ArrayList<AppConfigurationReplicaClient>();
        boolean bl = foundCurrent = useCurrent == false;
        if (this.clients.size() == 1) {
            availableClients.add(this.clients.get(0));
        } else if (this.clients.size() > 0) {
            for (AppConfigurationReplicaClient replicaClient : this.clients) {
                if (replicaClient.getEndpoint().equals(this.currentReplica)) {
                    foundCurrent = true;
                }
                if (!foundCurrent || !replicaClient.getBackoffEndTime().isBefore(Instant.now())) continue;
                LOGGER.debug("Using Client: " + replicaClient.getEndpoint());
                availableClients.add(replicaClient);
            }
            this.health = availableClients.size() == 0 ? AppConfigurationStoreHealth.DOWN : AppConfigurationStoreHealth.UP;
        }
        return availableClients;
    }

    List<String> getAllEndpoints() {
        return this.clients.stream().map(client -> client.getEndpoint()).collect(Collectors.toList());
    }

    void backoffClient(String endpoint) {
        for (AppConfigurationReplicaClient client : this.clients) {
            if (!client.getEndpoint().equals(endpoint)) continue;
            int failedAttempt = client.getFailedAttempts();
            long backoffTime = BackoffTimeCalculator.calculateBackoff(failedAttempt);
            client.updateBackoffEndTime(Instant.now().plusNanos(backoffTime));
            break;
        }
    }

    void updateSyncToken(String endpoint, String syncToken) {
        this.clients.stream().filter(client -> client.getEndpoint().equals(endpoint)).findFirst().ifPresent(client -> client.updateSyncToken(syncToken));
    }

    AppConfigurationStoreMonitoring getMonitoring() {
        return this.configStore.getMonitoring();
    }

    FeatureFlagStore getFeatureFlagStore() {
        return this.configStore.getFeatureFlags();
    }
}

