/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.config;

import com.azure.core.http.rest.PagedIterable;
import com.azure.data.appconfiguration.models.ConfigurationSetting;
import com.azure.data.appconfiguration.models.SettingSelector;
import com.azure.spring.cloud.config.AppConfigurationPropertySource;
import com.azure.spring.cloud.config.KeyVaultCredentialProvider;
import com.azure.spring.cloud.config.KeyVaultSecretProvider;
import com.azure.spring.cloud.config.NormalizeNull;
import com.azure.spring.cloud.config.SecretClientBuilderSetup;
import com.azure.spring.cloud.config.StateHolder;
import com.azure.spring.cloud.config.feature.management.entity.FeatureSet;
import com.azure.spring.cloud.config.properties.AppConfigurationProperties;
import com.azure.spring.cloud.config.properties.AppConfigurationProviderProperties;
import com.azure.spring.cloud.config.properties.AppConfigurationStoreSelects;
import com.azure.spring.cloud.config.properties.AppConfigurationStoreTrigger;
import com.azure.spring.cloud.config.properties.ConfigStore;
import com.azure.spring.cloud.config.stores.ClientStore;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.util.ReflectionUtils;

public final class AppConfigurationPropertySourceLocator
implements PropertySourceLocator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppConfigurationPropertySourceLocator.class);
    private static final String PROPERTY_SOURCE_NAME = "azure-config-store";
    private static final String REFRESH_ARGS_PROPERTY_SOURCE = "refreshArgs";
    private final AppConfigurationProperties properties;
    private final List<ConfigStore> configStores;
    private final AppConfigurationProviderProperties appProperties;
    private final ClientStore clients;
    private final KeyVaultCredentialProvider keyVaultCredentialProvider;
    private final SecretClientBuilderSetup keyVaultClientProvider;
    private final KeyVaultSecretProvider keyVaultSecretProvider;
    private static final AtomicBoolean configloaded = new AtomicBoolean(false);
    private static final AtomicBoolean startup = new AtomicBoolean(true);

    public AppConfigurationPropertySourceLocator(AppConfigurationProperties properties, AppConfigurationProviderProperties appProperties, ClientStore clients, KeyVaultCredentialProvider keyVaultCredentialProvider, SecretClientBuilderSetup keyVaultClientProvider, KeyVaultSecretProvider keyVaultSecretProvider) {
        this.properties = properties;
        this.appProperties = appProperties;
        this.configStores = properties.getStores();
        this.clients = clients;
        this.keyVaultCredentialProvider = keyVaultCredentialProvider;
        this.keyVaultClientProvider = keyVaultClientProvider;
        this.keyVaultSecretProvider = keyVaultSecretProvider;
    }

    public PropertySource<?> locate(Environment environment) {
        if (!(environment instanceof ConfigurableEnvironment)) {
            return null;
        }
        ConfigurableEnvironment env = (ConfigurableEnvironment)environment;
        if (configloaded.get() && !env.getPropertySources().contains(REFRESH_ARGS_PROPERTY_SOURCE)) {
            return null;
        }
        List<String> profiles = Arrays.asList(env.getActiveProfiles());
        CompositePropertySource composite = new CompositePropertySource(PROPERTY_SOURCE_NAME);
        Collections.reverse(this.configStores);
        Iterator<ConfigStore> configStoreIterator = this.configStores.iterator();
        while (configStoreIterator.hasNext()) {
            boolean loadNewPropertySources;
            ConfigStore configStore = configStoreIterator.next();
            boolean bl = loadNewPropertySources = startup.get() || StateHolder.getLoadState(configStore.getEndpoint());
            if (configStore.isEnabled() && loadNewPropertySources) {
                this.addPropertySource(composite, configStore, profiles, !configStoreIterator.hasNext());
                continue;
            }
            if (!configStore.isEnabled() && loadNewPropertySources) {
                LOGGER.info("Not loading configurations from {} as it is not enabled.", (Object)configStore.getEndpoint());
                continue;
            }
            LOGGER.warn("Not loading configurations from {} as it failed on startup.", (Object)configStore.getEndpoint());
        }
        if (this.properties.getRefreshInterval() != null) {
            StateHolder.setNextForcedRefresh(this.properties.getRefreshInterval());
        }
        configloaded.set(true);
        startup.set(false);
        StateHolder.clearAttempts();
        return composite;
    }

    private void addPropertySource(CompositePropertySource composite, ConfigStore store, List<String> profiles, boolean initFeatures) {
        FeatureSet featureSet = new FeatureSet();
        ArrayList<AppConfigurationPropertySource> sourceList = new ArrayList<AppConfigurationPropertySource>();
        try {
            sourceList.addAll(this.create(store, profiles, initFeatures, featureSet));
            LOGGER.debug("PropertySource context.");
        }
        catch (Exception e) {
            if (!startup.get()) {
                LOGGER.error("Refreshing failed while reading configuration from Azure App Configuration store " + store.getEndpoint() + ".");
                if (this.properties.getRefreshInterval() != null) {
                    StateHolder.updateNextRefreshTime(this.properties.getRefreshInterval(), this.appProperties);
                }
                ReflectionUtils.rethrowRuntimeException((Throwable)e);
            } else if (store.isFailFast()) {
                LOGGER.error("Fail fast is set and there was an error reading configuration from Azure App Configuration store " + store.getEndpoint() + ".");
                ReflectionUtils.rethrowRuntimeException((Throwable)e);
            } else {
                LOGGER.warn("Unable to load configuration from Azure AppConfiguration store " + store.getEndpoint() + ".", (Throwable)e);
                StateHolder.setLoadState(store.getEndpoint(), false);
            }
            return;
        }
        sourceList.forEach(arg_0 -> ((CompositePropertySource)composite).addPropertySource(arg_0));
    }

    private List<AppConfigurationPropertySource> create(ConfigStore store, List<String> profiles, boolean initFeatures, FeatureSet featureSet) throws Exception {
        ArrayList<AppConfigurationPropertySource> sourceList = new ArrayList<AppConfigurationPropertySource>();
        try {
            List<AppConfigurationStoreSelects> selects = store.getSelects();
            for (AppConfigurationStoreSelects selectedKeys : selects) {
                AppConfigurationPropertySource propertySource = new AppConfigurationPropertySource(store, selectedKeys, profiles, this.properties, this.clients, this.appProperties, this.keyVaultCredentialProvider, this.keyVaultClientProvider, this.keyVaultSecretProvider);
                propertySource.initProperties(featureSet);
                if (initFeatures) {
                    propertySource.initFeatures(featureSet);
                }
                sourceList.add(propertySource);
            }
            ArrayList<ConfigurationSetting> watchKeysSettings = new ArrayList<ConfigurationSetting>();
            ArrayList<ConfigurationSetting> watchKeysFeatures = new ArrayList<ConfigurationSetting>();
            for (AppConfigurationStoreTrigger trigger : store.getMonitoring().getTriggers()) {
                ConfigurationSetting watchKey2 = this.clients.getWatchKey(trigger.getKey(), trigger.getLabel(), store.getEndpoint());
                if (watchKey2 != null) {
                    watchKeysSettings.add(watchKey2);
                    continue;
                }
                watchKeysSettings.add(new ConfigurationSetting().setKey(trigger.getKey()).setLabel(trigger.getLabel()));
            }
            if (store.getFeatureFlags().getEnabled().booleanValue()) {
                SettingSelector settingSelector = new SettingSelector().setKeyFilter(store.getFeatureFlags().getKeyFilter()).setLabelFilter(store.getFeatureFlags().getLabelFilter());
                PagedIterable<ConfigurationSetting> watchKeys = this.clients.getFeatureFlagWatchKey(settingSelector, store.getEndpoint());
                watchKeys.forEach(watchKey -> watchKeysFeatures.add(NormalizeNull.normalizeNullLabel(watchKey)));
                StateHolder.setStateFeatureFlag(store.getEndpoint(), watchKeysFeatures, store.getMonitoring().getFeatureFlagRefreshInterval());
                StateHolder.setLoadStateFeatureFlag(store.getEndpoint(), true);
            }
            StateHolder.setState(store.getEndpoint(), watchKeysSettings, store.getMonitoring().getRefreshInterval());
            StateHolder.setLoadState(store.getEndpoint(), true);
        }
        catch (Exception e) {
            this.delayException();
            throw e;
        }
        return sourceList;
    }

    private void delayException() {
        Instant preKillTIme;
        Instant currentDate = Instant.now();
        if (currentDate.isBefore(preKillTIme = this.appProperties.getStartDate().plusSeconds(this.appProperties.getPrekillTime()))) {
            long diffInMillies = Math.abs(preKillTIme.toEpochMilli() - currentDate.toEpochMilli());
            try {
                Thread.sleep(diffInMillies);
            }
            catch (InterruptedException e) {
                LOGGER.error("Failed to wait before fast fail.");
            }
        }
    }
}

