/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.applicationinsights.models.WorkbookTemplateGallery;
import com.azure.resourcemanager.applicationinsights.models.WorkbookTemplateLocalizedGallery;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class WorkbookTemplateProperties {
    @JsonProperty(value="priority")
    private Integer priority;
    @JsonProperty(value="author")
    private String author;
    @JsonProperty(value="templateData", required=true)
    private Object templateData;
    @JsonProperty(value="galleries", required=true)
    private List<WorkbookTemplateGallery> galleries;
    @JsonProperty(value="localized")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, List<WorkbookTemplateLocalizedGallery>> localized;
    private static final ClientLogger LOGGER = new ClientLogger(WorkbookTemplateProperties.class);

    public Integer priority() {
        return this.priority;
    }

    public WorkbookTemplateProperties withPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    public String author() {
        return this.author;
    }

    public WorkbookTemplateProperties withAuthor(String author) {
        this.author = author;
        return this;
    }

    public Object templateData() {
        return this.templateData;
    }

    public WorkbookTemplateProperties withTemplateData(Object templateData) {
        this.templateData = templateData;
        return this;
    }

    public List<WorkbookTemplateGallery> galleries() {
        return this.galleries;
    }

    public WorkbookTemplateProperties withGalleries(List<WorkbookTemplateGallery> galleries) {
        this.galleries = galleries;
        return this;
    }

    public Map<String, List<WorkbookTemplateLocalizedGallery>> localized() {
        return this.localized;
    }

    public WorkbookTemplateProperties withLocalized(Map<String, List<WorkbookTemplateLocalizedGallery>> localized) {
        this.localized = localized;
        return this;
    }

    public void validate() {
        if (this.templateData() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property templateData in model WorkbookTemplateProperties"));
        }
        if (this.galleries() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property galleries in model WorkbookTemplateProperties"));
        }
        this.galleries().forEach(e -> e.validate());
        if (this.localized() != null) {
            this.localized().values().forEach(e -> {
                if (e != null) {
                    e.forEach(e1 -> e1.validate());
                }
            });
        }
    }
}

