/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.secrets.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.security.keyvault.secrets.implementation.models.BackupSecretResult;
import com.azure.security.keyvault.secrets.implementation.models.DeletedSecretBundle;
import com.azure.security.keyvault.secrets.implementation.models.DeletedSecretItem;
import com.azure.security.keyvault.secrets.implementation.models.DeletedSecretListResult;
import com.azure.security.keyvault.secrets.implementation.models.KeyVaultErrorException;
import com.azure.security.keyvault.secrets.implementation.models.SecretAttributes;
import com.azure.security.keyvault.secrets.implementation.models.SecretBundle;
import com.azure.security.keyvault.secrets.implementation.models.SecretItem;
import com.azure.security.keyvault.secrets.implementation.models.SecretListResult;
import com.azure.security.keyvault.secrets.implementation.models.SecretRestoreParameters;
import com.azure.security.keyvault.secrets.implementation.models.SecretSetParameters;
import com.azure.security.keyvault.secrets.implementation.models.SecretUpdateParameters;
import java.util.Map;
import reactor.core.publisher.Mono;

public final class SecretClientImpl {
    private final SecretClientService service;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;

    public String getApiVersion() {
        return this.apiVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public SecretClientImpl(String apiVersion) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), apiVersion);
    }

    public SecretClientImpl(HttpPipeline httpPipeline, String apiVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), apiVersion);
    }

    public SecretClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String apiVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.apiVersion = apiVersion;
        this.service = (SecretClientService)RestProxy.create(SecretClientService.class, (HttpPipeline)this.httpPipeline, (SerializerAdapter)this.getSerializerAdapter());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SecretBundle>> setSecretWithResponseAsync(String vaultBaseUrl, String secretName, String value, Map<String, String> tags, String contentType, SecretAttributes secretAttributes) {
        String accept = "application/json";
        SecretSetParameters parameters = new SecretSetParameters();
        parameters.setValue(value);
        parameters.setTags(tags);
        parameters.setContentType(contentType);
        parameters.setSecretAttributes(secretAttributes);
        return FluxUtil.withContext(context -> this.service.setSecret(vaultBaseUrl, secretName, this.getApiVersion(), parameters, "application/json", contentType, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SecretBundle>> setSecretWithResponseAsync(String vaultBaseUrl, String secretName, String value, Map<String, String> tags, String contentType, SecretAttributes secretAttributes, Context context) {
        String accept = "application/json";
        SecretSetParameters parameters = new SecretSetParameters();
        parameters.setValue(value);
        parameters.setTags(tags);
        parameters.setContentType(contentType);
        parameters.setSecretAttributes(secretAttributes);
        return this.service.setSecret(vaultBaseUrl, secretName, this.getApiVersion(), parameters, "application/json", contentType, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SecretBundle> setSecretAsync(String vaultBaseUrl, String secretName, String value, Map<String, String> tags, String contentType, SecretAttributes secretAttributes) {
        return this.setSecretWithResponseAsync(vaultBaseUrl, secretName, value, tags, contentType, secretAttributes).flatMap(res -> Mono.justOrEmpty((Object)((SecretBundle)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SecretBundle> setSecretAsync(String vaultBaseUrl, String secretName, String value, Map<String, String> tags, String contentType, SecretAttributes secretAttributes, Context context) {
        return this.setSecretWithResponseAsync(vaultBaseUrl, secretName, value, tags, contentType, secretAttributes, context).flatMap(res -> Mono.justOrEmpty((Object)((SecretBundle)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SecretBundle> setSecretWithResponse(String vaultBaseUrl, String secretName, String value, Map<String, String> tags, String contentType, SecretAttributes secretAttributes, Context context) {
        String accept = "application/json";
        SecretSetParameters parameters = new SecretSetParameters();
        parameters.setValue(value);
        parameters.setTags(tags);
        parameters.setContentType(contentType);
        parameters.setSecretAttributes(secretAttributes);
        return this.service.setSecretSync(vaultBaseUrl, secretName, this.getApiVersion(), parameters, "application/json", contentType, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SecretBundle setSecret(String vaultBaseUrl, String secretName, String value, Map<String, String> tags, String contentType, SecretAttributes secretAttributes) {
        return (SecretBundle)this.setSecretWithResponse(vaultBaseUrl, secretName, value, tags, contentType, secretAttributes, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DeletedSecretBundle>> deleteSecretWithResponseAsync(String vaultBaseUrl, String secretName) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteSecret(vaultBaseUrl, secretName, this.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DeletedSecretBundle>> deleteSecretWithResponseAsync(String vaultBaseUrl, String secretName, Context context) {
        String accept = "application/json";
        return this.service.deleteSecret(vaultBaseUrl, secretName, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DeletedSecretBundle> deleteSecretAsync(String vaultBaseUrl, String secretName) {
        return this.deleteSecretWithResponseAsync(vaultBaseUrl, secretName).flatMap(res -> Mono.justOrEmpty((Object)((DeletedSecretBundle)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DeletedSecretBundle> deleteSecretAsync(String vaultBaseUrl, String secretName, Context context) {
        return this.deleteSecretWithResponseAsync(vaultBaseUrl, secretName, context).flatMap(res -> Mono.justOrEmpty((Object)((DeletedSecretBundle)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DeletedSecretBundle> deleteSecretWithResponse(String vaultBaseUrl, String secretName, Context context) {
        String accept = "application/json";
        return this.service.deleteSecretSync(vaultBaseUrl, secretName, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeletedSecretBundle deleteSecret(String vaultBaseUrl, String secretName) {
        return (DeletedSecretBundle)this.deleteSecretWithResponse(vaultBaseUrl, secretName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SecretBundle>> updateSecretWithResponseAsync(String vaultBaseUrl, String secretName, String secretVersion, String contentType, SecretAttributes secretAttributes, Map<String, String> tags) {
        String accept = "application/json";
        SecretUpdateParameters parameters = new SecretUpdateParameters();
        parameters.setContentType(contentType);
        parameters.setSecretAttributes(secretAttributes);
        parameters.setTags(tags);
        return FluxUtil.withContext(context -> this.service.updateSecret(vaultBaseUrl, secretName, secretVersion, this.getApiVersion(), parameters, "application/json", contentType, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SecretBundle>> updateSecretWithResponseAsync(String vaultBaseUrl, String secretName, String secretVersion, String contentType, SecretAttributes secretAttributes, Map<String, String> tags, Context context) {
        String accept = "application/json";
        SecretUpdateParameters parameters = new SecretUpdateParameters();
        parameters.setContentType(contentType);
        parameters.setSecretAttributes(secretAttributes);
        parameters.setTags(tags);
        return this.service.updateSecret(vaultBaseUrl, secretName, secretVersion, this.getApiVersion(), parameters, "application/json", contentType, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SecretBundle> updateSecretAsync(String vaultBaseUrl, String secretName, String secretVersion, String contentType, SecretAttributes secretAttributes, Map<String, String> tags) {
        return this.updateSecretWithResponseAsync(vaultBaseUrl, secretName, secretVersion, contentType, secretAttributes, tags).flatMap(res -> Mono.justOrEmpty((Object)((SecretBundle)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SecretBundle> updateSecretAsync(String vaultBaseUrl, String secretName, String secretVersion, String contentType, SecretAttributes secretAttributes, Map<String, String> tags, Context context) {
        return this.updateSecretWithResponseAsync(vaultBaseUrl, secretName, secretVersion, contentType, secretAttributes, tags, context).flatMap(res -> Mono.justOrEmpty((Object)((SecretBundle)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SecretBundle> updateSecretWithResponse(String vaultBaseUrl, String secretName, String secretVersion, String contentType, SecretAttributes secretAttributes, Map<String, String> tags, Context context) {
        String accept = "application/json";
        SecretUpdateParameters parameters = new SecretUpdateParameters();
        parameters.setContentType(contentType);
        parameters.setSecretAttributes(secretAttributes);
        parameters.setTags(tags);
        return this.service.updateSecretSync(vaultBaseUrl, secretName, secretVersion, this.getApiVersion(), parameters, "application/json", contentType, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SecretBundle updateSecret(String vaultBaseUrl, String secretName, String secretVersion, String contentType, SecretAttributes secretAttributes, Map<String, String> tags) {
        return (SecretBundle)this.updateSecretWithResponse(vaultBaseUrl, secretName, secretVersion, contentType, secretAttributes, tags, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SecretBundle>> getSecretWithResponseAsync(String vaultBaseUrl, String secretName, String secretVersion) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getSecret(vaultBaseUrl, secretName, secretVersion, this.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SecretBundle>> getSecretWithResponseAsync(String vaultBaseUrl, String secretName, String secretVersion, Context context) {
        String accept = "application/json";
        return this.service.getSecret(vaultBaseUrl, secretName, secretVersion, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SecretBundle> getSecretAsync(String vaultBaseUrl, String secretName, String secretVersion) {
        return this.getSecretWithResponseAsync(vaultBaseUrl, secretName, secretVersion).flatMap(res -> Mono.justOrEmpty((Object)((SecretBundle)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SecretBundle> getSecretAsync(String vaultBaseUrl, String secretName, String secretVersion, Context context) {
        return this.getSecretWithResponseAsync(vaultBaseUrl, secretName, secretVersion, context).flatMap(res -> Mono.justOrEmpty((Object)((SecretBundle)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SecretBundle> getSecretWithResponse(String vaultBaseUrl, String secretName, String secretVersion, Context context) {
        String accept = "application/json";
        return this.service.getSecretSync(vaultBaseUrl, secretName, secretVersion, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SecretBundle getSecret(String vaultBaseUrl, String secretName, String secretVersion) {
        return (SecretBundle)this.getSecretWithResponse(vaultBaseUrl, secretName, secretVersion, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<SecretItem>> getSecretsSinglePageAsync(String vaultBaseUrl, Integer maxresults) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getSecrets(vaultBaseUrl, maxresults, this.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SecretListResult)res.getValue()).getValue(), ((SecretListResult)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<SecretItem>> getSecretsSinglePageAsync(String vaultBaseUrl, Integer maxresults, Context context) {
        String accept = "application/json";
        return this.service.getSecrets(vaultBaseUrl, maxresults, this.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SecretListResult)res.getValue()).getValue(), ((SecretListResult)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SecretItem> getSecretsAsync(String vaultBaseUrl, Integer maxresults) {
        return new PagedFlux(() -> this.getSecretsSinglePageAsync(vaultBaseUrl, maxresults), nextLink -> this.getSecretsNextSinglePageAsync((String)nextLink, vaultBaseUrl));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SecretItem> getSecretsAsync(String vaultBaseUrl, Integer maxresults, Context context) {
        return new PagedFlux(() -> this.getSecretsSinglePageAsync(vaultBaseUrl, maxresults, context), nextLink -> this.getSecretsNextSinglePageAsync((String)nextLink, vaultBaseUrl, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<SecretItem> getSecretsSinglePage(String vaultBaseUrl, Integer maxresults) {
        String accept = "application/json";
        Response<SecretListResult> res = this.service.getSecretsSync(vaultBaseUrl, maxresults, this.getApiVersion(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SecretListResult)res.getValue()).getValue(), ((SecretListResult)res.getValue()).getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<SecretItem> getSecretsSinglePage(String vaultBaseUrl, Integer maxresults, Context context) {
        String accept = "application/json";
        Response<SecretListResult> res = this.service.getSecretsSync(vaultBaseUrl, maxresults, this.getApiVersion(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SecretListResult)res.getValue()).getValue(), ((SecretListResult)res.getValue()).getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SecretItem> getSecrets(String vaultBaseUrl, Integer maxresults) {
        return new PagedIterable(() -> this.getSecretsSinglePage(vaultBaseUrl, maxresults, Context.NONE), nextLink -> this.getSecretsNextSinglePage((String)nextLink, vaultBaseUrl));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SecretItem> getSecrets(String vaultBaseUrl, Integer maxresults, Context context) {
        return new PagedIterable(() -> this.getSecretsSinglePage(vaultBaseUrl, maxresults, context), nextLink -> this.getSecretsNextSinglePage((String)nextLink, vaultBaseUrl, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<SecretItem>> getSecretVersionsSinglePageAsync(String vaultBaseUrl, String secretName, Integer maxresults) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getSecretVersions(vaultBaseUrl, secretName, maxresults, this.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SecretListResult)res.getValue()).getValue(), ((SecretListResult)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<SecretItem>> getSecretVersionsSinglePageAsync(String vaultBaseUrl, String secretName, Integer maxresults, Context context) {
        String accept = "application/json";
        return this.service.getSecretVersions(vaultBaseUrl, secretName, maxresults, this.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SecretListResult)res.getValue()).getValue(), ((SecretListResult)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SecretItem> getSecretVersionsAsync(String vaultBaseUrl, String secretName, Integer maxresults) {
        return new PagedFlux(() -> this.getSecretVersionsSinglePageAsync(vaultBaseUrl, secretName, maxresults), nextLink -> this.getSecretVersionsNextSinglePageAsync((String)nextLink, vaultBaseUrl));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SecretItem> getSecretVersionsAsync(String vaultBaseUrl, String secretName, Integer maxresults, Context context) {
        return new PagedFlux(() -> this.getSecretVersionsSinglePageAsync(vaultBaseUrl, secretName, maxresults, context), nextLink -> this.getSecretVersionsNextSinglePageAsync((String)nextLink, vaultBaseUrl, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<SecretItem> getSecretVersionsSinglePage(String vaultBaseUrl, String secretName, Integer maxresults) {
        String accept = "application/json";
        Response<SecretListResult> res = this.service.getSecretVersionsSync(vaultBaseUrl, secretName, maxresults, this.getApiVersion(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SecretListResult)res.getValue()).getValue(), ((SecretListResult)res.getValue()).getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<SecretItem> getSecretVersionsSinglePage(String vaultBaseUrl, String secretName, Integer maxresults, Context context) {
        String accept = "application/json";
        Response<SecretListResult> res = this.service.getSecretVersionsSync(vaultBaseUrl, secretName, maxresults, this.getApiVersion(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SecretListResult)res.getValue()).getValue(), ((SecretListResult)res.getValue()).getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SecretItem> getSecretVersions(String vaultBaseUrl, String secretName, Integer maxresults) {
        return new PagedIterable(() -> this.getSecretVersionsSinglePage(vaultBaseUrl, secretName, maxresults, Context.NONE), nextLink -> this.getSecretVersionsNextSinglePage((String)nextLink, vaultBaseUrl));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SecretItem> getSecretVersions(String vaultBaseUrl, String secretName, Integer maxresults, Context context) {
        return new PagedIterable(() -> this.getSecretVersionsSinglePage(vaultBaseUrl, secretName, maxresults, context), nextLink -> this.getSecretVersionsNextSinglePage((String)nextLink, vaultBaseUrl, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<DeletedSecretItem>> getDeletedSecretsSinglePageAsync(String vaultBaseUrl, Integer maxresults) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getDeletedSecrets(vaultBaseUrl, maxresults, this.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeletedSecretListResult)res.getValue()).getValue(), ((DeletedSecretListResult)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<DeletedSecretItem>> getDeletedSecretsSinglePageAsync(String vaultBaseUrl, Integer maxresults, Context context) {
        String accept = "application/json";
        return this.service.getDeletedSecrets(vaultBaseUrl, maxresults, this.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeletedSecretListResult)res.getValue()).getValue(), ((DeletedSecretListResult)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DeletedSecretItem> getDeletedSecretsAsync(String vaultBaseUrl, Integer maxresults) {
        return new PagedFlux(() -> this.getDeletedSecretsSinglePageAsync(vaultBaseUrl, maxresults), nextLink -> this.getDeletedSecretsNextSinglePageAsync((String)nextLink, vaultBaseUrl));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DeletedSecretItem> getDeletedSecretsAsync(String vaultBaseUrl, Integer maxresults, Context context) {
        return new PagedFlux(() -> this.getDeletedSecretsSinglePageAsync(vaultBaseUrl, maxresults, context), nextLink -> this.getDeletedSecretsNextSinglePageAsync((String)nextLink, vaultBaseUrl, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<DeletedSecretItem> getDeletedSecretsSinglePage(String vaultBaseUrl, Integer maxresults) {
        String accept = "application/json";
        Response<DeletedSecretListResult> res = this.service.getDeletedSecretsSync(vaultBaseUrl, maxresults, this.getApiVersion(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeletedSecretListResult)res.getValue()).getValue(), ((DeletedSecretListResult)res.getValue()).getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<DeletedSecretItem> getDeletedSecretsSinglePage(String vaultBaseUrl, Integer maxresults, Context context) {
        String accept = "application/json";
        Response<DeletedSecretListResult> res = this.service.getDeletedSecretsSync(vaultBaseUrl, maxresults, this.getApiVersion(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeletedSecretListResult)res.getValue()).getValue(), ((DeletedSecretListResult)res.getValue()).getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeletedSecretItem> getDeletedSecrets(String vaultBaseUrl, Integer maxresults) {
        return new PagedIterable(() -> this.getDeletedSecretsSinglePage(vaultBaseUrl, maxresults, Context.NONE), nextLink -> this.getDeletedSecretsNextSinglePage((String)nextLink, vaultBaseUrl));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeletedSecretItem> getDeletedSecrets(String vaultBaseUrl, Integer maxresults, Context context) {
        return new PagedIterable(() -> this.getDeletedSecretsSinglePage(vaultBaseUrl, maxresults, context), nextLink -> this.getDeletedSecretsNextSinglePage((String)nextLink, vaultBaseUrl, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DeletedSecretBundle>> getDeletedSecretWithResponseAsync(String vaultBaseUrl, String secretName) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getDeletedSecret(vaultBaseUrl, secretName, this.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DeletedSecretBundle>> getDeletedSecretWithResponseAsync(String vaultBaseUrl, String secretName, Context context) {
        String accept = "application/json";
        return this.service.getDeletedSecret(vaultBaseUrl, secretName, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DeletedSecretBundle> getDeletedSecretAsync(String vaultBaseUrl, String secretName) {
        return this.getDeletedSecretWithResponseAsync(vaultBaseUrl, secretName).flatMap(res -> Mono.justOrEmpty((Object)((DeletedSecretBundle)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DeletedSecretBundle> getDeletedSecretAsync(String vaultBaseUrl, String secretName, Context context) {
        return this.getDeletedSecretWithResponseAsync(vaultBaseUrl, secretName, context).flatMap(res -> Mono.justOrEmpty((Object)((DeletedSecretBundle)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DeletedSecretBundle> getDeletedSecretWithResponse(String vaultBaseUrl, String secretName, Context context) {
        String accept = "application/json";
        return this.service.getDeletedSecretSync(vaultBaseUrl, secretName, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeletedSecretBundle getDeletedSecret(String vaultBaseUrl, String secretName) {
        return (DeletedSecretBundle)this.getDeletedSecretWithResponse(vaultBaseUrl, secretName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> purgeDeletedSecretWithResponseAsync(String vaultBaseUrl, String secretName) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.purgeDeletedSecret(vaultBaseUrl, secretName, this.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> purgeDeletedSecretWithResponseAsync(String vaultBaseUrl, String secretName, Context context) {
        String accept = "application/json";
        return this.service.purgeDeletedSecret(vaultBaseUrl, secretName, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> purgeDeletedSecretAsync(String vaultBaseUrl, String secretName) {
        return this.purgeDeletedSecretWithResponseAsync(vaultBaseUrl, secretName).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> purgeDeletedSecretAsync(String vaultBaseUrl, String secretName, Context context) {
        return this.purgeDeletedSecretWithResponseAsync(vaultBaseUrl, secretName, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> purgeDeletedSecretWithResponse(String vaultBaseUrl, String secretName, Context context) {
        String accept = "application/json";
        return this.service.purgeDeletedSecretSync(vaultBaseUrl, secretName, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void purgeDeletedSecret(String vaultBaseUrl, String secretName) {
        this.purgeDeletedSecretWithResponse(vaultBaseUrl, secretName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SecretBundle>> recoverDeletedSecretWithResponseAsync(String vaultBaseUrl, String secretName) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.recoverDeletedSecret(vaultBaseUrl, secretName, this.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SecretBundle>> recoverDeletedSecretWithResponseAsync(String vaultBaseUrl, String secretName, Context context) {
        String accept = "application/json";
        return this.service.recoverDeletedSecret(vaultBaseUrl, secretName, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SecretBundle> recoverDeletedSecretAsync(String vaultBaseUrl, String secretName) {
        return this.recoverDeletedSecretWithResponseAsync(vaultBaseUrl, secretName).flatMap(res -> Mono.justOrEmpty((Object)((SecretBundle)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SecretBundle> recoverDeletedSecretAsync(String vaultBaseUrl, String secretName, Context context) {
        return this.recoverDeletedSecretWithResponseAsync(vaultBaseUrl, secretName, context).flatMap(res -> Mono.justOrEmpty((Object)((SecretBundle)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SecretBundle> recoverDeletedSecretWithResponse(String vaultBaseUrl, String secretName, Context context) {
        String accept = "application/json";
        return this.service.recoverDeletedSecretSync(vaultBaseUrl, secretName, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SecretBundle recoverDeletedSecret(String vaultBaseUrl, String secretName) {
        return (SecretBundle)this.recoverDeletedSecretWithResponse(vaultBaseUrl, secretName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BackupSecretResult>> backupSecretWithResponseAsync(String vaultBaseUrl, String secretName) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.backupSecret(vaultBaseUrl, secretName, this.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BackupSecretResult>> backupSecretWithResponseAsync(String vaultBaseUrl, String secretName, Context context) {
        String accept = "application/json";
        return this.service.backupSecret(vaultBaseUrl, secretName, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BackupSecretResult> backupSecretAsync(String vaultBaseUrl, String secretName) {
        return this.backupSecretWithResponseAsync(vaultBaseUrl, secretName).flatMap(res -> Mono.justOrEmpty((Object)((BackupSecretResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BackupSecretResult> backupSecretAsync(String vaultBaseUrl, String secretName, Context context) {
        return this.backupSecretWithResponseAsync(vaultBaseUrl, secretName, context).flatMap(res -> Mono.justOrEmpty((Object)((BackupSecretResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BackupSecretResult> backupSecretWithResponse(String vaultBaseUrl, String secretName, Context context) {
        String accept = "application/json";
        return this.service.backupSecretSync(vaultBaseUrl, secretName, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BackupSecretResult backupSecret(String vaultBaseUrl, String secretName) {
        return (BackupSecretResult)this.backupSecretWithResponse(vaultBaseUrl, secretName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SecretBundle>> restoreSecretWithResponseAsync(String vaultBaseUrl, byte[] secretBundleBackup) {
        String accept = "application/json";
        SecretRestoreParameters parameters = new SecretRestoreParameters();
        parameters.setSecretBundleBackup(secretBundleBackup);
        return FluxUtil.withContext(context -> this.service.restoreSecret(vaultBaseUrl, this.getApiVersion(), parameters, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SecretBundle>> restoreSecretWithResponseAsync(String vaultBaseUrl, byte[] secretBundleBackup, Context context) {
        String accept = "application/json";
        SecretRestoreParameters parameters = new SecretRestoreParameters();
        parameters.setSecretBundleBackup(secretBundleBackup);
        return this.service.restoreSecret(vaultBaseUrl, this.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SecretBundle> restoreSecretAsync(String vaultBaseUrl, byte[] secretBundleBackup) {
        return this.restoreSecretWithResponseAsync(vaultBaseUrl, secretBundleBackup).flatMap(res -> Mono.justOrEmpty((Object)((SecretBundle)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SecretBundle> restoreSecretAsync(String vaultBaseUrl, byte[] secretBundleBackup, Context context) {
        return this.restoreSecretWithResponseAsync(vaultBaseUrl, secretBundleBackup, context).flatMap(res -> Mono.justOrEmpty((Object)((SecretBundle)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SecretBundle> restoreSecretWithResponse(String vaultBaseUrl, byte[] secretBundleBackup, Context context) {
        String accept = "application/json";
        SecretRestoreParameters parameters = new SecretRestoreParameters();
        parameters.setSecretBundleBackup(secretBundleBackup);
        return this.service.restoreSecretSync(vaultBaseUrl, this.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SecretBundle restoreSecret(String vaultBaseUrl, byte[] secretBundleBackup) {
        return (SecretBundle)this.restoreSecretWithResponse(vaultBaseUrl, secretBundleBackup, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<SecretItem>> getSecretsNextSinglePageAsync(String nextLink, String vaultBaseUrl) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getSecretsNext(nextLink, vaultBaseUrl, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SecretListResult)res.getValue()).getValue(), ((SecretListResult)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<SecretItem>> getSecretsNextSinglePageAsync(String nextLink, String vaultBaseUrl, Context context) {
        String accept = "application/json";
        return this.service.getSecretsNext(nextLink, vaultBaseUrl, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SecretListResult)res.getValue()).getValue(), ((SecretListResult)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<SecretItem> getSecretsNextSinglePage(String nextLink, String vaultBaseUrl) {
        String accept = "application/json";
        Response<SecretListResult> res = this.service.getSecretsNextSync(nextLink, vaultBaseUrl, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SecretListResult)res.getValue()).getValue(), ((SecretListResult)res.getValue()).getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<SecretItem> getSecretsNextSinglePage(String nextLink, String vaultBaseUrl, Context context) {
        String accept = "application/json";
        Response<SecretListResult> res = this.service.getSecretsNextSync(nextLink, vaultBaseUrl, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SecretListResult)res.getValue()).getValue(), ((SecretListResult)res.getValue()).getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<SecretItem>> getSecretVersionsNextSinglePageAsync(String nextLink, String vaultBaseUrl) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getSecretVersionsNext(nextLink, vaultBaseUrl, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SecretListResult)res.getValue()).getValue(), ((SecretListResult)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<SecretItem>> getSecretVersionsNextSinglePageAsync(String nextLink, String vaultBaseUrl, Context context) {
        String accept = "application/json";
        return this.service.getSecretVersionsNext(nextLink, vaultBaseUrl, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SecretListResult)res.getValue()).getValue(), ((SecretListResult)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<SecretItem> getSecretVersionsNextSinglePage(String nextLink, String vaultBaseUrl) {
        String accept = "application/json";
        Response<SecretListResult> res = this.service.getSecretVersionsNextSync(nextLink, vaultBaseUrl, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SecretListResult)res.getValue()).getValue(), ((SecretListResult)res.getValue()).getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<SecretItem> getSecretVersionsNextSinglePage(String nextLink, String vaultBaseUrl, Context context) {
        String accept = "application/json";
        Response<SecretListResult> res = this.service.getSecretVersionsNextSync(nextLink, vaultBaseUrl, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SecretListResult)res.getValue()).getValue(), ((SecretListResult)res.getValue()).getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<DeletedSecretItem>> getDeletedSecretsNextSinglePageAsync(String nextLink, String vaultBaseUrl) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getDeletedSecretsNext(nextLink, vaultBaseUrl, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeletedSecretListResult)res.getValue()).getValue(), ((DeletedSecretListResult)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<DeletedSecretItem>> getDeletedSecretsNextSinglePageAsync(String nextLink, String vaultBaseUrl, Context context) {
        String accept = "application/json";
        return this.service.getDeletedSecretsNext(nextLink, vaultBaseUrl, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeletedSecretListResult)res.getValue()).getValue(), ((DeletedSecretListResult)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<DeletedSecretItem> getDeletedSecretsNextSinglePage(String nextLink, String vaultBaseUrl) {
        String accept = "application/json";
        Response<DeletedSecretListResult> res = this.service.getDeletedSecretsNextSync(nextLink, vaultBaseUrl, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeletedSecretListResult)res.getValue()).getValue(), ((DeletedSecretListResult)res.getValue()).getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<DeletedSecretItem> getDeletedSecretsNextSinglePage(String nextLink, String vaultBaseUrl, Context context) {
        String accept = "application/json";
        Response<DeletedSecretListResult> res = this.service.getDeletedSecretsNextSync(nextLink, vaultBaseUrl, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeletedSecretListResult)res.getValue()).getValue(), ((DeletedSecretListResult)res.getValue()).getNextLink(), null);
    }

    @Host(value="{vaultBaseUrl}")
    @ServiceInterface(name="SecretClient")
    public static interface SecretClientService {
        @Put(value="/secrets/{secret-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<SecretBundle>> setSecret(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="secret-name") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") SecretSetParameters var4, @HeaderParam(value="Accept") String var5, @HeaderParam(value="Content-Type") String var6, Context var7);

        @Put(value="/secrets/{secret-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<SecretBundle> setSecretSync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="secret-name") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") SecretSetParameters var4, @HeaderParam(value="Accept") String var5, @HeaderParam(value="Content-Type") String var6, Context var7);

        @Delete(value="/secrets/{secret-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<DeletedSecretBundle>> deleteSecret(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="secret-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Delete(value="/secrets/{secret-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<DeletedSecretBundle> deleteSecretSync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="secret-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Patch(value="/secrets/{secret-name}/{secret-version}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<SecretBundle>> updateSecret(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="secret-name") String var2, @PathParam(value="secret-version") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") SecretUpdateParameters var5, @HeaderParam(value="Accept") String var6, @HeaderParam(value="Content-Type") String var7, Context var8);

        @Patch(value="/secrets/{secret-name}/{secret-version}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<SecretBundle> updateSecretSync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="secret-name") String var2, @PathParam(value="secret-version") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") SecretUpdateParameters var5, @HeaderParam(value="Accept") String var6, @HeaderParam(value="Content-Type") String var7, Context var8);

        @Get(value="/secrets/{secret-name}/{secret-version}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<SecretBundle>> getSecret(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="secret-name") String var2, @PathParam(value="secret-version") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/secrets/{secret-name}/{secret-version}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<SecretBundle> getSecretSync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="secret-name") String var2, @PathParam(value="secret-version") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/secrets")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<SecretListResult>> getSecrets(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="maxresults") Integer var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/secrets")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<SecretListResult> getSecretsSync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="maxresults") Integer var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/secrets/{secret-name}/versions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<SecretListResult>> getSecretVersions(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="secret-name") String var2, @QueryParam(value="maxresults") Integer var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/secrets/{secret-name}/versions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<SecretListResult> getSecretVersionsSync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="secret-name") String var2, @QueryParam(value="maxresults") Integer var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/deletedsecrets")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<DeletedSecretListResult>> getDeletedSecrets(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="maxresults") Integer var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/deletedsecrets")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<DeletedSecretListResult> getDeletedSecretsSync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="maxresults") Integer var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/deletedsecrets/{secret-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<DeletedSecretBundle>> getDeletedSecret(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="secret-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/deletedsecrets/{secret-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<DeletedSecretBundle> getDeletedSecretSync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="secret-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Delete(value="/deletedsecrets/{secret-name}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<Void>> purgeDeletedSecret(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="secret-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Delete(value="/deletedsecrets/{secret-name}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<Void> purgeDeletedSecretSync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="secret-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/deletedsecrets/{secret-name}/recover")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<SecretBundle>> recoverDeletedSecret(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="secret-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/deletedsecrets/{secret-name}/recover")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<SecretBundle> recoverDeletedSecretSync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="secret-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/secrets/{secret-name}/backup")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<BackupSecretResult>> backupSecret(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="secret-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/secrets/{secret-name}/backup")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<BackupSecretResult> backupSecretSync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="secret-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/secrets/restore")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<SecretBundle>> restoreSecret(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") SecretRestoreParameters var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/secrets/restore")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<SecretBundle> restoreSecretSync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") SecretRestoreParameters var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<SecretListResult>> getSecretsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="vaultBaseUrl") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<SecretListResult> getSecretsNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="vaultBaseUrl") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<SecretListResult>> getSecretVersionsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="vaultBaseUrl") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<SecretListResult> getSecretVersionsNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="vaultBaseUrl") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<DeletedSecretListResult>> getDeletedSecretsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="vaultBaseUrl") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<DeletedSecretListResult> getDeletedSecretsNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="vaultBaseUrl") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

