/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.sas;

import com.azure.data.tables.sas.TableSasIpRange;
import com.azure.data.tables.sas.TableSasPermission;
import com.azure.data.tables.sas.TableSasProtocol;
import java.time.OffsetDateTime;
import java.util.Objects;

public final class TableSasSignatureValues {
    private String version;
    private TableSasProtocol protocol;
    private OffsetDateTime startTime;
    private OffsetDateTime expiryTime;
    private String permissions;
    private TableSasIpRange sasIpRange;
    private String identifier;
    private String startPartitionKey;
    private String startRowKey;
    private String endPartitionKey;
    private String endRowKey;

    public TableSasSignatureValues(OffsetDateTime expiryTime, TableSasPermission permissions) {
        Objects.requireNonNull(expiryTime, "'expiryTime' cannot be null");
        Objects.requireNonNull(permissions, "'permissions' cannot be null");
        this.expiryTime = expiryTime;
        this.permissions = permissions.toString();
    }

    public TableSasSignatureValues(String identifier) {
        Objects.requireNonNull(identifier, "'identifier' cannot be null");
        this.identifier = identifier;
    }

    public String getVersion() {
        return this.version;
    }

    public TableSasSignatureValues setVersion(String version) {
        this.version = version;
        return this;
    }

    public TableSasProtocol getProtocol() {
        return this.protocol;
    }

    public TableSasSignatureValues setProtocol(TableSasProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public TableSasSignatureValues setStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime getExpiryTime() {
        return this.expiryTime;
    }

    public TableSasSignatureValues setExpiryTime(OffsetDateTime expiryTime) {
        this.expiryTime = expiryTime;
        return this;
    }

    public String getPermissions() {
        return this.permissions;
    }

    public TableSasSignatureValues setPermissions(TableSasPermission permissions) {
        Objects.requireNonNull(permissions, "'permissions' cannot be null");
        this.permissions = permissions.toString();
        return this;
    }

    public TableSasIpRange getSasIpRange() {
        return this.sasIpRange;
    }

    public TableSasSignatureValues setSasIpRange(TableSasIpRange sasIpRange) {
        this.sasIpRange = sasIpRange;
        return this;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public TableSasSignatureValues setIdentifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    public String getStartPartitionKey() {
        return this.startPartitionKey;
    }

    public TableSasSignatureValues setStartPartitionKey(String startPartitionKey) {
        this.startPartitionKey = startPartitionKey;
        return this;
    }

    public String getStartRowKey() {
        return this.startRowKey;
    }

    public TableSasSignatureValues setStartRowKey(String startRowKey) {
        this.startRowKey = startRowKey;
        return this;
    }

    public String getEndPartitionKey() {
        return this.endPartitionKey;
    }

    public TableSasSignatureValues setEndPartitionKey(String endPartitionKey) {
        this.endPartitionKey = endPartitionKey;
        return this;
    }

    public String getEndRowKey() {
        return this.endRowKey;
    }

    public TableSasSignatureValues setEndRowKey(String endRowKey) {
        this.endRowKey = endRowKey;
        return this;
    }
}

