/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Collection;
import java.util.Collections;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TitleDetector
extends ResourceXmlDetector
implements Detector.JavaScanner {
    public static final Issue ISSUE = Issue.create((String)"MenuTitle", (String)"Missing menu title", (String)"From the action bar documentation:\n\"It's important that you always define android:title for each menu item \u2014 even if you don't declare that the title appear with the action item \u2014 for three reasons:\n\n* If there's not enough room in the action bar for the action item, the menu item appears in the overflow menu and only the title appears.\n* Screen readers for sight-impaired users read the menu item's title.\n* If the action item appears with only the icon, a user can long-press the item to reveal a tool-tip that displays the action item's title.\nThe android:icon is always optional, but recommended.", (Category)Category.USABILITY, (int)5, (Severity)Severity.ERROR, (Implementation)new Implementation(TitleDetector.class, Scope.RESOURCE_FILE_SCOPE)).addMoreInfo("http://developer.android.com/guide/topics/ui/actionbar.html");

    public boolean appliesTo(@NonNull ResourceFolderType folderType) {
        return folderType == ResourceFolderType.MENU;
    }

    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Nullable
    public Collection<String> getApplicableElements() {
        return Collections.singletonList("item");
    }

    public void visitElement(@NonNull XmlContext context, @NonNull Element element) {
        if (element.hasAttributeNS("http://schemas.android.com/apk/res/android", "title")) {
            return;
        }
        if (context.getMainProject().getTargetSdk() < 11) {
            return;
        }
        if ("false".equals(element.getAttributeNS("http://schemas.android.com/apk/res/android", "visible"))) {
            return;
        }
        String message = "Menu items should specify a `title`";
        context.report(ISSUE, (Node)element, context.getLocation((Node)element), message);
    }
}

