/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class StateListDetector
extends ResourceXmlDetector {
    public static final Issue ISSUE = Issue.create((String)"StateListReachable", (String)"Unreachable state in a `<selector>`", (String)"In a selector, only the last child in the state list should omit a state qualifier. If not, all subsequent items in the list will be ignored since the given item will match all.", (Category)Category.CORRECTNESS, (int)5, (Severity)Severity.WARNING, (Implementation)new Implementation(StateListDetector.class, Scope.RESOURCE_FILE_SCOPE));
    private static final String STATE_PREFIX = "state_";

    public boolean appliesTo(@NonNull ResourceFolderType folderType) {
        return folderType == ResourceFolderType.DRAWABLE;
    }

    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    public void visitDocument(@NonNull XmlContext context, @NonNull Document document) {
        Element root = document.getDocumentElement();
        if (root != null && root.getTagName().equals("selector")) {
            int i;
            List children = LintUtils.getChildren((Node)root);
            HashMap states = new HashMap(children.size());
            for (i = 0; i < children.size(); ++i) {
                Element child = (Element)children.get(i);
                NamedNodeMap attributes = child.getAttributes();
                HashSet<String> stateNames = new HashSet<String>(attributes.getLength());
                states.put(child, stateNames);
                for (int j = 0; j < attributes.getLength(); ++j) {
                    Attr attribute = (Attr)attributes.item(j);
                    String name = attribute.getLocalName();
                    if (name == null) continue;
                    if (name.startsWith(STATE_PREFIX)) {
                        stateNames.add(name + '=' + attribute.getValue());
                        continue;
                    }
                    String namespaceUri = attribute.getNamespaceURI();
                    if (namespaceUri == null || namespaceUri.isEmpty() || "http://schemas.android.com/apk/res/android".equals(namespaceUri)) continue;
                    stateNames.add(attribute.getName() + '=' + attribute.getValue());
                }
            }
            for (i = 0; i < children.size() - 1; ++i) {
                Element prev = (Element)children.get(i);
                Set prevStates = (Set)states.get(prev);
                assert (prevStates != null) : prev;
                for (int j = i + 1; j < children.size(); ++j) {
                    Element current = (Element)children.get(j);
                    Set currentStates = (Set)states.get(current);
                    assert (currentStates != null) : current;
                    if (!currentStates.containsAll(prevStates)) continue;
                    Location location = context.getLocation((Node)current);
                    Location secondary = context.getLocation((Node)prev);
                    secondary.setMessage("Earlier item which masks item");
                    location.setSecondary(secondary);
                    context.report(ISSUE, (Node)current, location, String.format("This item is unreachable because a previous item (item #%1$d) is a more general match than this one", i + 1));
                    return;
                }
            }
        }
    }
}

