/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.checks.ControlFlowGraph;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import java.util.Arrays;
import java.util.List;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.AnalyzerException;

public class WakelockDetector
extends Detector
implements Detector.ClassScanner {
    public static final Issue ISSUE = Issue.create((String)"Wakelock", (String)"Incorrect `WakeLock` usage", (String)"Looks for problems with `WakeLock` usage", (String)"Failing to release a wakelock properly can keep the Android device in a high power mode, which reduces battery life. There are several causes of this, such as releasing the wake lock in `onDestroy()` instead of in `onPause()`, failing to call `release()` in all possible code paths after an `acquire()`, and so on.\n\nNOTE: If you are using the lock just to keep the screen on, you should strongly consider using `FLAG_KEEP_SCREEN_ON` instead. This window flag will be correctly managed by the platform as the user moves between applications and doesn't require a special permission. See http://developer.android.com/reference/android/view/WindowManager.LayoutParams.html#FLAG_KEEP_SCREEN_ON.", (Category)Category.PERFORMANCE, (int)9, (Severity)Severity.WARNING, (Implementation)new Implementation(WakelockDetector.class, Scope.CLASS_FILE_SCOPE));
    private static final String WAKELOCK_OWNER = "android/os/PowerManager$WakeLock";
    private static final String RELEASE_METHOD = "release";
    private static final String ACQUIRE_METHOD = "acquire";
    private static final String IS_HELD_METHOD = "isHeld";
    private static final String POWER_MANAGER = "android/os/PowerManager";
    private static final String NEW_WAKE_LOCK_METHOD = "newWakeLock";
    private static final boolean DEBUG = false;
    private boolean mHasAcquire;
    private boolean mHasRelease;
    private static final int SEEN_TARGET = 1;
    private static final int SEEN_BRANCH = 2;
    private static final int SEEN_EXCEPTION = 4;
    private static final int SEEN_RETURN = 8;

    public void afterCheckProject(@NonNull Context context) {
        if (this.mHasAcquire && !this.mHasRelease && context.getDriver().getPhase() == 1) {
            context.getDriver().requestRepeat((Detector)this, Scope.CLASS_FILE_SCOPE);
        }
    }

    @Nullable
    public List<String> getApplicableCallNames() {
        return Arrays.asList(ACQUIRE_METHOD, RELEASE_METHOD, NEW_WAKE_LOCK_METHOD);
    }

    public void checkCall(@NonNull ClassContext context, @NonNull ClassNode classNode, @NonNull MethodNode method, @NonNull MethodInsnNode call) {
        if (!context.getProject().getReportIssues()) {
            return;
        }
        if (call.owner.equals(WAKELOCK_OWNER)) {
            String name = call.name;
            if (name.equals(ACQUIRE_METHOD)) {
                if (call.desc.equals("(J)V")) {
                    return;
                }
                this.mHasAcquire = true;
                if (context.getDriver().getPhase() == 2) {
                    assert (!this.mHasRelease);
                    context.report(ISSUE, method, (AbstractInsnNode)call, context.getLocation((AbstractInsnNode)call), "Found a wakelock acquire() but no release() calls anywhere", null);
                } else {
                    assert (context.getDriver().getPhase() == 1);
                    this.checkFlow(context, classNode, method, call);
                }
            } else if (name.equals(RELEASE_METHOD)) {
                this.mHasRelease = true;
                if ("onDestroy".equals(method.name) && context.getDriver().isSubclassOf(classNode, "android/app/Activity")) {
                    context.report(ISSUE, method, (AbstractInsnNode)call, context.getLocation((AbstractInsnNode)call), "Wakelocks should be released in onPause, not onDestroy", null);
                }
            }
        } else if (call.owner.equals(POWER_MANAGER) && call.name.equals(NEW_WAKE_LOCK_METHOD)) {
            AbstractInsnNode prev = LintUtils.getPrevInstruction((AbstractInsnNode)call);
            if (prev == null) {
                return;
            }
            if ((prev = LintUtils.getPrevInstruction((AbstractInsnNode)prev)) == null || prev.getOpcode() != 18) {
                return;
            }
            LdcInsnNode ldc = (LdcInsnNode)prev;
            Object constant = ldc.cst;
            if (constant instanceof Integer) {
                int flag = (Integer)constant;
                boolean PARTIAL_WAKE_LOCK = true;
                int ACQUIRE_CAUSES_WAKEUP = 0x10000000;
                int both = 0x10000001;
                if ((flag & 0x10000001) == 0x10000001) {
                    context.report(ISSUE, method, (AbstractInsnNode)call, context.getLocation((AbstractInsnNode)call), "Should not set both PARTIAL_WAKE_LOCK and ACQUIRE_CAUSES_WAKEUP. If you do not want the screen to turn on, get rid of ACQUIRE_CAUSES_WAKEUP", null);
                }
            }
        }
    }

    private void checkFlow(@NonNull ClassContext context, @NonNull ClassNode classNode, @NonNull MethodNode method, @NonNull MethodInsnNode acquire) {
        InsnList instructions = method.instructions;
        MethodInsnNode release = null;
        int n = instructions.size();
        for (int i = 0; i < n; ++i) {
            AbstractInsnNode instruction = instructions.get(i);
            int type = instruction.getType();
            if (type != 5) continue;
            MethodInsnNode call = (MethodInsnNode)instruction;
            if (!call.name.equals(RELEASE_METHOD) || !call.owner.equals(WAKELOCK_OWNER)) continue;
            release = call;
            break;
        }
        if (release == null) {
            return;
        }
        try {
            MyGraph graph = new MyGraph();
            ControlFlowGraph.create(graph, classNode, method);
            int status = WakelockDetector.dfs(graph.getNode((AbstractInsnNode)acquire));
            if ((status & 8) != 0) {
                String message = (status & 4) != 0 ? "The release() call is not always reached (via exceptional flow)" : "The release() call is not always reached";
                context.report(ISSUE, method, (AbstractInsnNode)acquire, context.getLocation((AbstractInsnNode)release), message, null);
            }
        }
        catch (AnalyzerException e) {
            context.log((Throwable)e, null, new Object[0]);
        }
    }

    protected static int dfs(ControlFlowGraph.Node node) {
        int opcode;
        AbstractInsnNode instruction = node.instruction;
        if (instruction.getType() == 7 && ((opcode = instruction.getOpcode()) == 177 || opcode == 176 || opcode == 173 || opcode == 172 || opcode == 175 || opcode == 174 || opcode == 191)) {
            return 8;
        }
        if (node.visit != 0) {
            return 0;
        }
        node.visit = 1;
        if (instruction.getType() == 5) {
            MethodInsnNode method = (MethodInsnNode)instruction;
            if (method.name.equals(RELEASE_METHOD) && method.owner.equals(WAKELOCK_OWNER)) {
                return 1;
            }
            if (!(method.name.equals(ACQUIRE_METHOD) && method.owner.equals(WAKELOCK_OWNER) || method.name.equals(IS_HELD_METHOD) && method.owner.equals(WAKELOCK_OWNER) || node.exceptions != null && !node.exceptions.isEmpty())) {
                boolean foundFrame = false;
                for (AbstractInsnNode curr = method.getPrevious(); curr != null; curr = curr.getPrevious()) {
                    if (curr.getType() != 14) continue;
                    foundFrame = true;
                    break;
                }
                if (!foundFrame) {
                    return 8;
                }
            }
        }
        int status = 0;
        boolean implicitReturn = true;
        List<ControlFlowGraph.Node> successors = node.successors;
        List<ControlFlowGraph.Node> exceptions = node.exceptions;
        if (exceptions != null) {
            if (!exceptions.isEmpty()) {
                implicitReturn = false;
            }
            for (ControlFlowGraph.Node successor : exceptions) {
                status = WakelockDetector.dfs(successor) | status;
                if ((status & 8) == 0) continue;
                return status;
            }
            if (status != 0) {
                status |= 4;
            }
        }
        if (successors != null) {
            if (!successors.isEmpty()) {
                implicitReturn = false;
                if (successors.size() > 1) {
                    status |= 2;
                }
            }
            for (ControlFlowGraph.Node successor : successors) {
                status = WakelockDetector.dfs(successor) | status;
                if ((status & 8) == 0) continue;
                return status;
            }
        }
        if (implicitReturn) {
            status |= 8;
        }
        return status;
    }

    private static class MyGraph
    extends ControlFlowGraph {
        private MyGraph() {
        }

        @Override
        protected void add(@NonNull AbstractInsnNode from, @NonNull AbstractInsnNode to) {
            if (from.getOpcode() == 198) {
                AbstractInsnNode next;
                JumpInsnNode jump = (JumpInsnNode)from;
                if (jump.label == to && (next = LintUtils.getNextInstruction((AbstractInsnNode)from)) != null && next.getType() == 2 && (next = LintUtils.getNextInstruction((AbstractInsnNode)next)) != null && next.getType() == 5) {
                    MethodInsnNode method = (MethodInsnNode)next;
                    if (method.name.equals(WakelockDetector.RELEASE_METHOD) && method.owner.equals(WakelockDetector.WAKELOCK_OWNER)) {
                        return;
                    }
                }
            } else if (from.getOpcode() == 153) {
                AbstractInsnNode prev;
                JumpInsnNode jump = (JumpInsnNode)from;
                if (jump.label == to && (prev = LintUtils.getPrevInstruction((AbstractInsnNode)from)) != null && prev.getType() == 5) {
                    AbstractInsnNode next;
                    MethodInsnNode method = (MethodInsnNode)prev;
                    if (method.name.equals(WakelockDetector.IS_HELD_METHOD) && method.owner.equals(WakelockDetector.WAKELOCK_OWNER) && (next = LintUtils.getNextInstruction((AbstractInsnNode)from)) != null) {
                        super.add(from, next);
                        return;
                    }
                }
            }
            super.add(from, to);
        }
    }
}

