/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.res2.AbstractResourceRepository;
import com.android.ide.common.res2.ResourceItem;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.Pair;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.ast.AstVisitor;
import lombok.ast.BooleanLiteral;
import lombok.ast.CharLiteral;
import lombok.ast.ConstructorDeclaration;
import lombok.ast.ConstructorInvocation;
import lombok.ast.Expression;
import lombok.ast.FloatingPointLiteral;
import lombok.ast.ForwardingAstVisitor;
import lombok.ast.IntegralLiteral;
import lombok.ast.MethodDeclaration;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;
import lombok.ast.NullLiteral;
import lombok.ast.Select;
import lombok.ast.StrictListAccessor;
import lombok.ast.StringLiteral;
import lombok.ast.VariableDefinitionEntry;
import lombok.ast.VariableReference;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class StringFormatDetector
extends ResourceXmlDetector
implements Detector.JavaScanner {
    private static final Implementation IMPLEMENTATION_XML = new Implementation(StringFormatDetector.class, Scope.ALL_RESOURCES_SCOPE);
    private static final Implementation IMPLEMENTATION_XML_AND_JAVA = new Implementation(StringFormatDetector.class, EnumSet.of(Scope.ALL_RESOURCE_FILES, Scope.JAVA_FILE), new EnumSet[]{Scope.JAVA_FILE_SCOPE});
    public static final Issue INVALID = Issue.create((String)"StringFormatInvalid", (String)"Invalid format string", (String)"Checks that format strings are valid", (String)"If a string contains a '%' character, then the string may be a formatting string which will be passed to `String.format` from Java code to replace each '%' occurrence with specific values.\n\nThis lint warning checks for two related problems:\n(1) Formatting strings that are invalid, meaning that `String.format` will throw exceptions at runtime when attempting to use the format string.\n(2) Strings containing '%' that are not formatting strings getting passed to a `String.format` call. In this case the '%' will need to be escaped as '%%'.\n\nNOTE: Not all Strings which look like formatting strings are intended for use by `String.format`; for example, they may contain date formats intended for `android.text.format.Time#format()`. Lint cannot always figure out that a String is a date format, so you may get false warnings in those scenarios. See the suppress help topic for information on how to suppress errors in that case.", (Category)Category.MESSAGES, (int)9, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION_XML);
    public static final Issue ARG_COUNT = Issue.create((String)"StringFormatCount", (String)"Formatting argument types incomplete or inconsistent", (String)"Ensures that all format strings are used and that the same number is defined across translations", (String)"When a formatted string takes arguments, it usually needs to reference the same arguments in all translations (or all arguments if there are no translations.\n\nThere are cases where this is not the case, so this issue is a warning rather than an error by default. However, this usually happens when a language is not translated or updated correctly.", (Category)Category.MESSAGES, (int)5, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION_XML);
    public static final Issue ARG_TYPES = Issue.create((String)"StringFormatMatches", (String)"`String.format` string doesn't match the XML format string", (String)"Ensures that the format used in `<string>` definitions is compatible with the `String.format` call", (String)"This lint check ensures the following:\n(1) If there are multiple translations of the format string, then all translations use the same type for the same numbered arguments\n(2) The usage of the format string in Java is consistent with the format string, meaning that the parameter types passed to String.format matches those in the format string.", (Category)Category.MESSAGES, (int)9, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION_XML_AND_JAVA);
    private Map<String, List<Pair<Location.Handle, String>>> mFormatStrings;
    private final Map<String, Location.Handle> mNotFormatStrings = new HashMap<String, Location.Handle>();
    private Set<String> mIgnoreStrings;
    private static final int CONVERSION_CLASS_UNKNOWN = 0;
    private static final int CONVERSION_CLASS_STRING = 1;
    private static final int CONVERSION_CLASS_CHARACTER = 2;
    private static final int CONVERSION_CLASS_INTEGER = 3;
    private static final int CONVERSION_CLASS_FLOAT = 4;
    private static final int CONVERSION_CLASS_BOOLEAN = 5;
    private static final int CONVERSION_CLASS_HASHCODE = 6;
    private static final int CONVERSION_CLASS_PERCENT = 7;
    private static final int CONVERSION_CLASS_NEWLINE = 8;
    private static final int CONVERSION_CLASS_DATETIME = 9;
    private static final Pattern FORMAT = Pattern.compile("%(\\d+\\$)?([-+#, 0(\\<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])");

    public boolean appliesTo(@NonNull ResourceFolderType folderType) {
        return folderType == ResourceFolderType.VALUES;
    }

    public boolean appliesTo(@NonNull Context context, @NonNull File file) {
        if (LintUtils.endsWith((String)file.getName(), (String)".java")) {
            return this.mFormatStrings != null;
        }
        return super.appliesTo(context, file);
    }

    public Collection<String> getApplicableElements() {
        return Collections.singletonList("string");
    }

    public void visitElement(@NonNull XmlContext context, @NonNull Element element) {
        org.w3c.dom.Node child;
        NodeList childNodes = element.getChildNodes();
        if (childNodes.getLength() > 0 && childNodes.getLength() == 1 && (child = childNodes.item(0)).getNodeType() == 3) {
            this.checkTextNode(context, element, StringFormatDetector.strip(child.getNodeValue()));
        }
    }

    private static String strip(String s) {
        char last;
        if (s.length() < 2) {
            return s;
        }
        char first = s.charAt(0);
        if (first == (last = s.charAt(s.length() - 1)) && (first == '\'' || first == '\"')) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    private void checkTextNode(XmlContext context, Element element, String text) {
        String name = null;
        boolean found = false;
        int m = text.length();
        for (int j = 0; j < m; ++j) {
            String formatted;
            char c = text.charAt(j);
            if (c == '\\') {
                ++j;
            }
            if (c != '%') continue;
            if (name == null) {
                name = element.getAttribute("name");
            }
            if (!(formatted = element.getAttribute("formatted")).isEmpty() && !Boolean.parseBoolean(formatted)) {
                if (!this.mNotFormatStrings.containsKey(name)) {
                    Location.Handle handle = context.createLocationHandle((org.w3c.dom.Node)element);
                    handle.setClientData((Object)element);
                    this.mNotFormatStrings.put(name, handle);
                }
                return;
            }
            Matcher matcher = FORMAT.matcher(text);
            if (!matcher.find(j)) {
                if (!this.mNotFormatStrings.containsKey(name)) {
                    Location.Handle handle = context.createLocationHandle((org.w3c.dom.Node)element);
                    handle.setClientData((Object)element);
                    this.mNotFormatStrings.put(name, handle);
                }
                return;
            }
            String conversion = matcher.group(6);
            int conversionClass = StringFormatDetector.getConversionClass(conversion.charAt(0));
            if (conversionClass == 0 || matcher.group(5) != null) {
                if (this.mIgnoreStrings == null) {
                    this.mIgnoreStrings = new HashSet<String>();
                }
                this.mIgnoreStrings.add(name);
                return;
            }
            found = true;
            ++j;
        }
        if (found && name != null) {
            List<Pair<Location.Handle, String>> list;
            if (!context.getProject().getReportIssues()) {
                return;
            }
            if (this.mFormatStrings == null) {
                this.mFormatStrings = new HashMap<String, List<Pair<Location.Handle, String>>>();
            }
            if ((list = this.mFormatStrings.get(name)) == null) {
                list = new ArrayList<Pair<Location.Handle, String>>();
                this.mFormatStrings.put(name, list);
            }
            Location.Handle handle = context.createLocationHandle((org.w3c.dom.Node)element);
            handle.setClientData((Object)element);
            list.add((Pair<Location.Handle, String>)Pair.of((Object)handle, (Object)text));
        }
    }

    public void afterCheckProject(@NonNull Context context) {
        if (this.mFormatStrings != null) {
            boolean checkCount = context.isEnabled(ARG_COUNT);
            boolean checkValid = context.isEnabled(INVALID);
            boolean checkTypes = context.isEnabled(ARG_TYPES);
            for (Map.Entry<String, List<Pair<Location.Handle, String>>> entry : this.mFormatStrings.entrySet()) {
                String name = entry.getKey();
                List<Pair<Location.Handle, String>> list = entry.getValue();
                if (checkCount) {
                    StringFormatDetector.checkArity(context, name, list);
                }
                if (!checkValid && !checkTypes) continue;
                StringFormatDetector.checkTypes(context, checkValid, checkTypes, name, list);
            }
        }
    }

    private static void checkTypes(Context context, boolean checkValid, boolean checkTypes, String name, List<Pair<Location.Handle, String>> list) {
        HashMap<Integer, String> types = new HashMap<Integer, String>();
        HashMap<Integer, Location.Handle> typeDefinition = new HashMap<Integer, Location.Handle>();
        block0: for (Pair<Location.Handle, String> pair : list) {
            Location.Handle handle = (Location.Handle)pair.getFirst();
            String formatString = (String)pair.getSecond();
            Matcher matcher = FORMAT.matcher(formatString);
            int index = 0;
            int prevIndex = 0;
            int nextNumber = 1;
            while (matcher.find(index)) {
                int number;
                char last;
                int matchStart = matcher.start();
                while (prevIndex < matchStart) {
                    char c = formatString.charAt(prevIndex);
                    if (c == '\\') {
                        ++prevIndex;
                    }
                    ++prevIndex;
                }
                if (prevIndex > matchStart) {
                    index = prevIndex;
                    continue;
                }
                index = matcher.end();
                String str = formatString.substring(matchStart, matcher.end());
                if (str.equals("%%") || str.equals("%n")) continue;
                if (checkValid && str.length() > 2 && str.charAt(str.length() - 2) == ' ' && (last = str.charAt(str.length() - 1)) != 'd' && last != 'o' && last != 'x' && last != 'X') {
                    Object clientData = handle.getClientData();
                    if (clientData instanceof org.w3c.dom.Node && context.getDriver().isSuppressed(null, INVALID, (org.w3c.dom.Node)clientData)) {
                        return;
                    }
                    Location location = handle.resolve();
                    String message = String.format("Incorrect formatting string %1$s; missing conversion character in '%2$s' ?", name, str);
                    context.report(INVALID, location, message, null);
                    continue;
                }
                if (!checkTypes) continue;
                String numberString = matcher.group(1);
                if (numberString != null) {
                    numberString = numberString.substring(0, numberString.length() - 1);
                    number = Integer.parseInt(numberString);
                    nextNumber = number + 1;
                } else {
                    number = nextNumber++;
                }
                String format = matcher.group(6);
                String currentFormat = (String)types.get(number);
                if (currentFormat == null) {
                    types.put(number, format);
                    typeDefinition.put(number, handle);
                    continue;
                }
                if (currentFormat.equals(format) || !StringFormatDetector.isIncompatible(currentFormat.charAt(0), format.charAt(0))) continue;
                Object clientData = handle.getClientData();
                if (clientData instanceof org.w3c.dom.Node && context.getDriver().isSuppressed(null, ARG_TYPES, (org.w3c.dom.Node)clientData)) {
                    return;
                }
                Location location = handle.resolve();
                location = StringFormatDetector.refineLocation(context, location, formatString, matcher.start(), matcher.end());
                Location otherLocation = ((Location.Handle)typeDefinition.get(number)).resolve();
                otherLocation.setMessage("Conflicting argument type here");
                location.setSecondary(otherLocation);
                File f = otherLocation.getFile();
                String message = String.format("Inconsistent formatting types for argument #%1$d in format string %2$s ('%3$s'): Found both '%4$s' and '%5$s' (in %6$s)", number, name, str, currentFormat, format, f.getParentFile().getName() + File.separator + f.getName());
                context.report(ARG_TYPES, location, message, null);
                continue block0;
            }
        }
    }

    private static boolean isIncompatible(char conversion1, char conversion2) {
        int class2;
        int class1 = StringFormatDetector.getConversionClass(conversion1);
        return class1 != (class2 = StringFormatDetector.getConversionClass(conversion2)) && class1 != 0 && class2 != 0;
    }

    private static int getConversionClass(char conversion) {
        switch (conversion) {
            case 'T': 
            case 't': {
                return 9;
            }
            case 'S': 
            case 's': {
                return 1;
            }
            case 'C': 
            case 'c': {
                return 2;
            }
            case 'X': 
            case 'd': 
            case 'o': 
            case 'x': {
                return 3;
            }
            case 'A': 
            case 'E': 
            case 'G': 
            case 'a': 
            case 'e': 
            case 'f': 
            case 'g': {
                return 4;
            }
            case 'B': 
            case 'b': {
                return 5;
            }
            case 'H': 
            case 'h': {
                return 6;
            }
            case '%': {
                return 7;
            }
            case 'n': {
                return 8;
            }
        }
        return 0;
    }

    private static Location refineLocation(Context context, Location location, String formatString, int substringStart, int substringEnd) {
        Position startLocation = location.getStart();
        Position endLocation = location.getEnd();
        if (startLocation != null && endLocation != null) {
            int formatOffset;
            String contents;
            int startOffset = startLocation.getOffset();
            int endOffset = endLocation.getOffset();
            if (startOffset >= 0 && endOffset <= (contents = context.getClient().readFile(location.getFile())).length() && startOffset < endOffset && (formatOffset = contents.indexOf(formatString, startOffset)) != -1 && formatOffset <= endOffset) {
                return Location.create((File)location.getFile(), (String)contents, (int)(formatOffset + substringStart), (int)(formatOffset + substringEnd));
            }
        }
        return location;
    }

    private static void checkArity(Context context, String name, List<Pair<Location.Handle, String>> list) {
        int prevCount = -1;
        for (Pair<Location.Handle, String> pair : list) {
            HashSet<Integer> indices = new HashSet<Integer>();
            int count = StringFormatDetector.getFormatArgumentCount((String)pair.getSecond(), indices);
            Location.Handle handle = (Location.Handle)pair.getFirst();
            if (prevCount != -1 && prevCount != count) {
                Object clientData = handle.getClientData();
                if (clientData instanceof org.w3c.dom.Node && context.getDriver().isSuppressed(null, ARG_COUNT, (org.w3c.dom.Node)clientData)) {
                    return;
                }
                Location location = handle.resolve();
                Location secondary = ((Location.Handle)list.get(0).getFirst()).resolve();
                secondary.setMessage("Conflicting number of arguments here");
                location.setSecondary(secondary);
                String message = String.format("Inconsistent number of arguments in formatting string %1$s; found both %2$d and %3$d", name, prevCount, count);
                context.report(ARG_COUNT, location, message, null);
                break;
            }
            for (int i = 1; i <= count; ++i) {
                if (indices.contains(i)) continue;
                Object clientData = handle.getClientData();
                if (clientData instanceof org.w3c.dom.Node && context.getDriver().isSuppressed(null, ARG_COUNT, (org.w3c.dom.Node)clientData)) {
                    return;
                }
                HashSet<Integer> all = new HashSet<Integer>();
                for (int j = 1; j < count; ++j) {
                    all.add(j);
                }
                all.removeAll(indices);
                ArrayList sorted = new ArrayList(all);
                Collections.sort(sorted);
                Location location = handle.resolve();
                String message = String.format("Formatting string '%1$s' is not referencing numbered arguments %2$s", name, sorted);
                context.report(ARG_COUNT, location, message, null);
                break;
            }
            prevCount = count;
        }
    }

    @Nullable
    static String getFormatArgumentType(String s, int argument) {
        Matcher matcher = FORMAT.matcher(s);
        int index = 0;
        int prevIndex = 0;
        int nextNumber = 1;
        while (matcher.find(index)) {
            int number;
            String value = matcher.group(6);
            if ("%".equals(value) || "n".equals(value)) {
                index = matcher.end();
                continue;
            }
            int matchStart = matcher.start();
            while (prevIndex < matchStart) {
                char c = s.charAt(prevIndex);
                if (c == '\\') {
                    ++prevIndex;
                }
                ++prevIndex;
            }
            if (prevIndex > matchStart) {
                index = prevIndex;
                continue;
            }
            String numberString = matcher.group(1);
            if (numberString != null) {
                numberString = numberString.substring(0, numberString.length() - 1);
                number = Integer.parseInt(numberString);
                nextNumber = number + 1;
            } else {
                number = nextNumber++;
            }
            if (number == argument) {
                return matcher.group(6);
            }
            index = matcher.end();
        }
        return null;
    }

    static int getFormatArgumentCount(@NonNull String s, @Nullable Set<Integer> seenArguments) {
        Matcher matcher = FORMAT.matcher(s);
        int index = 0;
        int prevIndex = 0;
        int nextNumber = 1;
        int max = 0;
        while (matcher.find(index)) {
            int number;
            String value = matcher.group(6);
            if ("%".equals(value) || "n".equals(value)) {
                index = matcher.end();
                continue;
            }
            int matchStart = matcher.start();
            while (prevIndex < matchStart) {
                char c = s.charAt(prevIndex);
                if (c == '\\') {
                    ++prevIndex;
                }
                ++prevIndex;
            }
            if (prevIndex > matchStart) {
                index = prevIndex;
                continue;
            }
            String numberString = matcher.group(1);
            if (numberString != null) {
                numberString = numberString.substring(0, numberString.length() - 1);
                number = Integer.parseInt(numberString);
                nextNumber = number + 1;
            } else {
                number = nextNumber++;
            }
            if (number > max) {
                max = number;
            }
            if (seenArguments != null) {
                seenArguments.add(number);
            }
            index = matcher.end();
        }
        return max;
    }

    public static boolean isLocaleSpecific(@NonNull String format) {
        if (format.indexOf(37) == -1) {
            return false;
        }
        Matcher matcher = FORMAT.matcher(format);
        int index = 0;
        int prevIndex = 0;
        while (matcher.find(index)) {
            int matchStart = matcher.start();
            while (prevIndex < matchStart) {
                char c = format.charAt(prevIndex);
                if (c == '\\') {
                    ++prevIndex;
                }
                ++prevIndex;
            }
            if (prevIndex > matchStart) {
                index = prevIndex;
                continue;
            }
            String type = matcher.group(6);
            if (!type.isEmpty()) {
                char t = type.charAt(0);
                switch (t) {
                    case 'E': 
                    case 'G': 
                    case 'T': 
                    case 'd': 
                    case 'e': 
                    case 'f': 
                    case 'g': 
                    case 't': {
                        return true;
                    }
                }
            }
            index = matcher.end();
        }
        return false;
    }

    public List<String> getApplicableMethodNames() {
        return Arrays.asList("format", "getString");
    }

    public void visitMethod(@NonNull JavaContext context, @Nullable AstVisitor visitor, @NonNull MethodInvocation node) {
        if (this.mFormatStrings == null && !context.getClient().supportsProjectResources()) {
            return;
        }
        String methodName = node.astName().astValue();
        if (methodName.equals("format")) {
            VariableReference ref;
            if (node.astOperand() instanceof VariableReference && "String".equals((ref = (VariableReference)node.astOperand()).astIdentifier().astValue())) {
                this.checkFormatCall(context, node);
            }
        } else if (node.astArguments().size() > 1 && node.astOperand() != null) {
            this.checkFormatCall(context, node);
        }
    }

    private void checkFormatCall(JavaContext context, MethodInvocation node) {
        Node current = StringFormatDetector.getParentMethod((Node)node);
        if (current != null) {
            this.checkStringFormatCall(context, current, node);
        }
    }

    private void checkStringFormatCall(JavaContext context, Node method, MethodInvocation call) {
        ArrayList list;
        String firstName;
        StrictListAccessor args = call.astArguments();
        if (args.isEmpty()) {
            return;
        }
        StringTracker tracker = new StringTracker(context, method, (Node)call, 0);
        method.accept((AstVisitor)tracker);
        String name = tracker.getFormatStringName();
        if (name == null) {
            return;
        }
        if (this.mIgnoreStrings != null && this.mIgnoreStrings.contains(name)) {
            return;
        }
        if (this.mNotFormatStrings.containsKey(name)) {
            Location.Handle handle = this.mNotFormatStrings.get(name);
            Object clientData = handle.getClientData();
            if (clientData instanceof org.w3c.dom.Node && context.getDriver().isSuppressed(null, INVALID, (org.w3c.dom.Node)clientData)) {
                return;
            }
            Location location = handle.resolve();
            String message = String.format("Format string '%1$s' is not a valid format string so it should not be passed to String.format", name);
            context.report(INVALID, (Node)call, location, message, null);
            return;
        }
        Iterator argIterator = args.iterator();
        Expression first = (Expression)argIterator.next();
        Expression second = argIterator.hasNext() ? (Expression)argIterator.next() : null;
        JavaParser.TypeDescriptor parameterType = context.getType((Node)first);
        boolean specifiesLocale = parameterType != null ? StringFormatDetector.isLocaleReference(parameterType.getName()) : (!call.astName().astValue().equals("format") ? false : (firstName = first.toString()).startsWith("Locale.") || firstName.contains("locale") || firstName.equals("null") || second != null && second.toString().contains("getString") && !firstName.contains("getString") && !firstName.contains("R.") && !(first instanceof StringLiteral));
        ArrayList arrayList = list = this.mFormatStrings != null ? this.mFormatStrings.get(name) : null;
        if (list == null) {
            LintClient client = context.getClient();
            if (client.supportsProjectResources() && !context.getScope().contains(Scope.RESOURCE_FILE)) {
                AbstractResourceRepository resources = client.getProjectResources(context.getMainProject(), true);
                List items = resources.getResourceItem(ResourceType.STRING, name);
                if (items != null) {
                    for (ResourceItem item : items) {
                        String value;
                        ResourceValue v = item.getResourceValue(false);
                        if (v == null || (value = v.getRawXmlValue()) == null) continue;
                        boolean isFormattingString = value.indexOf(37) != -1;
                        int m = value.length();
                        for (int j = 0; j < m && isFormattingString; ++j) {
                            char c = value.charAt(j);
                            if (c == '\\') {
                                ++j;
                                continue;
                            }
                            if (c != '%') continue;
                            Matcher matcher = FORMAT.matcher(value);
                            if (!matcher.find(j)) {
                                isFormattingString = false;
                            } else {
                                String conversion = matcher.group(6);
                                int conversionClass = StringFormatDetector.getConversionClass(conversion.charAt(0));
                                if (conversionClass == 0 || matcher.group(5) != null) {
                                    return;
                                }
                            }
                            ++j;
                        }
                        if (!isFormattingString) continue;
                        if (list == null) {
                            list = Lists.newArrayList();
                            if (this.mFormatStrings == null) {
                                this.mFormatStrings = Maps.newHashMap();
                            }
                            this.mFormatStrings.put(name, list);
                        }
                        Location.Handle handle = client.createResourceItemHandle(item);
                        list.add(Pair.of((Object)handle, (Object)value));
                    }
                }
            } else {
                return;
            }
        }
        if (list != null) {
            Set reported = null;
            for (Pair<Location.Handle, String> pair : list) {
                String s = (String)pair.getSecond();
                if (reported != null && reported.contains(s)) continue;
                int count = StringFormatDetector.getFormatArgumentCount(s, null);
                Location.Handle handle = (Location.Handle)pair.getFirst();
                if (count != args.size() - 1 - (specifiesLocale ? 1 : 0)) {
                    if (StringFormatDetector.isSharedPreferenceGetString(context, call)) continue;
                    Location location = context.getLocation((Node)call);
                    Location secondary = handle.resolve();
                    secondary.setMessage(String.format("This definition requires %1$d arguments", count));
                    location.setSecondary(secondary);
                    String message = String.format("Wrong argument count, format string %1$s requires %2$d but format call supplies %3$d", name, count, args.size() - 1 - (specifiesLocale ? 1 : 0));
                    context.report(ARG_TYPES, method, location, message, null);
                    if (reported == null) {
                        reported = Sets.newHashSet();
                    }
                    reported.add(s);
                    continue;
                }
                for (int i = 1; i <= count; ++i) {
                    int argumentIndex = i + (specifiesLocale ? 1 : 0);
                    Class<?> type = tracker.getArgumentType(argumentIndex);
                    if (type == null) continue;
                    boolean valid = true;
                    String formatType = StringFormatDetector.getFormatArgumentType(s, i);
                    if (formatType == null) continue;
                    char last = formatType.charAt(formatType.length() - 1);
                    if (formatType.length() >= 2 && Character.toLowerCase(formatType.charAt(formatType.length() - 2)) == 't') continue;
                    switch (last) {
                        case 'B': 
                        case 'b': {
                            valid = type == Boolean.TYPE;
                            break;
                        }
                        case 'A': 
                        case 'E': 
                        case 'G': 
                        case 'X': 
                        case 'a': 
                        case 'd': 
                        case 'e': 
                        case 'f': 
                        case 'g': 
                        case 'o': 
                        case 'x': {
                            valid = type == Integer.TYPE || type == Float.TYPE || type == Double.TYPE || type == Long.TYPE || type == Byte.TYPE || type == Short.TYPE;
                            break;
                        }
                        case 'C': 
                        case 'c': {
                            valid = type == Character.TYPE;
                            break;
                        }
                        case 'H': 
                        case 'S': 
                        case 'h': 
                        case 's': {
                            boolean bl = valid = type != Boolean.TYPE && !Number.class.isAssignableFrom(type);
                        }
                    }
                    if (valid || StringFormatDetector.isSharedPreferenceGetString(context, call)) continue;
                    Expression argument = tracker.getArgument(argumentIndex);
                    Location location = context.getLocation((Node)argument);
                    Location secondary = handle.resolve();
                    secondary.setMessage("Conflicting argument declaration here");
                    location.setSecondary(secondary);
                    String message = String.format("Wrong argument type for formatting argument '#%1$d' in %2$s: conversion is '%3$s', received %4$s (argument #%5$d in method call)", i, name, formatType, type.getSimpleName(), argumentIndex + 1);
                    context.report(ARG_TYPES, method, location, message, null);
                    if (reported == null) {
                        reported = Sets.newHashSet();
                    }
                    reported.add(s);
                }
            }
        }
    }

    private static boolean isSharedPreferenceGetString(@NonNull JavaContext context, @NonNull MethodInvocation call) {
        if (!"getString".equals(call.astName().astValue())) {
            return false;
        }
        JavaParser.ResolvedNode resolved = context.resolve((Node)call);
        if (resolved instanceof JavaParser.ResolvedMethod) {
            JavaParser.ResolvedMethod resolvedMethod = (JavaParser.ResolvedMethod)resolved;
            JavaParser.ResolvedClass containingClass = resolvedMethod.getContainingClass();
            return containingClass.isSubclassOf("android.content.SharedPreferences", false);
        }
        return false;
    }

    private static boolean isLocaleReference(@Nullable JavaParser.TypeDescriptor reference) {
        return reference != null && StringFormatDetector.isLocaleReference(reference.getName());
    }

    private static boolean isLocaleReference(@Nullable String typeName) {
        return typeName != null && (typeName.equals("Locale") || typeName.equals("java.util.Locale"));
    }

    @Nullable
    public static Node getParentMethod(@NonNull Node node) {
        Node current;
        for (current = node.getParent(); current != null && !(current instanceof MethodDeclaration) && !(current instanceof ConstructorDeclaration); current = current.getParent()) {
        }
        return current;
    }

    @Nullable
    public static String getResourceForFirstArg(@NonNull Node method, @NonNull Node call) {
        assert (call instanceof MethodInvocation || call instanceof ConstructorInvocation);
        StringTracker tracker = new StringTracker(null, method, call, 0);
        method.accept((AstVisitor)tracker);
        return tracker.getFormatStringName();
    }

    @Nullable
    public static String getResourceArg(@NonNull Node method, @NonNull Node call, int argIndex) {
        assert (call instanceof MethodInvocation || call instanceof ConstructorInvocation);
        StringTracker tracker = new StringTracker(null, method, call, argIndex);
        method.accept((AstVisitor)tracker);
        return tracker.getFormatStringName();
    }

    private static class StringTracker
    extends ForwardingAstVisitor {
        private final Node mTop;
        private final int mArgIndex;
        private final Map<String, String> mMap = new HashMap<String, String>();
        private final Map<String, Class<?>> mTypes = new HashMap();
        private final Node mTargetNode;
        private boolean mDone;
        @Nullable
        private JavaContext mContext;
        private String mName;

        public StringTracker(@Nullable JavaContext context, Node top, Node targetNode, int argIndex) {
            this.mContext = context;
            this.mTop = top;
            this.mArgIndex = argIndex;
            this.mTargetNode = targetNode;
        }

        public String getFormatStringName() {
            return this.mName;
        }

        public Class<?> getArgumentType(int argument) {
            Expression arg = this.getArgument(argument);
            if (arg != null) {
                Class<?> type = this.getType(arg);
                if (type != null) {
                    return type;
                }
                if (this.mContext != null) {
                    return StringTracker.getTypeClass(this.mContext.getType((Node)arg));
                }
            }
            return null;
        }

        private static Class<?> getTypeClass(@Nullable JavaParser.TypeDescriptor type) {
            if (type != null) {
                return StringTracker.getTypeClass(type.getName());
            }
            return null;
        }

        private static Class<?> getTypeClass(@Nullable String fqcn) {
            if (fqcn == null) {
                return null;
            }
            if (fqcn.equals("java.lang.String") || fqcn.equals("String")) {
                return String.class;
            }
            if (fqcn.equals("int")) {
                return Integer.TYPE;
            }
            if (fqcn.equals("boolean")) {
                return Boolean.TYPE;
            }
            if (fqcn.equals("null")) {
                return Object.class;
            }
            if (fqcn.equals("long")) {
                return Long.TYPE;
            }
            if (fqcn.equals("float")) {
                return Float.TYPE;
            }
            if (fqcn.equals("double")) {
                return Double.TYPE;
            }
            if (fqcn.equals("char")) {
                return Character.TYPE;
            }
            if (fqcn.equals("BigDecimal") || fqcn.equals("java.math.BigDecimal")) {
                return Float.TYPE;
            }
            if (fqcn.equals("BigInteger") || fqcn.equals("java.math.BigInteger")) {
                return Integer.TYPE;
            }
            if (fqcn.equals("java.lang.Object")) {
                return null;
            }
            if (fqcn.startsWith("java.lang.")) {
                if (fqcn.equals("java.lang.Integer") || fqcn.equals("java.lang.Short") || fqcn.equals("java.lang.Byte") || fqcn.equals("java.lang.Long")) {
                    return Integer.TYPE;
                }
                if (fqcn.equals("java.lang.Float") || fqcn.equals("java.lang.Double")) {
                    return Float.TYPE;
                }
                return null;
            }
            if (fqcn.equals("byte")) {
                return Byte.TYPE;
            }
            if (fqcn.equals("short")) {
                return Short.TYPE;
            }
            return null;
        }

        public Expression getArgument(int argument) {
            if (!(this.mTargetNode instanceof MethodInvocation)) {
                return null;
            }
            MethodInvocation call = (MethodInvocation)this.mTargetNode;
            StrictListAccessor args = call.astArguments();
            if (argument >= args.size()) {
                return null;
            }
            Iterator iterator = args.iterator();
            int index = 0;
            while (iterator.hasNext()) {
                Expression arg = (Expression)iterator.next();
                if (index++ != argument) continue;
                return arg;
            }
            return null;
        }

        public boolean visitNode(Node node) {
            return this.mDone || super.visitNode(node);
        }

        public boolean visitVariableReference(VariableReference node) {
            if (node.astIdentifier().astValue().equals("R") && node.getParent() instanceof Select && node.getParent().getParent() instanceof Select) {
                Node current;
                String reference = ((Select)current).astIdentifier().astValue();
                for (current = node.getParent().getParent(); current != this.mTop && !(current instanceof VariableDefinitionEntry); current = current.getParent()) {
                    if (current != this.mTargetNode) continue;
                    this.mName = reference;
                    this.mDone = true;
                    return false;
                }
                if (current instanceof VariableDefinitionEntry) {
                    VariableDefinitionEntry entry = (VariableDefinitionEntry)current;
                    String variable = entry.astName().astValue();
                    this.mMap.put(variable, reference);
                }
            }
            return false;
        }

        @Nullable
        private Expression getTargetArgument() {
            Iterator iterator;
            if (this.mTargetNode instanceof MethodInvocation) {
                iterator = ((MethodInvocation)this.mTargetNode).astArguments().iterator();
            } else if (this.mTargetNode instanceof ConstructorInvocation) {
                iterator = ((ConstructorInvocation)this.mTargetNode).astArguments().iterator();
            } else {
                return null;
            }
            for (int i = 0; i < this.mArgIndex && iterator.hasNext(); ++i) {
                iterator.next();
            }
            if (iterator.hasNext()) {
                Expression next = (Expression)iterator.next();
                if (next != null && this.mContext != null && iterator.hasNext()) {
                    JavaParser.TypeDescriptor type = this.mContext.getType((Node)next);
                    if (StringFormatDetector.isLocaleReference(type)) {
                        next = (Expression)iterator.next();
                    } else if (type == null && next.toString().startsWith("Locale.")) {
                        next = (Expression)iterator.next();
                    }
                }
                return next;
            }
            return null;
        }

        public boolean visitMethodInvocation(MethodInvocation node) {
            Expression arg;
            if (node == this.mTargetNode && (arg = this.getTargetArgument()) instanceof VariableReference) {
                VariableReference reference = (VariableReference)arg;
                String variable = reference.astIdentifier().astValue();
                this.mName = this.mMap.get(variable);
                this.mDone = true;
                return true;
            }
            return super.visitMethodInvocation(node);
        }

        public boolean visitConstructorInvocation(ConstructorInvocation node) {
            Expression arg;
            if (node == this.mTargetNode && (arg = this.getTargetArgument()) instanceof VariableReference) {
                VariableReference reference = (VariableReference)arg;
                String variable = reference.astIdentifier().astValue();
                this.mName = this.mMap.get(variable);
                this.mDone = true;
                return true;
            }
            return super.visitConstructorInvocation(node);
        }

        public boolean visitVariableDefinitionEntry(VariableDefinitionEntry node) {
            String name = node.astName().astValue();
            Expression rhs = node.astInitializer();
            Class<?> type = this.getType(rhs);
            if (type != null) {
                this.mTypes.put(name, type);
            } else if (rhs != this.mTargetNode) {
                this.mTypes.remove(name);
            }
            return super.visitVariableDefinitionEntry(node);
        }

        private Class<?> getType(Expression expression) {
            JavaParser.TypeDescriptor type;
            if (expression == null) {
                return null;
            }
            if (expression instanceof VariableReference) {
                VariableReference reference = (VariableReference)expression;
                String variable = reference.astIdentifier().astValue();
                Class<?> type2 = this.mTypes.get(variable);
                if (type2 != null) {
                    return type2;
                }
            } else if (expression instanceof MethodInvocation) {
                MethodInvocation method = (MethodInvocation)expression;
                String methodName = method.astName().astValue();
                if (methodName.equals("getString")) {
                    return String.class;
                }
            } else {
                if (expression instanceof StringLiteral) {
                    return String.class;
                }
                if (expression instanceof IntegralLiteral) {
                    return Integer.TYPE;
                }
                if (expression instanceof FloatingPointLiteral) {
                    return Float.TYPE;
                }
                if (expression instanceof CharLiteral) {
                    return Character.TYPE;
                }
                if (expression instanceof BooleanLiteral) {
                    return Boolean.TYPE;
                }
                if (expression instanceof NullLiteral) {
                    return Object.class;
                }
            }
            if (this.mContext != null && (type = this.mContext.getType((Node)expression)) != null) {
                Class<?> typeClass = StringTracker.getTypeClass(type);
                if (typeClass != null) {
                    return typeClass;
                }
                return Object.class;
            }
            return null;
        }
    }
}

