/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Collection;
import java.util.Collections;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MissingIdDetector
extends LayoutDetector {
    public static final Issue ISSUE = Issue.create((String)"MissingId", (String)"Fragments should specify an `id` or `tag`", (String)"Ensures that XML tags like `<fragment>` specify an `id` or `tag` attribute", (String)"If you do not specify an android:id or an android:tag attribute on a <fragment> element, then if the activity is restarted (for example for an orientation rotation) you may lose state. From the fragment documentation:\n\n\"Each fragment requires a unique identifier that the system can use to restore the fragment if the activity is restarted (and which you can use to capture the fragment to perform transactions, such as remove it). * Supply the android:id attribute with a unique ID.\n* Supply the android:tag attribute with a unique string.\nIf you provide neither of the previous two, the system uses the ID of the container view.", (Category)Category.CORRECTNESS, (int)5, (Severity)Severity.WARNING, (Implementation)new Implementation(MissingIdDetector.class, Scope.RESOURCE_FILE_SCOPE)).addMoreInfo("http://developer.android.com/guide/components/fragments.html");

    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    public Collection<String> getApplicableElements() {
        return Collections.singletonList("fragment");
    }

    public void visitElement(@NonNull XmlContext context, @NonNull Element element) {
        if (!element.hasAttributeNS("http://schemas.android.com/apk/res/android", "id") && !element.hasAttributeNS("http://schemas.android.com/apk/res/android", "tag")) {
            context.report(ISSUE, (Node)element, context.getLocation((Node)element), "This <fragment> tag should specify an id or a tag to preserve state across activity restarts", null);
        }
    }
}

