/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Collection;
import java.util.Collections;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PxUsageDetector
extends LayoutDetector {
    private static final Implementation IMPLEMENTATION = new Implementation(PxUsageDetector.class, Scope.RESOURCE_FILE_SCOPE);
    public static final Issue PX_ISSUE = Issue.create((String)"PxUsage", (String)"Using 'px' dimension", (String)"Looks for use of the `px` dimension", (String)"For performance reasons and to keep the code simpler, the Android system uses pixels as the standard unit for expressing dimension or coordinate values. That means that the dimensions of a view are always expressed in the code using pixels, but always based on the current screen density. For instance, if `myView.getWidth()` returns 10, the view is 10 pixels wide on the current screen, but on a device with a higher density screen, the value returned might be 15. If you use pixel values in your application code to work with bitmaps that are not pre-scaled for the current screen density, you might need to scale the pixel values that you use in your code to match the un-scaled bitmap source.", (Category)Category.CORRECTNESS, (int)2, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION).addMoreInfo("http://developer.android.com/guide/practices/screens_support.html#screen-independence");
    public static final Issue IN_MM_ISSUE = Issue.create((String)"InOrMmUsage", (String)"Using `mm` or `in` dimensions", (String)"Looks for use of the `mm` or `in` dimensions", (String)"Avoid using `mm` (millimeters) or `in` (inches) as the unit for dimensions.\n\nWhile it should work in principle, unfortunately many devices do not report the correct true physical density, which means that the dimension calculations won't work correctly. You are better off using `dp` (and for font sizes, `sp`.)", (Category)Category.CORRECTNESS, (int)4, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION);
    public static final Issue DP_ISSUE = Issue.create((String)"SpUsage", (String)"Using `dp` instead of `sp` for text sizes", (String)"Looks for uses of `dp` instead of `sp` dimensions for text sizes", (String)"When setting text sizes, you should normally use `sp`, or \"scale-independent pixels\". This is like the `dp` unit, but it is also scaled by the user's font size preference. It is recommend you use this unit when specifying font sizes, so they will be adjusted for both the screen density and the user's preference.\n\nThere *are* cases where you might need to use `dp`; typically this happens when the text is in a container with a specific dp-size. This will prevent the text from spilling outside the container. Note however that this means that the user's font size settings are not respected, so consider adjusting the layout itself to be more flexible.", (Category)Category.CORRECTNESS, (int)3, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION).addMoreInfo("http://developer.android.com/training/multiscreen/screendensities.html");
    public static final Issue SMALL_SP_ISSUE = Issue.create((String)"SmallSp", (String)"Text size is too small", (String)"Looks for text sizes that are too small", (String)"Avoid using sizes smaller than 12sp.", (Category)Category.USABILITY, (int)4, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION);

    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    public boolean appliesTo(@NonNull ResourceFolderType folderType) {
        return folderType == ResourceFolderType.LAYOUT || folderType == ResourceFolderType.VALUES;
    }

    public Collection<String> getApplicableAttributes() {
        return ALL;
    }

    @Nullable
    public Collection<String> getApplicableElements() {
        return Collections.singletonList("style");
    }

    public void visitAttribute(@NonNull XmlContext context, @NonNull Attr attribute) {
        if (context.getResourceFolderType() != ResourceFolderType.LAYOUT) {
            return;
        }
        String value = attribute.getValue();
        if (value.endsWith("px") && value.matches("\\d+px")) {
            if (value.charAt(0) == '0' || value.equals("1px")) {
                return;
            }
            if (context.isEnabled(PX_ISSUE)) {
                context.report(PX_ISSUE, (Node)attribute, context.getLocation((Node)attribute), "Avoid using \"px\" as units; use \"dp\" instead", null);
            }
        } else if (value.endsWith("mm") && value.matches("\\d+mm") || value.endsWith("in") && value.matches("\\d+in")) {
            if (value.charAt(0) == '0') {
                return;
            }
            if (context.isEnabled(IN_MM_ISSUE)) {
                String unit = value.substring(value.length() - 2);
                context.report(IN_MM_ISSUE, (Node)attribute, context.getLocation((Node)attribute), String.format("Avoid using \"%1$s\" as units (it does not work accurately on all devices); use \"dp\" instead", unit), null);
            }
        } else if (value.endsWith("sp") && ("textSize".equals(attribute.getLocalName()) || "layout_height".equals(attribute.getLocalName())) && value.matches("\\d+sp")) {
            int size = PxUsageDetector.getSize(value);
            if (size > 0 && size < 12) {
                context.report(SMALL_SP_ISSUE, (Node)attribute, context.getLocation((Node)attribute), String.format("Avoid using sizes smaller than 12sp: %1$s", value), null);
            }
        } else if ("textSize".equals(attribute.getLocalName()) && (value.endsWith("dp") || value.endsWith("dip")) && value.matches("\\d+di?p") && context.isEnabled(DP_ISSUE)) {
            context.report(DP_ISSUE, (Node)attribute, context.getLocation((Node)attribute), "Should use \"sp\" instead of \"dp\" for text sizes", null);
        }
    }

    private static int getSize(String text) {
        assert (text.matches("\\d+sp")) : text;
        return Integer.parseInt(text.substring(0, text.length() - 2));
    }

    public void visitElement(@NonNull XmlContext context, @NonNull Element element) {
        if (context.getResourceFolderType() != ResourceFolderType.VALUES) {
            return;
        }
        assert (element.getTagName().equals("style"));
        NodeList itemNodes = element.getChildNodes();
        int nodeCount = itemNodes.getLength();
        for (int j = 0; j < nodeCount; ++j) {
            Node item = itemNodes.item(j);
            if (item.getNodeType() != 1 || !"item".equals(item.getNodeName())) continue;
            Element itemElement = (Element)item;
            NodeList childNodes = item.getChildNodes();
            int n = childNodes.getLength();
            for (int i = 0; i < n; ++i) {
                Node child = childNodes.item(i);
                if (child.getNodeType() != 3) {
                    return;
                }
                PxUsageDetector.checkStyleItem(context, itemElement, child);
            }
        }
    }

    private static void checkStyleItem(XmlContext context, Element item, Node textNode) {
        String text = textNode.getNodeValue();
        for (int j = text.length() - 1; j > 0; --j) {
            int size;
            String name;
            char c = text.charAt(j);
            if (Character.isWhitespace(c)) continue;
            if (c == 'x' && text.charAt(j - 1) == 'p') {
                if (!(text = text.trim()).matches("\\d+px") || text.charAt(0) == '0' || text.equals("1px") || !context.isEnabled(PX_ISSUE)) break;
                context.report(PX_ISSUE, (Node)item, context.getLocation(textNode), "Avoid using \"px\" as units; use \"dp\" instead", null);
                break;
            }
            if (c == 'm' && text.charAt(j - 1) == 'm' || c == 'n' && text.charAt(j - 1) == 'i') {
                text = text.trim();
                String unit = text.substring(text.length() - 2);
                if (!text.matches("\\d+" + unit) || text.charAt(0) == '0' || !context.isEnabled(IN_MM_ISSUE)) break;
                context.report(IN_MM_ISSUE, (Node)item, context.getLocation(textNode), String.format("Avoid using \"%1$s\" as units (it does not work accurately on all devices); use \"dp\" instead", unit), null);
                break;
            }
            if (c == 'p' && (text.charAt(j - 1) == 'd' || text.charAt(j - 1) == 'i')) {
                text = text.trim();
                String name2 = item.getAttribute("name");
                if (!name2.equals("textSize") && !name2.equals("android:textSize") || !text.matches("\\d+di?p") || !context.isEnabled(DP_ISSUE)) break;
                context.report(DP_ISSUE, (Node)item, context.getLocation(textNode), "Should use \"sp\" instead of \"dp\" for text sizes", null);
                break;
            }
            if (c != 'p' || text.charAt(j - 1) != 's' || !"textSize".equals(name = item.getAttribute("name")) && !"layout_height".equals(name)) break;
            text = text.trim();
            String unit = text.substring(text.length() - 2);
            if (!text.matches("\\d+" + unit) || !context.isEnabled(SMALL_SP_ISSUE) || (size = PxUsageDetector.getSize(text)) <= 0 || size >= 12) break;
            context.report(SMALL_SP_ISSUE, (Node)item, context.getLocation(textNode), String.format("Avoid using sizes smaller than 12sp: %1$s", text), null);
            break;
        }
    }
}

