/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.libs.org.parboiled.trees;

import java.util.HashSet;
import java.util.Set;
import lombok.ast.libs.org.parboiled.Node;
import lombok.ast.libs.org.parboiled.matchers.Matcher;
import lombok.ast.libs.org.parboiled.matchers.ProxyMatcher;
import lombok.ast.libs.org.parboiled.trees.Filter;
import lombok.ast.libs.org.parboiled.trees.GraphUtils;
import lombok.ast.libs.org.parboiled.trees.Printability;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Filters {
    public static <V> Filter<Node<V>> skipEmptyOptionalsAndZeroOrMores() {
        return new Filter<Node<V>>(){
            private final Filter<Node<V>> skipEmptyOptionals = Filters.skipEmptyOptionals();
            private final Filter<Node<V>> skipEmptyZeroOrMores = Filters.skipEmptyZeroOrMores();

            @Override
            public Printability apply(Node<V> node) {
                return this.skipEmptyOptionals.apply(node) == Printability.Skip || this.skipEmptyZeroOrMores.apply(node) == Printability.Skip ? Printability.Skip : Printability.PrintAndDescend;
            }
        };
    }

    public static <V> Filter<Node<V>> skipEmptyOptionals() {
        return new Filter<Node<V>>(){

            @Override
            public Printability apply(Node<V> node) {
                return GraphUtils.hasChildren(node) || node.getEndIndex() != node.getStartIndex() || !"Optional".equals(node.getLabel()) ? Printability.PrintAndDescend : Printability.Skip;
            }
        };
    }

    public static <V> Filter<Node<V>> skipEmptyZeroOrMores() {
        return new Filter<Node<V>>(){

            @Override
            public Printability apply(Node<V> node) {
                return GraphUtils.hasChildren(node) || node.getEndIndex() != node.getStartIndex() || !"ZeroOrMore".equals(node.getLabel()) ? Printability.PrintAndDescend : Printability.Skip;
            }
        };
    }

    public static <V> Filter<Matcher<V>> preventLoops() {
        return new Filter<Matcher<V>>(){
            private final Set<Matcher<V>> visited = new HashSet();

            @Override
            public Printability apply(Matcher<V> node) {
                if (this.visited.contains(node = ProxyMatcher.unwrap(node))) {
                    return Printability.Print;
                }
                this.visited.add(node);
                return Printability.PrintAndDescend;
            }
        };
    }
}

