/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.libs.org.parboiled.support;

import java.util.Arrays;
import lombok.ast.libs.org.parboiled.google.base.Preconditions;
import lombok.ast.libs.org.parboiled.support.InputBuffer;
import org.jetbrains.annotations.NotNull;

public class DefaultInputBuffer
implements InputBuffer {
    private final int length;
    private final char[] buffer;
    private final int[] newlines;

    public DefaultInputBuffer(@NotNull String inputText) {
        if (inputText == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.support.DefaultInputBuffer.<init>(...) corresponds to @NotNull parameter and must not be null");
        }
        this(inputText.toCharArray());
    }

    public DefaultInputBuffer(@NotNull char[] buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.support.DefaultInputBuffer.<init>(...) corresponds to @NotNull parameter and must not be null");
        }
        this.buffer = buffer;
        this.length = buffer.length;
        this.newlines = DefaultInputBuffer.extractNewlines(buffer);
    }

    private static int[] extractNewlines(char[] buffer) {
        int count = 0;
        int length = buffer.length;
        for (int i = 0; i < length; ++i) {
            if (buffer[i] != '\n') continue;
            ++count;
        }
        int[] newlines = new int[count];
        count = 0;
        for (int i = 0; i < length; ++i) {
            if (buffer[i] != '\n') continue;
            newlines[count++] = i;
        }
        return newlines;
    }

    public int getLength() {
        return this.length;
    }

    public char charAt(int index) {
        return 0 <= index && index < this.buffer.length ? this.buffer[index] : (char)'\uffff';
    }

    public InputBuffer.Position getPosition(int index) {
        Preconditions.checkArgument(0 <= index && index <= this.length);
        int j = Arrays.binarySearch(this.newlines, index);
        int line = j >= 0 ? j : -(j + 1);
        int column = index - (line > 0 ? this.newlines[line - 1] : -1);
        return new InputBuffer.Position(line + 1, column);
    }

    public String extractLine(int lineNumber) {
        int end;
        Preconditions.checkArgument(0 < lineNumber && lineNumber <= this.newlines.length + 1);
        int start = lineNumber > 1 ? this.newlines[lineNumber - 2] + 1 : 0;
        int n = end = lineNumber <= this.newlines.length ? this.newlines[lineNumber - 1] : this.length;
        if (this.charAt(end - 1) == '\r') {
            --end;
        }
        return this.extract(start, end);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public String extract(int start, int end) {
        if (start < 0) {
            start = 0;
        }
        if (end >= this.buffer.length) {
            end = this.buffer.length;
        }
        if (end <= start) {
            return "";
        }
        String string = new String(this.buffer, start, end - start);
        String string2 = string;
        if (string == null) throw new IllegalStateException("@NotNull method org.parboiled.support.DefaultInputBuffer.extract must not return null");
        return string2;
    }
}

