/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.QueryStringSigner;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.DefaultErrorResponseHandler;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.StaxResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduce;
import com.amazonaws.services.elasticmapreduce.model.AddInstanceGroupsRequest;
import com.amazonaws.services.elasticmapreduce.model.AddInstanceGroupsResult;
import com.amazonaws.services.elasticmapreduce.model.AddJobFlowStepsRequest;
import com.amazonaws.services.elasticmapreduce.model.DescribeJobFlowsRequest;
import com.amazonaws.services.elasticmapreduce.model.DescribeJobFlowsResult;
import com.amazonaws.services.elasticmapreduce.model.ModifyInstanceGroupsRequest;
import com.amazonaws.services.elasticmapreduce.model.RunJobFlowRequest;
import com.amazonaws.services.elasticmapreduce.model.RunJobFlowResult;
import com.amazonaws.services.elasticmapreduce.model.SetTerminationProtectionRequest;
import com.amazonaws.services.elasticmapreduce.model.SetVisibleToAllUsersRequest;
import com.amazonaws.services.elasticmapreduce.model.TerminateJobFlowsRequest;
import com.amazonaws.services.elasticmapreduce.model.transform.AddInstanceGroupsRequestMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.AddInstanceGroupsResultStaxUnmarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.AddJobFlowStepsRequestMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.DescribeJobFlowsRequestMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.DescribeJobFlowsResultStaxUnmarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.InternalServerErrorExceptionUnmarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.ModifyInstanceGroupsRequestMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.RunJobFlowRequestMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.RunJobFlowResultStaxUnmarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.SetTerminationProtectionRequestMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.SetVisibleToAllUsersRequestMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.TerminateJobFlowsRequestMarshaller;
import com.amazonaws.transform.StandardErrorUnmarshaller;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonElasticMapReduceClient
extends AmazonWebServiceClient
implements AmazonElasticMapReduce {
    private AWSCredentialsProvider awsCredentialsProvider;
    protected final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();
    private QueryStringSigner signer;

    public AmazonElasticMapReduceClient() {
        this(new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AmazonElasticMapReduceClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonElasticMapReduceClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonElasticMapReduceClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonElasticMapReduceClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AmazonElasticMapReduceClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers.add(new InternalServerErrorExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new StandardErrorUnmarshaller());
        this.setEndpoint("elasticmapreduce.amazonaws.com");
        this.signer = new QueryStringSigner();
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandlers.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/elasticmapreduce/request.handlers"));
    }

    @Override
    public void setVisibleToAllUsers(SetVisibleToAllUsersRequest setVisibleToAllUsersRequest) throws AmazonServiceException, AmazonClientException {
        Request<SetVisibleToAllUsersRequest> request = new SetVisibleToAllUsersRequestMarshaller().marshall(setVisibleToAllUsersRequest);
        this.invoke(request, null);
    }

    @Override
    public AddInstanceGroupsResult addInstanceGroups(AddInstanceGroupsRequest addInstanceGroupsRequest) throws AmazonServiceException, AmazonClientException {
        Request<AddInstanceGroupsRequest> request = new AddInstanceGroupsRequestMarshaller().marshall(addInstanceGroupsRequest);
        return this.invoke(request, new AddInstanceGroupsResultStaxUnmarshaller());
    }

    @Override
    public void addJobFlowSteps(AddJobFlowStepsRequest addJobFlowStepsRequest) throws AmazonServiceException, AmazonClientException {
        Request<AddJobFlowStepsRequest> request = new AddJobFlowStepsRequestMarshaller().marshall(addJobFlowStepsRequest);
        this.invoke(request, null);
    }

    @Override
    public void terminateJobFlows(TerminateJobFlowsRequest terminateJobFlowsRequest) throws AmazonServiceException, AmazonClientException {
        Request<TerminateJobFlowsRequest> request = new TerminateJobFlowsRequestMarshaller().marshall(terminateJobFlowsRequest);
        this.invoke(request, null);
    }

    @Override
    public DescribeJobFlowsResult describeJobFlows(DescribeJobFlowsRequest describeJobFlowsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeJobFlowsRequest> request = new DescribeJobFlowsRequestMarshaller().marshall(describeJobFlowsRequest);
        return this.invoke(request, new DescribeJobFlowsResultStaxUnmarshaller());
    }

    @Override
    public void setTerminationProtection(SetTerminationProtectionRequest setTerminationProtectionRequest) throws AmazonServiceException, AmazonClientException {
        Request<SetTerminationProtectionRequest> request = new SetTerminationProtectionRequestMarshaller().marshall(setTerminationProtectionRequest);
        this.invoke(request, null);
    }

    @Override
    public RunJobFlowResult runJobFlow(RunJobFlowRequest runJobFlowRequest) throws AmazonServiceException, AmazonClientException {
        Request<RunJobFlowRequest> request = new RunJobFlowRequestMarshaller().marshall(runJobFlowRequest);
        return this.invoke(request, new RunJobFlowResultStaxUnmarshaller());
    }

    @Override
    public void modifyInstanceGroups(ModifyInstanceGroupsRequest modifyInstanceGroupsRequest) throws AmazonServiceException, AmazonClientException {
        Request<ModifyInstanceGroupsRequest> request = new ModifyInstanceGroupsRequestMarshaller().marshall(modifyInstanceGroupsRequest);
        this.invoke(request, null);
    }

    @Override
    public DescribeJobFlowsResult describeJobFlows() throws AmazonServiceException, AmazonClientException {
        return this.describeJobFlows(new DescribeJobFlowsRequest());
    }

    @Override
    public void modifyInstanceGroups() throws AmazonServiceException, AmazonClientException {
        this.modifyInstanceGroups(new ModifyInstanceGroupsRequest());
    }

    @Override
    protected String getServiceAbbreviation() {
        return "elasticmapreduce";
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, Unmarshaller<X, StaxUnmarshallerContext> unmarshaller) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        for (Map.Entry<String, String> entry : request.getOriginalRequest().copyPrivateRequestParameters().entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        AWSCredentials credentials = this.awsCredentialsProvider.getCredentials();
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        ExecutionContext executionContext = this.createExecutionContext();
        executionContext.setSigner(this.signer);
        executionContext.setCredentials(credentials);
        StaxResponseHandler<X> responseHandler = new StaxResponseHandler<X>(unmarshaller);
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (X)this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

