/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.datapipeline.model.InstanceIdentity;
import com.amazonaws.services.datapipeline.model.PollForTaskRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PollForTaskRequestMarshaller
implements Marshaller<Request<PollForTaskRequest>, PollForTaskRequest> {
    @Override
    public Request<PollForTaskRequest> marshall(PollForTaskRequest pollForTaskRequest) {
        if (pollForTaskRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PollForTaskRequest> request = new DefaultRequest<PollForTaskRequest>(pollForTaskRequest, "DataPipeline");
        String target = "DataPipeline.PollForTask";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.1");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "";
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        try {
            InstanceIdentity instanceIdentity;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (pollForTaskRequest.getWorkerGroup() != null) {
                jsonWriter.key("workerGroup").value(pollForTaskRequest.getWorkerGroup());
            }
            if (pollForTaskRequest.getHostname() != null) {
                jsonWriter.key("hostname").value(pollForTaskRequest.getHostname());
            }
            if ((instanceIdentity = pollForTaskRequest.getInstanceIdentity()) != null) {
                jsonWriter.key("instanceIdentity");
                jsonWriter.object();
                if (instanceIdentity.getDocument() != null) {
                    jsonWriter.key("document").value(instanceIdentity.getDocument());
                }
                if (instanceIdentity.getSignature() != null) {
                    jsonWriter.key("signature").value(instanceIdentity.getSignature());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes("UTF-8");
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }

    private String getString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }
}

