/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.wafv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.wafv2.model.Tag;
import com.amazonaws.services.wafv2.model.transform.MobileSdkReleaseMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class MobileSdkRelease
implements Serializable,
Cloneable,
StructuredPojo {
    private String releaseVersion;
    private Date timestamp;
    private String releaseNotes;
    private List<Tag> tags;

    public void setReleaseVersion(String releaseVersion) {
        this.releaseVersion = releaseVersion;
    }

    public String getReleaseVersion() {
        return this.releaseVersion;
    }

    public MobileSdkRelease withReleaseVersion(String releaseVersion) {
        this.setReleaseVersion(releaseVersion);
        return this;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public MobileSdkRelease withTimestamp(Date timestamp) {
        this.setTimestamp(timestamp);
        return this;
    }

    public void setReleaseNotes(String releaseNotes) {
        this.releaseNotes = releaseNotes;
    }

    public String getReleaseNotes() {
        return this.releaseNotes;
    }

    public MobileSdkRelease withReleaseNotes(String releaseNotes) {
        this.setReleaseNotes(releaseNotes);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public MobileSdkRelease withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public MobileSdkRelease withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getReleaseVersion() != null) {
            sb.append("ReleaseVersion: ").append(this.getReleaseVersion()).append(",");
        }
        if (this.getTimestamp() != null) {
            sb.append("Timestamp: ").append(this.getTimestamp()).append(",");
        }
        if (this.getReleaseNotes() != null) {
            sb.append("ReleaseNotes: ").append(this.getReleaseNotes()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MobileSdkRelease)) {
            return false;
        }
        MobileSdkRelease other = (MobileSdkRelease)obj;
        if (other.getReleaseVersion() == null ^ this.getReleaseVersion() == null) {
            return false;
        }
        if (other.getReleaseVersion() != null && !other.getReleaseVersion().equals(this.getReleaseVersion())) {
            return false;
        }
        if (other.getTimestamp() == null ^ this.getTimestamp() == null) {
            return false;
        }
        if (other.getTimestamp() != null && !other.getTimestamp().equals(this.getTimestamp())) {
            return false;
        }
        if (other.getReleaseNotes() == null ^ this.getReleaseNotes() == null) {
            return false;
        }
        if (other.getReleaseNotes() != null && !other.getReleaseNotes().equals(this.getReleaseNotes())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getReleaseVersion() == null ? 0 : this.getReleaseVersion().hashCode());
        hashCode = 31 * hashCode + (this.getTimestamp() == null ? 0 : this.getTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getReleaseNotes() == null ? 0 : this.getReleaseNotes().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public MobileSdkRelease clone() {
        try {
            return (MobileSdkRelease)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MobileSdkReleaseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

