/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.verifiedpermissions.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.verifiedpermissions.model.CognitoGroupConfigurationDetail;
import com.amazonaws.services.verifiedpermissions.model.transform.CognitoUserPoolConfigurationDetailMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CognitoUserPoolConfigurationDetail
implements Serializable,
Cloneable,
StructuredPojo {
    private String userPoolArn;
    private List<String> clientIds;
    private String issuer;
    private CognitoGroupConfigurationDetail groupConfiguration;

    public void setUserPoolArn(String userPoolArn) {
        this.userPoolArn = userPoolArn;
    }

    public String getUserPoolArn() {
        return this.userPoolArn;
    }

    public CognitoUserPoolConfigurationDetail withUserPoolArn(String userPoolArn) {
        this.setUserPoolArn(userPoolArn);
        return this;
    }

    public List<String> getClientIds() {
        return this.clientIds;
    }

    public void setClientIds(Collection<String> clientIds) {
        if (clientIds == null) {
            this.clientIds = null;
            return;
        }
        this.clientIds = new ArrayList<String>(clientIds);
    }

    public CognitoUserPoolConfigurationDetail withClientIds(String ... clientIds) {
        if (this.clientIds == null) {
            this.setClientIds(new ArrayList<String>(clientIds.length));
        }
        for (String ele : clientIds) {
            this.clientIds.add(ele);
        }
        return this;
    }

    public CognitoUserPoolConfigurationDetail withClientIds(Collection<String> clientIds) {
        this.setClientIds(clientIds);
        return this;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public CognitoUserPoolConfigurationDetail withIssuer(String issuer) {
        this.setIssuer(issuer);
        return this;
    }

    public void setGroupConfiguration(CognitoGroupConfigurationDetail groupConfiguration) {
        this.groupConfiguration = groupConfiguration;
    }

    public CognitoGroupConfigurationDetail getGroupConfiguration() {
        return this.groupConfiguration;
    }

    public CognitoUserPoolConfigurationDetail withGroupConfiguration(CognitoGroupConfigurationDetail groupConfiguration) {
        this.setGroupConfiguration(groupConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUserPoolArn() != null) {
            sb.append("UserPoolArn: ").append(this.getUserPoolArn()).append(",");
        }
        if (this.getClientIds() != null) {
            sb.append("ClientIds: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getIssuer() != null) {
            sb.append("Issuer: ").append(this.getIssuer()).append(",");
        }
        if (this.getGroupConfiguration() != null) {
            sb.append("GroupConfiguration: ").append(this.getGroupConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CognitoUserPoolConfigurationDetail)) {
            return false;
        }
        CognitoUserPoolConfigurationDetail other = (CognitoUserPoolConfigurationDetail)obj;
        if (other.getUserPoolArn() == null ^ this.getUserPoolArn() == null) {
            return false;
        }
        if (other.getUserPoolArn() != null && !other.getUserPoolArn().equals(this.getUserPoolArn())) {
            return false;
        }
        if (other.getClientIds() == null ^ this.getClientIds() == null) {
            return false;
        }
        if (other.getClientIds() != null && !other.getClientIds().equals(this.getClientIds())) {
            return false;
        }
        if (other.getIssuer() == null ^ this.getIssuer() == null) {
            return false;
        }
        if (other.getIssuer() != null && !other.getIssuer().equals(this.getIssuer())) {
            return false;
        }
        if (other.getGroupConfiguration() == null ^ this.getGroupConfiguration() == null) {
            return false;
        }
        return other.getGroupConfiguration() == null || other.getGroupConfiguration().equals(this.getGroupConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUserPoolArn() == null ? 0 : this.getUserPoolArn().hashCode());
        hashCode = 31 * hashCode + (this.getClientIds() == null ? 0 : this.getClientIds().hashCode());
        hashCode = 31 * hashCode + (this.getIssuer() == null ? 0 : this.getIssuer().hashCode());
        hashCode = 31 * hashCode + (this.getGroupConfiguration() == null ? 0 : this.getGroupConfiguration().hashCode());
        return hashCode;
    }

    public CognitoUserPoolConfigurationDetail clone() {
        try {
            return (CognitoUserPoolConfigurationDetail)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CognitoUserPoolConfigurationDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

