/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * An SSM document required by the current document.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DocumentRequires" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DocumentRequires implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The name of the required SSM document. The name can be an Amazon Resource Name (ARN).
     * </p>
     */
    private String name;
    /**
     * <p>
     * The document version required by the current document.
     * </p>
     */
    private String version;
    /**
     * <p>
     * The document type of the required SSM document.
     * </p>
     */
    private String requireType;
    /**
     * <p>
     * An optional field specifying the version of the artifact associated with the document. For example, 12.6. This
     * value is unique across all versions of a document, and can't be changed.
     * </p>
     */
    private String versionName;

    /**
     * <p>
     * The name of the required SSM document. The name can be an Amazon Resource Name (ARN).
     * </p>
     * 
     * @param name
     *        The name of the required SSM document. The name can be an Amazon Resource Name (ARN).
     */

    public void setName(String name) {
        this.name = name;
    }

    /**
     * <p>
     * The name of the required SSM document. The name can be an Amazon Resource Name (ARN).
     * </p>
     * 
     * @return The name of the required SSM document. The name can be an Amazon Resource Name (ARN).
     */

    public String getName() {
        return this.name;
    }

    /**
     * <p>
     * The name of the required SSM document. The name can be an Amazon Resource Name (ARN).
     * </p>
     * 
     * @param name
     *        The name of the required SSM document. The name can be an Amazon Resource Name (ARN).
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DocumentRequires withName(String name) {
        setName(name);
        return this;
    }

    /**
     * <p>
     * The document version required by the current document.
     * </p>
     * 
     * @param version
     *        The document version required by the current document.
     */

    public void setVersion(String version) {
        this.version = version;
    }

    /**
     * <p>
     * The document version required by the current document.
     * </p>
     * 
     * @return The document version required by the current document.
     */

    public String getVersion() {
        return this.version;
    }

    /**
     * <p>
     * The document version required by the current document.
     * </p>
     * 
     * @param version
     *        The document version required by the current document.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DocumentRequires withVersion(String version) {
        setVersion(version);
        return this;
    }

    /**
     * <p>
     * The document type of the required SSM document.
     * </p>
     * 
     * @param requireType
     *        The document type of the required SSM document.
     */

    public void setRequireType(String requireType) {
        this.requireType = requireType;
    }

    /**
     * <p>
     * The document type of the required SSM document.
     * </p>
     * 
     * @return The document type of the required SSM document.
     */

    public String getRequireType() {
        return this.requireType;
    }

    /**
     * <p>
     * The document type of the required SSM document.
     * </p>
     * 
     * @param requireType
     *        The document type of the required SSM document.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DocumentRequires withRequireType(String requireType) {
        setRequireType(requireType);
        return this;
    }

    /**
     * <p>
     * An optional field specifying the version of the artifact associated with the document. For example, 12.6. This
     * value is unique across all versions of a document, and can't be changed.
     * </p>
     * 
     * @param versionName
     *        An optional field specifying the version of the artifact associated with the document. For example, 12.6.
     *        This value is unique across all versions of a document, and can't be changed.
     */

    public void setVersionName(String versionName) {
        this.versionName = versionName;
    }

    /**
     * <p>
     * An optional field specifying the version of the artifact associated with the document. For example, 12.6. This
     * value is unique across all versions of a document, and can't be changed.
     * </p>
     * 
     * @return An optional field specifying the version of the artifact associated with the document. For example, 12.6.
     *         This value is unique across all versions of a document, and can't be changed.
     */

    public String getVersionName() {
        return this.versionName;
    }

    /**
     * <p>
     * An optional field specifying the version of the artifact associated with the document. For example, 12.6. This
     * value is unique across all versions of a document, and can't be changed.
     * </p>
     * 
     * @param versionName
     *        An optional field specifying the version of the artifact associated with the document. For example, 12.6.
     *        This value is unique across all versions of a document, and can't be changed.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DocumentRequires withVersionName(String versionName) {
        setVersionName(versionName);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getName() != null)
            sb.append("Name: ").append(getName()).append(",");
        if (getVersion() != null)
            sb.append("Version: ").append(getVersion()).append(",");
        if (getRequireType() != null)
            sb.append("RequireType: ").append(getRequireType()).append(",");
        if (getVersionName() != null)
            sb.append("VersionName: ").append(getVersionName());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DocumentRequires == false)
            return false;
        DocumentRequires other = (DocumentRequires) obj;
        if (other.getName() == null ^ this.getName() == null)
            return false;
        if (other.getName() != null && other.getName().equals(this.getName()) == false)
            return false;
        if (other.getVersion() == null ^ this.getVersion() == null)
            return false;
        if (other.getVersion() != null && other.getVersion().equals(this.getVersion()) == false)
            return false;
        if (other.getRequireType() == null ^ this.getRequireType() == null)
            return false;
        if (other.getRequireType() != null && other.getRequireType().equals(this.getRequireType()) == false)
            return false;
        if (other.getVersionName() == null ^ this.getVersionName() == null)
            return false;
        if (other.getVersionName() != null && other.getVersionName().equals(this.getVersionName()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getName() == null) ? 0 : getName().hashCode());
        hashCode = prime * hashCode + ((getVersion() == null) ? 0 : getVersion().hashCode());
        hashCode = prime * hashCode + ((getRequireType() == null) ? 0 : getRequireType().hashCode());
        hashCode = prime * hashCode + ((getVersionName() == null) ? 0 : getVersionName().hashCode());
        return hashCode;
    }

    @Override
    public DocumentRequires clone() {
        try {
            return (DocumentRequires) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.simplesystemsmanagement.model.transform.DocumentRequiresMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
