/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateActivation" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CreateActivationRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * A user-defined description of the resource that you want to register with Systems Manager.
     * </p>
     * <important>
     * <p>
     * Don't enter personally identifiable information in this field.
     * </p>
     * </important>
     */
    private String description;
    /**
     * <p>
     * The name of the registered, managed node as it will appear in the Amazon Web Services Systems Manager console or
     * when you use the Amazon Web Services command line tools to list Systems Manager resources.
     * </p>
     * <important>
     * <p>
     * Don't enter personally identifiable information in this field.
     * </p>
     * </important>
     */
    private String defaultInstanceName;
    /**
     * <p>
     * The name of the Identity and Access Management (IAM) role that you want to assign to the managed node. This IAM
     * role must provide AssumeRole permissions for the Amazon Web Services Systems Manager service principal
     * <code>ssm.amazonaws.com</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-service-role.html">Create an IAM
     * service role for a hybrid and multicloud environment</a> in the <i>Amazon Web Services Systems Manager User
     * Guide</i>.
     * </p>
     * <note>
     * <p>
     * You can't specify an IAM service-linked role for this parameter. You must create a unique role.
     * </p>
     * </note>
     */
    private String iamRole;
    /**
     * <p>
     * Specify the maximum number of managed nodes you want to register. The default value is <code>1</code>.
     * </p>
     */
    private Integer registrationLimit;
    /**
     * <p>
     * The date by which this activation request should expire, in timestamp format, such as "2021-07-07T00:00:00". You
     * can specify a date up to 30 days in advance. If you don't provide an expiration date, the activation code expires
     * in 24 hours.
     * </p>
     */
    private java.util.Date expirationDate;
    /**
     * <p>
     * Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways, such
     * as by purpose, owner, or environment. For example, you might want to tag an activation to identify which servers
     * or virtual machines (VMs) in your on-premises environment you intend to activate. In this case, you could specify
     * the following key-value pairs:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Key=OS,Value=Windows</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Key=Environment,Value=Production</code>
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * When you install SSM Agent on your on-premises servers and VMs, you specify an activation ID and code. When you
     * specify the activation ID and code, tags assigned to the activation are automatically applied to the on-premises
     * servers or VMs.
     * </p>
     * </important>
     * <p>
     * You can't add tags to or delete tags from an existing activation. You can tag your on-premises servers, edge
     * devices, and VMs after they connect to Systems Manager for the first time and are assigned a managed node ID.
     * This means they are listed in the Amazon Web Services Systems Manager console with an ID that is prefixed with
     * "mi-". For information about how to add tags to your managed nodes, see <a>AddTagsToResource</a>. For information
     * about how to remove tags from your managed nodes, see <a>RemoveTagsFromResource</a>.
     * </p>
     */
    private com.amazonaws.internal.SdkInternalList<Tag> tags;
    /**
     * <p>
     * Reserved for internal use.
     * </p>
     */
    private com.amazonaws.internal.SdkInternalList<RegistrationMetadataItem> registrationMetadata;

    /**
     * <p>
     * A user-defined description of the resource that you want to register with Systems Manager.
     * </p>
     * <important>
     * <p>
     * Don't enter personally identifiable information in this field.
     * </p>
     * </important>
     * 
     * @param description
     *        A user-defined description of the resource that you want to register with Systems Manager. </p>
     *        <important>
     *        <p>
     *        Don't enter personally identifiable information in this field.
     *        </p>
     */

    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * <p>
     * A user-defined description of the resource that you want to register with Systems Manager.
     * </p>
     * <important>
     * <p>
     * Don't enter personally identifiable information in this field.
     * </p>
     * </important>
     * 
     * @return A user-defined description of the resource that you want to register with Systems Manager. </p>
     *         <important>
     *         <p>
     *         Don't enter personally identifiable information in this field.
     *         </p>
     */

    public String getDescription() {
        return this.description;
    }

    /**
     * <p>
     * A user-defined description of the resource that you want to register with Systems Manager.
     * </p>
     * <important>
     * <p>
     * Don't enter personally identifiable information in this field.
     * </p>
     * </important>
     * 
     * @param description
     *        A user-defined description of the resource that you want to register with Systems Manager. </p>
     *        <important>
     *        <p>
     *        Don't enter personally identifiable information in this field.
     *        </p>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateActivationRequest withDescription(String description) {
        setDescription(description);
        return this;
    }

    /**
     * <p>
     * The name of the registered, managed node as it will appear in the Amazon Web Services Systems Manager console or
     * when you use the Amazon Web Services command line tools to list Systems Manager resources.
     * </p>
     * <important>
     * <p>
     * Don't enter personally identifiable information in this field.
     * </p>
     * </important>
     * 
     * @param defaultInstanceName
     *        The name of the registered, managed node as it will appear in the Amazon Web Services Systems Manager
     *        console or when you use the Amazon Web Services command line tools to list Systems Manager resources.</p>
     *        <important>
     *        <p>
     *        Don't enter personally identifiable information in this field.
     *        </p>
     */

    public void setDefaultInstanceName(String defaultInstanceName) {
        this.defaultInstanceName = defaultInstanceName;
    }

    /**
     * <p>
     * The name of the registered, managed node as it will appear in the Amazon Web Services Systems Manager console or
     * when you use the Amazon Web Services command line tools to list Systems Manager resources.
     * </p>
     * <important>
     * <p>
     * Don't enter personally identifiable information in this field.
     * </p>
     * </important>
     * 
     * @return The name of the registered, managed node as it will appear in the Amazon Web Services Systems Manager
     *         console or when you use the Amazon Web Services command line tools to list Systems Manager resources.</p>
     *         <important>
     *         <p>
     *         Don't enter personally identifiable information in this field.
     *         </p>
     */

    public String getDefaultInstanceName() {
        return this.defaultInstanceName;
    }

    /**
     * <p>
     * The name of the registered, managed node as it will appear in the Amazon Web Services Systems Manager console or
     * when you use the Amazon Web Services command line tools to list Systems Manager resources.
     * </p>
     * <important>
     * <p>
     * Don't enter personally identifiable information in this field.
     * </p>
     * </important>
     * 
     * @param defaultInstanceName
     *        The name of the registered, managed node as it will appear in the Amazon Web Services Systems Manager
     *        console or when you use the Amazon Web Services command line tools to list Systems Manager resources.</p>
     *        <important>
     *        <p>
     *        Don't enter personally identifiable information in this field.
     *        </p>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateActivationRequest withDefaultInstanceName(String defaultInstanceName) {
        setDefaultInstanceName(defaultInstanceName);
        return this;
    }

    /**
     * <p>
     * The name of the Identity and Access Management (IAM) role that you want to assign to the managed node. This IAM
     * role must provide AssumeRole permissions for the Amazon Web Services Systems Manager service principal
     * <code>ssm.amazonaws.com</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-service-role.html">Create an IAM
     * service role for a hybrid and multicloud environment</a> in the <i>Amazon Web Services Systems Manager User
     * Guide</i>.
     * </p>
     * <note>
     * <p>
     * You can't specify an IAM service-linked role for this parameter. You must create a unique role.
     * </p>
     * </note>
     * 
     * @param iamRole
     *        The name of the Identity and Access Management (IAM) role that you want to assign to the managed node.
     *        This IAM role must provide AssumeRole permissions for the Amazon Web Services Systems Manager service
     *        principal <code>ssm.amazonaws.com</code>. For more information, see <a
     *        href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-service-role.html">Create an IAM
     *        service role for a hybrid and multicloud environment</a> in the <i>Amazon Web Services Systems Manager
     *        User Guide</i>.</p> <note>
     *        <p>
     *        You can't specify an IAM service-linked role for this parameter. You must create a unique role.
     *        </p>
     */

    public void setIamRole(String iamRole) {
        this.iamRole = iamRole;
    }

    /**
     * <p>
     * The name of the Identity and Access Management (IAM) role that you want to assign to the managed node. This IAM
     * role must provide AssumeRole permissions for the Amazon Web Services Systems Manager service principal
     * <code>ssm.amazonaws.com</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-service-role.html">Create an IAM
     * service role for a hybrid and multicloud environment</a> in the <i>Amazon Web Services Systems Manager User
     * Guide</i>.
     * </p>
     * <note>
     * <p>
     * You can't specify an IAM service-linked role for this parameter. You must create a unique role.
     * </p>
     * </note>
     * 
     * @return The name of the Identity and Access Management (IAM) role that you want to assign to the managed node.
     *         This IAM role must provide AssumeRole permissions for the Amazon Web Services Systems Manager service
     *         principal <code>ssm.amazonaws.com</code>. For more information, see <a
     *         href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-service-role.html">Create an
     *         IAM service role for a hybrid and multicloud environment</a> in the <i>Amazon Web Services Systems
     *         Manager User Guide</i>.</p> <note>
     *         <p>
     *         You can't specify an IAM service-linked role for this parameter. You must create a unique role.
     *         </p>
     */

    public String getIamRole() {
        return this.iamRole;
    }

    /**
     * <p>
     * The name of the Identity and Access Management (IAM) role that you want to assign to the managed node. This IAM
     * role must provide AssumeRole permissions for the Amazon Web Services Systems Manager service principal
     * <code>ssm.amazonaws.com</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-service-role.html">Create an IAM
     * service role for a hybrid and multicloud environment</a> in the <i>Amazon Web Services Systems Manager User
     * Guide</i>.
     * </p>
     * <note>
     * <p>
     * You can't specify an IAM service-linked role for this parameter. You must create a unique role.
     * </p>
     * </note>
     * 
     * @param iamRole
     *        The name of the Identity and Access Management (IAM) role that you want to assign to the managed node.
     *        This IAM role must provide AssumeRole permissions for the Amazon Web Services Systems Manager service
     *        principal <code>ssm.amazonaws.com</code>. For more information, see <a
     *        href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-service-role.html">Create an IAM
     *        service role for a hybrid and multicloud environment</a> in the <i>Amazon Web Services Systems Manager
     *        User Guide</i>.</p> <note>
     *        <p>
     *        You can't specify an IAM service-linked role for this parameter. You must create a unique role.
     *        </p>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateActivationRequest withIamRole(String iamRole) {
        setIamRole(iamRole);
        return this;
    }

    /**
     * <p>
     * Specify the maximum number of managed nodes you want to register. The default value is <code>1</code>.
     * </p>
     * 
     * @param registrationLimit
     *        Specify the maximum number of managed nodes you want to register. The default value is <code>1</code>.
     */

    public void setRegistrationLimit(Integer registrationLimit) {
        this.registrationLimit = registrationLimit;
    }

    /**
     * <p>
     * Specify the maximum number of managed nodes you want to register. The default value is <code>1</code>.
     * </p>
     * 
     * @return Specify the maximum number of managed nodes you want to register. The default value is <code>1</code>.
     */

    public Integer getRegistrationLimit() {
        return this.registrationLimit;
    }

    /**
     * <p>
     * Specify the maximum number of managed nodes you want to register. The default value is <code>1</code>.
     * </p>
     * 
     * @param registrationLimit
     *        Specify the maximum number of managed nodes you want to register. The default value is <code>1</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateActivationRequest withRegistrationLimit(Integer registrationLimit) {
        setRegistrationLimit(registrationLimit);
        return this;
    }

    /**
     * <p>
     * The date by which this activation request should expire, in timestamp format, such as "2021-07-07T00:00:00". You
     * can specify a date up to 30 days in advance. If you don't provide an expiration date, the activation code expires
     * in 24 hours.
     * </p>
     * 
     * @param expirationDate
     *        The date by which this activation request should expire, in timestamp format, such as
     *        "2021-07-07T00:00:00". You can specify a date up to 30 days in advance. If you don't provide an expiration
     *        date, the activation code expires in 24 hours.
     */

    public void setExpirationDate(java.util.Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    /**
     * <p>
     * The date by which this activation request should expire, in timestamp format, such as "2021-07-07T00:00:00". You
     * can specify a date up to 30 days in advance. If you don't provide an expiration date, the activation code expires
     * in 24 hours.
     * </p>
     * 
     * @return The date by which this activation request should expire, in timestamp format, such as
     *         "2021-07-07T00:00:00". You can specify a date up to 30 days in advance. If you don't provide an
     *         expiration date, the activation code expires in 24 hours.
     */

    public java.util.Date getExpirationDate() {
        return this.expirationDate;
    }

    /**
     * <p>
     * The date by which this activation request should expire, in timestamp format, such as "2021-07-07T00:00:00". You
     * can specify a date up to 30 days in advance. If you don't provide an expiration date, the activation code expires
     * in 24 hours.
     * </p>
     * 
     * @param expirationDate
     *        The date by which this activation request should expire, in timestamp format, such as
     *        "2021-07-07T00:00:00". You can specify a date up to 30 days in advance. If you don't provide an expiration
     *        date, the activation code expires in 24 hours.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateActivationRequest withExpirationDate(java.util.Date expirationDate) {
        setExpirationDate(expirationDate);
        return this;
    }

    /**
     * <p>
     * Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways, such
     * as by purpose, owner, or environment. For example, you might want to tag an activation to identify which servers
     * or virtual machines (VMs) in your on-premises environment you intend to activate. In this case, you could specify
     * the following key-value pairs:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Key=OS,Value=Windows</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Key=Environment,Value=Production</code>
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * When you install SSM Agent on your on-premises servers and VMs, you specify an activation ID and code. When you
     * specify the activation ID and code, tags assigned to the activation are automatically applied to the on-premises
     * servers or VMs.
     * </p>
     * </important>
     * <p>
     * You can't add tags to or delete tags from an existing activation. You can tag your on-premises servers, edge
     * devices, and VMs after they connect to Systems Manager for the first time and are assigned a managed node ID.
     * This means they are listed in the Amazon Web Services Systems Manager console with an ID that is prefixed with
     * "mi-". For information about how to add tags to your managed nodes, see <a>AddTagsToResource</a>. For information
     * about how to remove tags from your managed nodes, see <a>RemoveTagsFromResource</a>.
     * </p>
     * 
     * @return Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different
     *         ways, such as by purpose, owner, or environment. For example, you might want to tag an activation to
     *         identify which servers or virtual machines (VMs) in your on-premises environment you intend to activate.
     *         In this case, you could specify the following key-value pairs:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Key=OS,Value=Windows</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Key=Environment,Value=Production</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <important>
     *         <p>
     *         When you install SSM Agent on your on-premises servers and VMs, you specify an activation ID and code.
     *         When you specify the activation ID and code, tags assigned to the activation are automatically applied to
     *         the on-premises servers or VMs.
     *         </p>
     *         </important>
     *         <p>
     *         You can't add tags to or delete tags from an existing activation. You can tag your on-premises servers,
     *         edge devices, and VMs after they connect to Systems Manager for the first time and are assigned a managed
     *         node ID. This means they are listed in the Amazon Web Services Systems Manager console with an ID that is
     *         prefixed with "mi-". For information about how to add tags to your managed nodes, see
     *         <a>AddTagsToResource</a>. For information about how to remove tags from your managed nodes, see
     *         <a>RemoveTagsFromResource</a>.
     */

    public java.util.List<Tag> getTags() {
        if (tags == null) {
            tags = new com.amazonaws.internal.SdkInternalList<Tag>();
        }
        return tags;
    }

    /**
     * <p>
     * Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways, such
     * as by purpose, owner, or environment. For example, you might want to tag an activation to identify which servers
     * or virtual machines (VMs) in your on-premises environment you intend to activate. In this case, you could specify
     * the following key-value pairs:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Key=OS,Value=Windows</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Key=Environment,Value=Production</code>
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * When you install SSM Agent on your on-premises servers and VMs, you specify an activation ID and code. When you
     * specify the activation ID and code, tags assigned to the activation are automatically applied to the on-premises
     * servers or VMs.
     * </p>
     * </important>
     * <p>
     * You can't add tags to or delete tags from an existing activation. You can tag your on-premises servers, edge
     * devices, and VMs after they connect to Systems Manager for the first time and are assigned a managed node ID.
     * This means they are listed in the Amazon Web Services Systems Manager console with an ID that is prefixed with
     * "mi-". For information about how to add tags to your managed nodes, see <a>AddTagsToResource</a>. For information
     * about how to remove tags from your managed nodes, see <a>RemoveTagsFromResource</a>.
     * </p>
     * 
     * @param tags
     *        Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different
     *        ways, such as by purpose, owner, or environment. For example, you might want to tag an activation to
     *        identify which servers or virtual machines (VMs) in your on-premises environment you intend to activate.
     *        In this case, you could specify the following key-value pairs:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>Key=OS,Value=Windows</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>Key=Environment,Value=Production</code>
     *        </p>
     *        </li>
     *        </ul>
     *        <important>
     *        <p>
     *        When you install SSM Agent on your on-premises servers and VMs, you specify an activation ID and code.
     *        When you specify the activation ID and code, tags assigned to the activation are automatically applied to
     *        the on-premises servers or VMs.
     *        </p>
     *        </important>
     *        <p>
     *        You can't add tags to or delete tags from an existing activation. You can tag your on-premises servers,
     *        edge devices, and VMs after they connect to Systems Manager for the first time and are assigned a managed
     *        node ID. This means they are listed in the Amazon Web Services Systems Manager console with an ID that is
     *        prefixed with "mi-". For information about how to add tags to your managed nodes, see
     *        <a>AddTagsToResource</a>. For information about how to remove tags from your managed nodes, see
     *        <a>RemoveTagsFromResource</a>.
     */

    public void setTags(java.util.Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }

        this.tags = new com.amazonaws.internal.SdkInternalList<Tag>(tags);
    }

    /**
     * <p>
     * Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways, such
     * as by purpose, owner, or environment. For example, you might want to tag an activation to identify which servers
     * or virtual machines (VMs) in your on-premises environment you intend to activate. In this case, you could specify
     * the following key-value pairs:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Key=OS,Value=Windows</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Key=Environment,Value=Production</code>
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * When you install SSM Agent on your on-premises servers and VMs, you specify an activation ID and code. When you
     * specify the activation ID and code, tags assigned to the activation are automatically applied to the on-premises
     * servers or VMs.
     * </p>
     * </important>
     * <p>
     * You can't add tags to or delete tags from an existing activation. You can tag your on-premises servers, edge
     * devices, and VMs after they connect to Systems Manager for the first time and are assigned a managed node ID.
     * This means they are listed in the Amazon Web Services Systems Manager console with an ID that is prefixed with
     * "mi-". For information about how to add tags to your managed nodes, see <a>AddTagsToResource</a>. For information
     * about how to remove tags from your managed nodes, see <a>RemoveTagsFromResource</a>.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setTags(java.util.Collection)} or {@link #withTags(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param tags
     *        Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different
     *        ways, such as by purpose, owner, or environment. For example, you might want to tag an activation to
     *        identify which servers or virtual machines (VMs) in your on-premises environment you intend to activate.
     *        In this case, you could specify the following key-value pairs:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>Key=OS,Value=Windows</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>Key=Environment,Value=Production</code>
     *        </p>
     *        </li>
     *        </ul>
     *        <important>
     *        <p>
     *        When you install SSM Agent on your on-premises servers and VMs, you specify an activation ID and code.
     *        When you specify the activation ID and code, tags assigned to the activation are automatically applied to
     *        the on-premises servers or VMs.
     *        </p>
     *        </important>
     *        <p>
     *        You can't add tags to or delete tags from an existing activation. You can tag your on-premises servers,
     *        edge devices, and VMs after they connect to Systems Manager for the first time and are assigned a managed
     *        node ID. This means they are listed in the Amazon Web Services Systems Manager console with an ID that is
     *        prefixed with "mi-". For information about how to add tags to your managed nodes, see
     *        <a>AddTagsToResource</a>. For information about how to remove tags from your managed nodes, see
     *        <a>RemoveTagsFromResource</a>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateActivationRequest withTags(Tag... tags) {
        if (this.tags == null) {
            setTags(new com.amazonaws.internal.SdkInternalList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways, such
     * as by purpose, owner, or environment. For example, you might want to tag an activation to identify which servers
     * or virtual machines (VMs) in your on-premises environment you intend to activate. In this case, you could specify
     * the following key-value pairs:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Key=OS,Value=Windows</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Key=Environment,Value=Production</code>
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * When you install SSM Agent on your on-premises servers and VMs, you specify an activation ID and code. When you
     * specify the activation ID and code, tags assigned to the activation are automatically applied to the on-premises
     * servers or VMs.
     * </p>
     * </important>
     * <p>
     * You can't add tags to or delete tags from an existing activation. You can tag your on-premises servers, edge
     * devices, and VMs after they connect to Systems Manager for the first time and are assigned a managed node ID.
     * This means they are listed in the Amazon Web Services Systems Manager console with an ID that is prefixed with
     * "mi-". For information about how to add tags to your managed nodes, see <a>AddTagsToResource</a>. For information
     * about how to remove tags from your managed nodes, see <a>RemoveTagsFromResource</a>.
     * </p>
     * 
     * @param tags
     *        Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different
     *        ways, such as by purpose, owner, or environment. For example, you might want to tag an activation to
     *        identify which servers or virtual machines (VMs) in your on-premises environment you intend to activate.
     *        In this case, you could specify the following key-value pairs:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>Key=OS,Value=Windows</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>Key=Environment,Value=Production</code>
     *        </p>
     *        </li>
     *        </ul>
     *        <important>
     *        <p>
     *        When you install SSM Agent on your on-premises servers and VMs, you specify an activation ID and code.
     *        When you specify the activation ID and code, tags assigned to the activation are automatically applied to
     *        the on-premises servers or VMs.
     *        </p>
     *        </important>
     *        <p>
     *        You can't add tags to or delete tags from an existing activation. You can tag your on-premises servers,
     *        edge devices, and VMs after they connect to Systems Manager for the first time and are assigned a managed
     *        node ID. This means they are listed in the Amazon Web Services Systems Manager console with an ID that is
     *        prefixed with "mi-". For information about how to add tags to your managed nodes, see
     *        <a>AddTagsToResource</a>. For information about how to remove tags from your managed nodes, see
     *        <a>RemoveTagsFromResource</a>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateActivationRequest withTags(java.util.Collection<Tag> tags) {
        setTags(tags);
        return this;
    }

    /**
     * <p>
     * Reserved for internal use.
     * </p>
     * 
     * @return Reserved for internal use.
     */

    public java.util.List<RegistrationMetadataItem> getRegistrationMetadata() {
        if (registrationMetadata == null) {
            registrationMetadata = new com.amazonaws.internal.SdkInternalList<RegistrationMetadataItem>();
        }
        return registrationMetadata;
    }

    /**
     * <p>
     * Reserved for internal use.
     * </p>
     * 
     * @param registrationMetadata
     *        Reserved for internal use.
     */

    public void setRegistrationMetadata(java.util.Collection<RegistrationMetadataItem> registrationMetadata) {
        if (registrationMetadata == null) {
            this.registrationMetadata = null;
            return;
        }

        this.registrationMetadata = new com.amazonaws.internal.SdkInternalList<RegistrationMetadataItem>(registrationMetadata);
    }

    /**
     * <p>
     * Reserved for internal use.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setRegistrationMetadata(java.util.Collection)} or {@link #withRegistrationMetadata(java.util.Collection)}
     * if you want to override the existing values.
     * </p>
     * 
     * @param registrationMetadata
     *        Reserved for internal use.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateActivationRequest withRegistrationMetadata(RegistrationMetadataItem... registrationMetadata) {
        if (this.registrationMetadata == null) {
            setRegistrationMetadata(new com.amazonaws.internal.SdkInternalList<RegistrationMetadataItem>(registrationMetadata.length));
        }
        for (RegistrationMetadataItem ele : registrationMetadata) {
            this.registrationMetadata.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Reserved for internal use.
     * </p>
     * 
     * @param registrationMetadata
     *        Reserved for internal use.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateActivationRequest withRegistrationMetadata(java.util.Collection<RegistrationMetadataItem> registrationMetadata) {
        setRegistrationMetadata(registrationMetadata);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getDescription() != null)
            sb.append("Description: ").append(getDescription()).append(",");
        if (getDefaultInstanceName() != null)
            sb.append("DefaultInstanceName: ").append(getDefaultInstanceName()).append(",");
        if (getIamRole() != null)
            sb.append("IamRole: ").append(getIamRole()).append(",");
        if (getRegistrationLimit() != null)
            sb.append("RegistrationLimit: ").append(getRegistrationLimit()).append(",");
        if (getExpirationDate() != null)
            sb.append("ExpirationDate: ").append(getExpirationDate()).append(",");
        if (getTags() != null)
            sb.append("Tags: ").append(getTags()).append(",");
        if (getRegistrationMetadata() != null)
            sb.append("RegistrationMetadata: ").append(getRegistrationMetadata());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CreateActivationRequest == false)
            return false;
        CreateActivationRequest other = (CreateActivationRequest) obj;
        if (other.getDescription() == null ^ this.getDescription() == null)
            return false;
        if (other.getDescription() != null && other.getDescription().equals(this.getDescription()) == false)
            return false;
        if (other.getDefaultInstanceName() == null ^ this.getDefaultInstanceName() == null)
            return false;
        if (other.getDefaultInstanceName() != null && other.getDefaultInstanceName().equals(this.getDefaultInstanceName()) == false)
            return false;
        if (other.getIamRole() == null ^ this.getIamRole() == null)
            return false;
        if (other.getIamRole() != null && other.getIamRole().equals(this.getIamRole()) == false)
            return false;
        if (other.getRegistrationLimit() == null ^ this.getRegistrationLimit() == null)
            return false;
        if (other.getRegistrationLimit() != null && other.getRegistrationLimit().equals(this.getRegistrationLimit()) == false)
            return false;
        if (other.getExpirationDate() == null ^ this.getExpirationDate() == null)
            return false;
        if (other.getExpirationDate() != null && other.getExpirationDate().equals(this.getExpirationDate()) == false)
            return false;
        if (other.getTags() == null ^ this.getTags() == null)
            return false;
        if (other.getTags() != null && other.getTags().equals(this.getTags()) == false)
            return false;
        if (other.getRegistrationMetadata() == null ^ this.getRegistrationMetadata() == null)
            return false;
        if (other.getRegistrationMetadata() != null && other.getRegistrationMetadata().equals(this.getRegistrationMetadata()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getDescription() == null) ? 0 : getDescription().hashCode());
        hashCode = prime * hashCode + ((getDefaultInstanceName() == null) ? 0 : getDefaultInstanceName().hashCode());
        hashCode = prime * hashCode + ((getIamRole() == null) ? 0 : getIamRole().hashCode());
        hashCode = prime * hashCode + ((getRegistrationLimit() == null) ? 0 : getRegistrationLimit().hashCode());
        hashCode = prime * hashCode + ((getExpirationDate() == null) ? 0 : getExpirationDate().hashCode());
        hashCode = prime * hashCode + ((getTags() == null) ? 0 : getTags().hashCode());
        hashCode = prime * hashCode + ((getRegistrationMetadata() == null) ? 0 : getRegistrationMetadata().hashCode());
        return hashCode;
    }

    @Override
    public CreateActivationRequest clone() {
        return (CreateActivationRequest) super.clone();
    }

}
