/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.s3control.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * <p>
 * The Amazon Web Services Security Token Service temporary credential that S3 Access Grants vends to grantees and
 * client applications.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/Credentials" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class Credentials implements Serializable, Cloneable {

    /**
     * <p>
     * The unique access key ID of the Amazon Web Services STS temporary credential that S3 Access Grants vends to
     * grantees and client applications.
     * </p>
     */
    private String accessKeyId;
    /**
     * <p>
     * The secret access key of the Amazon Web Services STS temporary credential that S3 Access Grants vends to grantees
     * and client applications.
     * </p>
     */
    private String secretAccessKey;
    /**
     * <p>
     * The Amazon Web Services STS temporary credential that S3 Access Grants vends to grantees and client applications.
     * </p>
     */
    private String sessionToken;
    /**
     * <p>
     * The expiration date and time of the temporary credential that S3 Access Grants vends to grantees and client
     * applications.
     * </p>
     */
    private java.util.Date expiration;

    /**
     * <p>
     * The unique access key ID of the Amazon Web Services STS temporary credential that S3 Access Grants vends to
     * grantees and client applications.
     * </p>
     * 
     * @param accessKeyId
     *        The unique access key ID of the Amazon Web Services STS temporary credential that S3 Access Grants vends
     *        to grantees and client applications.
     */

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    /**
     * <p>
     * The unique access key ID of the Amazon Web Services STS temporary credential that S3 Access Grants vends to
     * grantees and client applications.
     * </p>
     * 
     * @return The unique access key ID of the Amazon Web Services STS temporary credential that S3 Access Grants vends
     *         to grantees and client applications.
     */

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    /**
     * <p>
     * The unique access key ID of the Amazon Web Services STS temporary credential that S3 Access Grants vends to
     * grantees and client applications.
     * </p>
     * 
     * @param accessKeyId
     *        The unique access key ID of the Amazon Web Services STS temporary credential that S3 Access Grants vends
     *        to grantees and client applications.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Credentials withAccessKeyId(String accessKeyId) {
        setAccessKeyId(accessKeyId);
        return this;
    }

    /**
     * <p>
     * The secret access key of the Amazon Web Services STS temporary credential that S3 Access Grants vends to grantees
     * and client applications.
     * </p>
     * 
     * @param secretAccessKey
     *        The secret access key of the Amazon Web Services STS temporary credential that S3 Access Grants vends to
     *        grantees and client applications.
     */

    public void setSecretAccessKey(String secretAccessKey) {
        this.secretAccessKey = secretAccessKey;
    }

    /**
     * <p>
     * The secret access key of the Amazon Web Services STS temporary credential that S3 Access Grants vends to grantees
     * and client applications.
     * </p>
     * 
     * @return The secret access key of the Amazon Web Services STS temporary credential that S3 Access Grants vends to
     *         grantees and client applications.
     */

    public String getSecretAccessKey() {
        return this.secretAccessKey;
    }

    /**
     * <p>
     * The secret access key of the Amazon Web Services STS temporary credential that S3 Access Grants vends to grantees
     * and client applications.
     * </p>
     * 
     * @param secretAccessKey
     *        The secret access key of the Amazon Web Services STS temporary credential that S3 Access Grants vends to
     *        grantees and client applications.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Credentials withSecretAccessKey(String secretAccessKey) {
        setSecretAccessKey(secretAccessKey);
        return this;
    }

    /**
     * <p>
     * The Amazon Web Services STS temporary credential that S3 Access Grants vends to grantees and client applications.
     * </p>
     * 
     * @param sessionToken
     *        The Amazon Web Services STS temporary credential that S3 Access Grants vends to grantees and client
     *        applications.
     */

    public void setSessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
    }

    /**
     * <p>
     * The Amazon Web Services STS temporary credential that S3 Access Grants vends to grantees and client applications.
     * </p>
     * 
     * @return The Amazon Web Services STS temporary credential that S3 Access Grants vends to grantees and client
     *         applications.
     */

    public String getSessionToken() {
        return this.sessionToken;
    }

    /**
     * <p>
     * The Amazon Web Services STS temporary credential that S3 Access Grants vends to grantees and client applications.
     * </p>
     * 
     * @param sessionToken
     *        The Amazon Web Services STS temporary credential that S3 Access Grants vends to grantees and client
     *        applications.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Credentials withSessionToken(String sessionToken) {
        setSessionToken(sessionToken);
        return this;
    }

    /**
     * <p>
     * The expiration date and time of the temporary credential that S3 Access Grants vends to grantees and client
     * applications.
     * </p>
     * 
     * @param expiration
     *        The expiration date and time of the temporary credential that S3 Access Grants vends to grantees and
     *        client applications.
     */

    public void setExpiration(java.util.Date expiration) {
        this.expiration = expiration;
    }

    /**
     * <p>
     * The expiration date and time of the temporary credential that S3 Access Grants vends to grantees and client
     * applications.
     * </p>
     * 
     * @return The expiration date and time of the temporary credential that S3 Access Grants vends to grantees and
     *         client applications.
     */

    public java.util.Date getExpiration() {
        return this.expiration;
    }

    /**
     * <p>
     * The expiration date and time of the temporary credential that S3 Access Grants vends to grantees and client
     * applications.
     * </p>
     * 
     * @param expiration
     *        The expiration date and time of the temporary credential that S3 Access Grants vends to grantees and
     *        client applications.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Credentials withExpiration(java.util.Date expiration) {
        setExpiration(expiration);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAccessKeyId() != null)
            sb.append("AccessKeyId: ").append("***Sensitive Data Redacted***").append(",");
        if (getSecretAccessKey() != null)
            sb.append("SecretAccessKey: ").append("***Sensitive Data Redacted***").append(",");
        if (getSessionToken() != null)
            sb.append("SessionToken: ").append("***Sensitive Data Redacted***").append(",");
        if (getExpiration() != null)
            sb.append("Expiration: ").append(getExpiration());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof Credentials == false)
            return false;
        Credentials other = (Credentials) obj;
        if (other.getAccessKeyId() == null ^ this.getAccessKeyId() == null)
            return false;
        if (other.getAccessKeyId() != null && other.getAccessKeyId().equals(this.getAccessKeyId()) == false)
            return false;
        if (other.getSecretAccessKey() == null ^ this.getSecretAccessKey() == null)
            return false;
        if (other.getSecretAccessKey() != null && other.getSecretAccessKey().equals(this.getSecretAccessKey()) == false)
            return false;
        if (other.getSessionToken() == null ^ this.getSessionToken() == null)
            return false;
        if (other.getSessionToken() != null && other.getSessionToken().equals(this.getSessionToken()) == false)
            return false;
        if (other.getExpiration() == null ^ this.getExpiration() == null)
            return false;
        if (other.getExpiration() != null && other.getExpiration().equals(this.getExpiration()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getAccessKeyId() == null) ? 0 : getAccessKeyId().hashCode());
        hashCode = prime * hashCode + ((getSecretAccessKey() == null) ? 0 : getSecretAccessKey().hashCode());
        hashCode = prime * hashCode + ((getSessionToken() == null) ? 0 : getSessionToken().hashCode());
        hashCode = prime * hashCode + ((getExpiration() == null) ? 0 : getExpiration().hashCode());
        return hashCode;
    }

    @Override
    public Credentials clone() {
        try {
            return (Credentials) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
