/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.rekognition.model.TestingData;
import java.util.List;

@SdkInternalApi
public class TestingDataMarshaller {
    private static final MarshallingInfo<List> ASSETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Assets").build();
    private static final MarshallingInfo<Boolean> AUTOCREATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoCreate").build();
    private static final TestingDataMarshaller instance = new TestingDataMarshaller();

    public static TestingDataMarshaller getInstance() {
        return instance;
    }

    public void marshall(TestingData testingData, ProtocolMarshaller protocolMarshaller) {
        if (testingData == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(testingData.getAssets(), ASSETS_BINDING);
            protocolMarshaller.marshall((Object)testingData.getAutoCreate(), AUTOCREATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

