/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.nimblestudio.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.nimblestudio.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * StudioComponentConfigurationMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class StudioComponentConfigurationMarshaller {

    private static final MarshallingInfo<StructuredPojo> ACTIVEDIRECTORYCONFIGURATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("activeDirectoryConfiguration").build();
    private static final MarshallingInfo<StructuredPojo> COMPUTEFARMCONFIGURATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("computeFarmConfiguration").build();
    private static final MarshallingInfo<StructuredPojo> LICENSESERVICECONFIGURATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("licenseServiceConfiguration").build();
    private static final MarshallingInfo<StructuredPojo> SHAREDFILESYSTEMCONFIGURATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sharedFileSystemConfiguration").build();

    private static final StudioComponentConfigurationMarshaller instance = new StudioComponentConfigurationMarshaller();

    public static StudioComponentConfigurationMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(StudioComponentConfiguration studioComponentConfiguration, ProtocolMarshaller protocolMarshaller) {

        if (studioComponentConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(studioComponentConfiguration.getActiveDirectoryConfiguration(), ACTIVEDIRECTORYCONFIGURATION_BINDING);
            protocolMarshaller.marshall(studioComponentConfiguration.getComputeFarmConfiguration(), COMPUTEFARMCONFIGURATION_BINDING);
            protocolMarshaller.marshall(studioComponentConfiguration.getLicenseServiceConfiguration(), LICENSESERVICECONFIGURATION_BINDING);
            protocolMarshaller.marshall(studioComponentConfiguration.getSharedFileSystemConfiguration(), SHAREDFILESYSTEMCONFIGURATION_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
